/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.jaxrs;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresGuest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.apache.shiro.authz.annotation.RequiresUser;
import org.apache.shiro.authz.aop.AuthenticatedAnnotationHandler;
import org.apache.shiro.authz.aop.AuthorizingAnnotationHandler;
import org.apache.shiro.authz.aop.DenyAllAnnotationHandler;
import org.apache.shiro.authz.aop.GuestAnnotationHandler;
import org.apache.shiro.authz.aop.PermissionAnnotationHandler;
import org.apache.shiro.authz.aop.PermitAllAnnotationHandler;
import org.apache.shiro.authz.aop.RoleAnnotationHandler;
import org.apache.shiro.authz.aop.RolesAllowedAnnotationHandler;
import org.apache.shiro.authz.aop.UserAnnotationHandler;

public class AnnotationAuthorizationFilter
implements ContainerRequestFilter {
    private final Map<AuthorizingAnnotationHandler, Annotation> authzChecks;

    public AnnotationAuthorizationFilter(Collection<Annotation> authzSpecs) {
        HashMap<AuthorizingAnnotationHandler, Annotation> authChecks = new HashMap<AuthorizingAnnotationHandler, Annotation>(authzSpecs.size());
        for (Annotation authSpec : authzSpecs) {
            authChecks.put(AnnotationAuthorizationFilter.createHandler(authSpec), authSpec);
        }
        this.authzChecks = Collections.unmodifiableMap(authChecks);
    }

    private static AuthorizingAnnotationHandler createHandler(Annotation annotation) {
        Class<? extends Annotation> t = annotation.annotationType();
        if (RequiresPermissions.class.equals(t)) {
            return new PermissionAnnotationHandler();
        }
        if (RequiresRoles.class.equals(t)) {
            return new RoleAnnotationHandler();
        }
        if (RequiresUser.class.equals(t)) {
            return new UserAnnotationHandler();
        }
        if (RequiresGuest.class.equals(t)) {
            return new GuestAnnotationHandler();
        }
        if (RequiresAuthentication.class.equals(t)) {
            return new AuthenticatedAnnotationHandler();
        }
        if (RolesAllowed.class.equals(t)) {
            return new RolesAllowedAnnotationHandler();
        }
        if (PermitAll.class.equals(t)) {
            return new PermitAllAnnotationHandler();
        }
        if (DenyAll.class.equals(t)) {
            return new DenyAllAnnotationHandler();
        }
        throw new IllegalArgumentException("Cannot create a handler for the unknown for annotation " + String.valueOf(t));
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        for (Map.Entry<AuthorizingAnnotationHandler, Annotation> authzCheck : this.authzChecks.entrySet()) {
            AuthorizingAnnotationHandler handler = authzCheck.getKey();
            Annotation authzSpec = authzCheck.getValue();
            handler.assertAuthorized(authzSpec);
        }
    }
}

