/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.ee.faces.tags;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import javax.faces.context.FacesContext;
import lombok.Generated;
import org.apache.shiro.ee.faces.tags.SecureComponent;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrincipalTag
extends SecureComponent {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PrincipalTag.class);
    private String type;
    private String property;
    private String defaultValue;
    private Object[] values;

    @Override
    protected void doEncodeAll(FacesContext ctx) throws IOException {
        String strValue = null;
        try {
            Object principal;
            if (this.getSubject() != null && (principal = this.type == null ? this.getSubject().getPrincipal() : this.getPrincipalFromClassName()) != null) {
                strValue = this.property == null ? principal.toString() : this.getPrincipalProperty(principal, this.property);
            }
        }
        catch (IOException e) {
            log.error("Error getting principal type [" + this.type + "], property [" + this.property + "]: " + e.getMessage(), (Throwable)e);
        }
        if (strValue == null) {
            strValue = this.defaultValue;
        }
        if (strValue != null) {
            try {
                ctx.getResponseWriter().write(strValue);
            }
            catch (IOException e) {
                throw new IOException("Error writing [" + strValue + "] to output.");
            }
        }
    }

    private Object getPrincipalFromClassName() {
        Object principal;
        block5: {
            principal = null;
            try {
                Class<?> cls = Class.forName(this.type);
                PrincipalCollection principals = this.getSubject().getPrincipals();
                if (principals != null) {
                    principal = principals.oneByType(cls);
                }
            }
            catch (ClassNotFoundException e) {
                if (log.isErrorEnabled()) {
                    log.error("Unable to find class for name [" + this.type + "]");
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block5;
                log.error("Unknown error while getting principal for type [" + this.type + "]: " + e.getMessage(), (Throwable)e);
            }
        }
        return principal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPrincipalProperty(Object principal, String property) throws IOException {
        String strValue = null;
        try {
            BeanInfo bi = Introspector.getBeanInfo(principal.getClass());
            boolean foundProperty = false;
            for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
                if (!pd.getName().equals(property) || !Modifier.isPublic(pd.getReadMethod().getModifiers())) continue;
                Object value = null;
                try {
                    pd.getReadMethod().setAccessible(true);
                    value = pd.getReadMethod().invoke(principal, (Object[])null);
                }
                finally {
                    pd.getReadMethod().setAccessible(false);
                }
                strValue = String.valueOf(value);
                foundProperty = true;
                break;
            }
            if (!foundProperty) {
                String message = "Property [" + property + "] not found in principal of type [" + principal.getClass().getName() + "]";
                if (log.isErrorEnabled()) {
                    log.error(message);
                }
                throw new IOException(message);
            }
        }
        catch (IntrospectionException | IOException | IllegalAccessException | InvocationTargetException e) {
            String message = "Error reading property [" + property + "] from principal of type [" + principal.getClass().getName() + "]";
            if (log.isErrorEnabled()) {
                log.error(message, (Throwable)e);
            }
            throw new IOException(message);
        }
        return strValue;
    }

    public Object saveState(FacesContext context) {
        if (this.values == null) {
            this.values = new Object[4];
        }
        this.values[0] = super.saveState(context);
        this.values[1] = this.type;
        this.values[2] = this.property;
        this.values[3] = this.defaultValue;
        return this.values;
    }

    public void restoreState(FacesContext context, Object state) {
        this.values = (Object[])state;
        super.restoreState(context, this.values[0]);
        this.type = (String)this.values[1];
        this.property = (String)this.values[2];
        this.defaultValue = (String)this.values[3];
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public String getProperty() {
        return this.property;
    }

    @Generated
    public void setProperty(String property) {
        this.property = property;
    }

    @Generated
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }
}

