/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.ee.cdi;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.WithAnnotations;
import javax.faces.view.ViewScoped;
import org.apache.shiro.cdi.AnnotatedTypeWrapper;
import org.apache.shiro.cdi.ShiroSecurityExtension;
import org.apache.shiro.ee.cdi.ShiroFacesViewScoped;
import org.apache.shiro.ee.cdi.ShiroOmniViewScoped;
import org.apache.shiro.ee.cdi.ShiroScopeContext;
import org.apache.shiro.ee.cdi.ShiroSessionScoped;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.SessionListener;

public class ShiroSessionScopeExtension
implements Extension,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final List<ShiroScopeContext> contexts = Stream.of(new ShiroScopeContext(ShiroSessionScoped.class, SessionScoped.class), new ShiroScopeContext(ShiroFacesViewScoped.class, ViewScoped.class), new ShiroScopeContext(ShiroOmniViewScoped.class, org.omnifaces.cdi.ViewScoped.class)).collect(Collectors.toList());

    public void addSessionListeners(Collection<SessionListener> sessionListeners, SecurityManager sm) {
        sessionListeners.add(new SessionListener(){

            public void onStart(Session session) {
                contexts.forEach(ctx -> ctx.onCreate(session));
            }

            public void onStop(Session session) {
                contexts.forEach(ctx -> ctx.onDestroy(session));
            }

            public void onExpiration(Session session) {
                this.onStop(session);
            }
        });
    }

    <T> void addSessionScoped(@Observes @WithAnnotations(value={SessionScoped.class}) ProcessAnnotatedType<T> pat) {
        pat.setAnnotatedType((AnnotatedType)new AnnotatedTypeWrapper(pat.getAnnotatedType(), true, Set.of(ShiroSessionScopedAnnotated.class.getDeclaredAnnotations()[0], ShiroSecurityExtension.ShiroSecureAnnotated.class.getDeclaredAnnotations()[0]), Set.of(SessionScopedAnnotated.class.getDeclaredAnnotations()[0])));
    }

    <T> void addFacesViewScoped(@Observes @WithAnnotations(value={ViewScoped.class}) ProcessAnnotatedType<T> pat) {
        pat.setAnnotatedType((AnnotatedType)new AnnotatedTypeWrapper(pat.getAnnotatedType(), true, Set.of(ShiroFacesViewScopedAnnotated.class.getDeclaredAnnotations()[0], ShiroSecurityExtension.ShiroSecureAnnotated.class.getDeclaredAnnotations()[0]), Set.of(FacesViewScopedAnnotated.class.getDeclaredAnnotations()[0])));
    }

    <T> void addOmniViewScoped(@Observes @WithAnnotations(value={org.omnifaces.cdi.ViewScoped.class}) ProcessAnnotatedType<T> pat) {
        pat.setAnnotatedType((AnnotatedType)new AnnotatedTypeWrapper(pat.getAnnotatedType(), true, Set.of(ShiroOmniViewScopedAnnotated.class.getDeclaredAnnotations()[0], ShiroSecurityExtension.ShiroSecureAnnotated.class.getDeclaredAnnotations()[0]), Set.of(OmniViewScopedAnnotated.class.getDeclaredAnnotations()[0])));
    }

    void addScope(@Observes BeforeBeanDiscovery event) {
        contexts.forEach(ctx -> event.addScope(ctx.getScope(), true, true));
    }

    void registerContext(@Observes AfterBeanDiscovery event) {
        contexts.forEach(arg_0 -> ((AfterBeanDiscovery)event).addContext(arg_0));
    }

    @ShiroSessionScoped
    private static final class ShiroSessionScopedAnnotated
    implements Serializable {
        private ShiroSessionScopedAnnotated() {
        }
    }

    @SessionScoped
    private static final class SessionScopedAnnotated
    implements Serializable {
        private SessionScopedAnnotated() {
        }
    }

    @ShiroFacesViewScoped
    private static final class ShiroFacesViewScopedAnnotated
    implements Serializable {
        private ShiroFacesViewScopedAnnotated() {
        }
    }

    @ViewScoped
    private static final class FacesViewScopedAnnotated
    implements Serializable {
        private FacesViewScopedAnnotated() {
        }
    }

    @ShiroOmniViewScoped
    private static final class ShiroOmniViewScopedAnnotated
    implements Serializable {
        private ShiroOmniViewScopedAnnotated() {
        }
    }

    @org.omnifaces.cdi.ViewScoped
    private static final class OmniViewScopedAnnotated
    implements Serializable {
        private OmniViewScopedAnnotated() {
        }
    }
}

