/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.maven.plugin.xfire;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.codehaus.xfire.gen.WsGenTask;

public class WsgenMojo
extends AbstractMojo {
    private MavenProject project;
    private List wsdls;
    private String thePackage;
    private String profile;
    private String binding;
    private File outputDirectory;
    private PrintStream systemErr;
    private final PrintStream mySystemErr = new PrintStream(new MyErrorStream());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        this.systemErr = System.err;
        System.setErr(this.mySystemErr);
        try {
            this.exec();
        }
        finally {
            System.setErr(this.systemErr);
        }
    }

    private void exec() throws MojoExecutionException {
        if (this.wsdls.size() == 0) {
            return;
        }
        if (!this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
            this.getLog().warn((CharSequence)("the output directory " + this.outputDirectory + " doesn't exist and couldn't be created. The goal with probably fail."));
        }
        Project antProject = new Project();
        antProject.addBuildListener((BuildListener)new DebugAntBuildListener());
        WsGenTask task = new WsGenTask();
        task.setProject(antProject);
        if (this.binding != null) {
            task.setBinding(this.binding);
        }
        if (this.profile != null) {
            task.setProfile(this.profile);
        }
        if (this.thePackage != null) {
            task.setPackage(this.thePackage);
        }
        task.setOutputDirectory(this.outputDirectory.getAbsolutePath());
        for (String wsdlUrl : this.wsdls) {
            if (!wsdlUrl.contains("://")) {
                wsdlUrl = new File(wsdlUrl).toURI().toString();
            }
            task.setWsdl(wsdlUrl);
            this.getLog().info((CharSequence)("Executing XFire WsGen task with url: " + wsdlUrl));
            try {
                task.execute();
            }
            catch (BuildException e) {
                throw new MojoExecutionException("command execution failed", (Exception)((Object)e));
            }
        }
        this.getLog().debug((CharSequence)("Adding outputDirectory to source root: " + this.outputDirectory));
        this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
    }

    private class DebugAntBuildListener
    implements BuildListener {
        private DebugAntBuildListener() {
        }

        public void buildStarted(BuildEvent buildEvent) {
            WsgenMojo.this.getLog().debug((CharSequence)buildEvent.getMessage());
        }

        public void buildFinished(BuildEvent buildEvent) {
            WsgenMojo.this.getLog().debug((CharSequence)buildEvent.getMessage());
        }

        public void targetStarted(BuildEvent buildEvent) {
            WsgenMojo.this.getLog().debug((CharSequence)buildEvent.getMessage());
        }

        public void targetFinished(BuildEvent buildEvent) {
            WsgenMojo.this.getLog().debug((CharSequence)buildEvent.getMessage());
        }

        public void taskStarted(BuildEvent buildEvent) {
            WsgenMojo.this.getLog().debug((CharSequence)buildEvent.getMessage());
        }

        public void taskFinished(BuildEvent buildEvent) {
            WsgenMojo.this.getLog().debug((CharSequence)buildEvent.getMessage());
        }

        public void messageLogged(BuildEvent buildEvent) {
            WsgenMojo.this.getLog().debug((CharSequence)buildEvent.getMessage());
        }
    }

    class MyOutputStream
    extends OutputStream {
        private StringBuffer buffer = new StringBuffer();

        MyOutputStream() {
        }

        public void write(int b) throws IOException {
            char c = (char)b;
            if (c == '\n') {
                WsgenMojo.this.getLog().info((CharSequence)this.buffer);
                this.buffer = new StringBuffer();
            } else {
                this.buffer.append(c);
            }
        }
    }

    class MyErrorStream
    extends OutputStream {
        private StringBuffer buffer = new StringBuffer();

        MyErrorStream() {
        }

        public void write(int b) throws IOException {
            char c = (char)b;
            if (c == '\n') {
                WsgenMojo.this.getLog().error((CharSequence)this.buffer);
                this.buffer = new StringBuffer();
            } else {
                this.buffer.append(c);
            }
        }
    }
}

