/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.maven.plugin.xsd;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class SpringSchemasMojo
extends AbstractMojo {
    private static final String PREVIOUS_RELEASES = "previous.releases";
    private String[] previous = new String[0];
    private List<String> locations = new ArrayList<String>(){

        @Override
        public boolean add(String element) {
            SpringSchemasMojo.this.getLog().info((CharSequence)("Adding location " + element));
            return super.add(element);
        }
    };
    private String schema;
    protected MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.getSpringSchemas().exists()) {
            this.getLog().info((CharSequence)("Skipping - spring.schemas file does not exist in " + this.project.getArtifactId()));
            return;
        }
        this.readOriginalSpringSchemas();
        this.getLog().info((CharSequence)"Adding spring.schemas entries for earlier versions");
        if (this.project.getProperties().containsKey(PREVIOUS_RELEASES)) {
            this.previous = ((String)this.project.getProperties().get(PREVIOUS_RELEASES)).split(",");
        } else {
            this.getLog().warn((CharSequence)"No previous version information found");
            for (Object key : this.project.getProperties().keySet()) {
                this.getLog().info((CharSequence)("'" + key.toString() + "'" + " = " + this.project.getProperties().get(key)));
            }
        }
        for (String version : this.previous) {
            this.addVersion(version);
        }
        this.getLog().info((CharSequence)"Adding spring.schemas entry for this version");
        this.addVersion(this.project.getVersion());
        this.writeNewSpringSchemas();
    }

    private void writeNewSpringSchemas() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Writing new spring.schemas file");
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new BufferedWriter(new FileWriter(this.getSpringSchemas())));
            for (String location : this.locations) {
                writer.println(location + "=" + this.schema);
            }
            writer.flush();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to read spring.schemas file", (Exception)e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private void readOriginalSpringSchemas() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Reading information from spring.schemas");
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(this.getSpringSchemas()));
            String line = reader.readLine();
            while (line != null) {
                if (line.contains("=")) {
                    String[] info = line.split("=");
                    if (this.schema == null) {
                        this.getLog().info((CharSequence)("Schema name is " + info[1]));
                        this.schema = info[1];
                    }
                    this.locations.add(info[0]);
                }
                line = reader.readLine();
            }
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Unable to read spring.schemas file", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to read spring.schemas file", (Exception)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable to close file reader", (Exception)e);
                }
            }
        }
    }

    private File getSpringSchemas() {
        return new File(this.project.getBasedir().toString() + File.separatorChar + "target" + File.separatorChar + "classes" + File.separatorChar + "META-INF", "spring.schemas");
    }

    private void addVersion(String version) {
        this.locations.add("http\\://servicemix.apache.org/schema/" + this.project.getArtifactId() + "-" + version + ".xsd");
    }
}

