/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.collapse;

import java.util.Collections;
import java.util.List;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.grouping.CollapsingTopDocsCollector;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.query.InnerHitBuilder;

public class CollapseContext {
    private final MappedFieldType fieldType;
    private final List<InnerHitBuilder> innerHits;

    public CollapseContext(MappedFieldType fieldType, InnerHitBuilder innerHit) {
        this.fieldType = fieldType;
        this.innerHits = Collections.singletonList(innerHit);
    }

    public CollapseContext(MappedFieldType fieldType, List<InnerHitBuilder> innerHits) {
        this.fieldType = fieldType;
        this.innerHits = innerHits;
    }

    public MappedFieldType getFieldType() {
        return this.fieldType;
    }

    public List<InnerHitBuilder> getInnerHit() {
        return this.innerHits;
    }

    public CollapsingTopDocsCollector<?> createTopDocs(Sort sort, int topN, boolean trackMaxScore) {
        if (this.fieldType instanceof KeywordFieldMapper.KeywordFieldType) {
            return CollapsingTopDocsCollector.createKeyword(this.fieldType.name(), sort, topN, trackMaxScore);
        }
        if (this.fieldType instanceof NumberFieldMapper.NumberFieldType) {
            return CollapsingTopDocsCollector.createNumeric(this.fieldType.name(), sort, topN, trackMaxScore);
        }
        throw new IllegalStateException("unknown type for collapse field " + this.fieldType.name() + ", only keywords and numbers are accepted");
    }
}

