/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FilterWeight;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.ScoreMode;
import org.apache.lucene.util.BitSet;

public class ToParentBlockJoinQuery
extends Query {
    private final BitSetProducer parentsFilter;
    private final Query childQuery;
    private final ScoreMode scoreMode;

    public ToParentBlockJoinQuery(Query childQuery, BitSetProducer parentsFilter, ScoreMode scoreMode) {
        this.childQuery = childQuery;
        this.parentsFilter = parentsFilter;
        this.scoreMode = scoreMode;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        return new BlockJoinWeight(this, this.childQuery.createWeight(searcher, needsScores, boost), this.parentsFilter, needsScores ? this.scoreMode : ScoreMode.None);
    }

    public Query getChildQuery() {
        return this.childQuery;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query childRewrite = this.childQuery.rewrite(reader);
        if (childRewrite != this.childQuery) {
            return new ToParentBlockJoinQuery(childRewrite, this.parentsFilter, this.scoreMode);
        }
        return super.rewrite(reader);
    }

    @Override
    public String toString(String field) {
        return "ToParentBlockJoinQuery (" + this.childQuery.toString() + ")";
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((ToParentBlockJoinQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(ToParentBlockJoinQuery other) {
        return this.childQuery.equals(other.childQuery) && this.parentsFilter.equals(other.parentsFilter) && this.scoreMode == other.scoreMode;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int hash = this.classHash();
        hash = 31 * hash + this.childQuery.hashCode();
        hash = 31 * hash + this.scoreMode.hashCode();
        hash = 31 * hash + this.parentsFilter.hashCode();
        return hash;
    }

    static class BlockJoinScorer
    extends Scorer {
        private final Scorer childScorer;
        private final BitSet parentBits;
        private final ScoreMode scoreMode;
        private final DocIdSetIterator childApproximation;
        private final TwoPhaseIterator childTwoPhase;
        private final ParentApproximation parentApproximation;
        private final ParentTwoPhase parentTwoPhase;
        private float score;

        public BlockJoinScorer(Weight weight, Scorer childScorer, BitSet parentBits, ScoreMode scoreMode) {
            super(weight);
            this.parentBits = parentBits;
            this.childScorer = childScorer;
            this.scoreMode = scoreMode;
            this.childTwoPhase = childScorer.twoPhaseIterator();
            if (this.childTwoPhase == null) {
                this.childApproximation = childScorer.iterator();
                this.parentApproximation = new ParentApproximation(this.childApproximation, parentBits);
                this.parentTwoPhase = null;
            } else {
                this.childApproximation = this.childTwoPhase.approximation();
                this.parentApproximation = new ParentApproximation(this.childTwoPhase.approximation(), parentBits);
                this.parentTwoPhase = new ParentTwoPhase(this.parentApproximation, this.childTwoPhase);
            }
        }

        @Override
        public Collection<Scorer.ChildScorer> getChildren() {
            return Collections.singleton(new Scorer.ChildScorer(this.childScorer, "BLOCK_JOIN"));
        }

        @Override
        public DocIdSetIterator iterator() {
            if (this.parentTwoPhase == null) {
                return this.parentApproximation;
            }
            return TwoPhaseIterator.asDocIdSetIterator(this.parentTwoPhase);
        }

        @Override
        public TwoPhaseIterator twoPhaseIterator() {
            return this.parentTwoPhase;
        }

        @Override
        public int docID() {
            return this.parentApproximation.docID();
        }

        @Override
        public float score() throws IOException {
            this.setScoreAndFreq();
            return this.score;
        }

        private void setScoreAndFreq() throws IOException {
            if (this.childApproximation.docID() >= this.parentApproximation.docID()) {
                return;
            }
            double score = this.scoreMode == ScoreMode.None ? 0.0 : (double)this.childScorer.score();
            int freq = 1;
            block6: while (this.childApproximation.nextDoc() < this.parentApproximation.docID()) {
                if (this.childTwoPhase != null && !this.childTwoPhase.matches()) continue;
                float childScore = this.childScorer.score();
                ++freq;
                switch (this.scoreMode) {
                    case Total: 
                    case Avg: {
                        score += (double)childScore;
                        continue block6;
                    }
                    case Min: {
                        score = Math.min(score, (double)childScore);
                        continue block6;
                    }
                    case Max: {
                        score = Math.max(score, (double)childScore);
                        continue block6;
                    }
                    case None: {
                        continue block6;
                    }
                }
                throw new AssertionError();
            }
            if (this.childApproximation.docID() == this.parentApproximation.docID() && (this.childTwoPhase == null || this.childTwoPhase.matches())) {
                throw new IllegalStateException("Child query must not match same docs with parent filter. Combine them as must clauses (+) to find a problem doc. docId=" + this.parentApproximation.docID() + ", " + this.childScorer.getClass());
            }
            if (this.scoreMode == ScoreMode.Avg) {
                score /= (double)freq;
            }
            this.score = (float)score;
        }

        public Explanation explain(LeafReaderContext context, Weight childWeight) throws IOException {
            int prevParentDoc = this.parentBits.prevSetBit(this.parentApproximation.docID() - 1);
            int start = context.docBase + prevParentDoc + 1;
            int end = context.docBase + this.parentApproximation.docID() - 1;
            Explanation bestChild = null;
            int matches = 0;
            for (int childDoc = start; childDoc <= end; ++childDoc) {
                Explanation child = childWeight.explain(context, childDoc - context.docBase);
                if (!child.isMatch()) continue;
                ++matches;
                if (bestChild != null && !(child.getValue() > bestChild.getValue())) continue;
                bestChild = child;
            }
            return Explanation.match(this.score(), String.format(Locale.ROOT, "Score based on %d child docs in range from %d to %d, best match:", matches, start, end), bestChild);
        }
    }

    private static class ParentTwoPhase
    extends TwoPhaseIterator {
        private final ParentApproximation parentApproximation;
        private final DocIdSetIterator childApproximation;
        private final TwoPhaseIterator childTwoPhase;

        ParentTwoPhase(ParentApproximation parentApproximation, TwoPhaseIterator childTwoPhase) {
            super(parentApproximation);
            this.parentApproximation = parentApproximation;
            this.childApproximation = childTwoPhase.approximation();
            this.childTwoPhase = childTwoPhase;
        }

        @Override
        public boolean matches() throws IOException {
            assert (this.childApproximation.docID() < this.parentApproximation.docID());
            do {
                if (!this.childTwoPhase.matches()) continue;
                return true;
            } while (this.childApproximation.nextDoc() < this.parentApproximation.docID());
            return false;
        }

        @Override
        public float matchCost() {
            return this.childTwoPhase.matchCost() + 10.0f;
        }
    }

    private static class ParentApproximation
    extends DocIdSetIterator {
        private final DocIdSetIterator childApproximation;
        private final BitSet parentBits;
        private int doc = -1;

        ParentApproximation(DocIdSetIterator childApproximation, BitSet parentBits) {
            this.childApproximation = childApproximation;
            this.parentBits = parentBits;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.advance(this.doc + 1);
        }

        @Override
        public int advance(int target) throws IOException {
            if (target >= this.parentBits.length()) {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            int firstChildTarget = target == 0 ? 0 : this.parentBits.prevSetBit(target - 1) + 1;
            int childDoc = this.childApproximation.docID();
            if (childDoc < firstChildTarget) {
                childDoc = this.childApproximation.advance(firstChildTarget);
            }
            if (childDoc >= this.parentBits.length() - 1) {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.doc = this.parentBits.nextSetBit(childDoc + 1);
            return this.doc;
        }

        @Override
        public long cost() {
            return this.childApproximation.cost();
        }
    }

    private static class BlockJoinWeight
    extends FilterWeight {
        private final BitSetProducer parentsFilter;
        private final ScoreMode scoreMode;

        public BlockJoinWeight(Query joinQuery, Weight childWeight, BitSetProducer parentsFilter, ScoreMode scoreMode) {
            super(joinQuery, childWeight);
            this.parentsFilter = parentsFilter;
            this.scoreMode = scoreMode;
        }

        @Override
        public Scorer scorer(LeafReaderContext context) throws IOException {
            ScorerSupplier scorerSupplier = this.scorerSupplier(context);
            if (scorerSupplier == null) {
                return null;
            }
            return scorerSupplier.get(Long.MAX_VALUE);
        }

        @Override
        public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
            final ScorerSupplier childScorerSupplier = this.in.scorerSupplier(context);
            if (childScorerSupplier == null) {
                return null;
            }
            final BitSet parents = this.parentsFilter.getBitSet(context);
            if (parents == null) {
                return null;
            }
            return new ScorerSupplier(){

                @Override
                public Scorer get(long leadCost) throws IOException {
                    return new BlockJoinScorer(this, childScorerSupplier.get(leadCost), parents, scoreMode);
                }

                @Override
                public long cost() {
                    return childScorerSupplier.cost();
                }
            };
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            BlockJoinScorer scorer = (BlockJoinScorer)this.scorer(context);
            if (scorer != null && scorer.iterator().advance(doc) == doc) {
                return scorer.explain(context, this.in);
            }
            return Explanation.noMatch("Not a match", new Explanation[0]);
        }
    }
}

