/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch6;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.streaming.connectors.elasticsearch.ActionRequestFailureHandler;
import org.apache.flink.streaming.connectors.elasticsearch.ElasticsearchSinkBase;
import org.apache.flink.streaming.connectors.elasticsearch.ElasticsearchSinkFunction;
import org.apache.flink.streaming.connectors.elasticsearch.util.NoOpFailureHandler;
import org.apache.flink.streaming.connectors.elasticsearch6.Elasticsearch6ApiCallBridge;
import org.apache.flink.streaming.connectors.elasticsearch6.RestClientFactory;
import org.apache.flink.util.Preconditions;
import org.apache.http.HttpHost;
import org.elasticsearch.client.RestHighLevelClient;

@PublicEvolving
public class ElasticsearchSink<T>
extends ElasticsearchSinkBase<T, RestHighLevelClient> {
    private static final long serialVersionUID = 1L;

    private ElasticsearchSink(Map<String, String> bulkRequestsConfig, List<HttpHost> httpHosts, ElasticsearchSinkFunction<T> elasticsearchSinkFunction, ActionRequestFailureHandler failureHandler, RestClientFactory restClientFactory) {
        super(new Elasticsearch6ApiCallBridge(httpHosts, restClientFactory), bulkRequestsConfig, elasticsearchSinkFunction, failureHandler);
    }

    @PublicEvolving
    public static class Builder<T> {
        private final List<HttpHost> httpHosts;
        private final ElasticsearchSinkFunction<T> elasticsearchSinkFunction;
        private Map<String, String> bulkRequestsConfig = new HashMap<String, String>();
        private ActionRequestFailureHandler failureHandler = new NoOpFailureHandler();
        private RestClientFactory restClientFactory = restClientBuilder -> {};

        public Builder(List<HttpHost> httpHosts, ElasticsearchSinkFunction<T> elasticsearchSinkFunction) {
            this.httpHosts = (List)Preconditions.checkNotNull(httpHosts);
            this.elasticsearchSinkFunction = (ElasticsearchSinkFunction)Preconditions.checkNotNull(elasticsearchSinkFunction);
        }

        public void setBulkFlushMaxActions(int numMaxActions) {
            Preconditions.checkArgument((numMaxActions == -1 || numMaxActions > 0 ? 1 : 0) != 0, (Object)"Max number of buffered actions must be larger than 0.");
            this.bulkRequestsConfig.put("bulk.flush.max.actions", String.valueOf(numMaxActions));
        }

        public void setBulkFlushMaxSizeMb(int maxSizeMb) {
            Preconditions.checkArgument((maxSizeMb == -1 || maxSizeMb > 0 ? 1 : 0) != 0, (Object)"Max size of buffered actions must be larger than 0.");
            this.bulkRequestsConfig.put("bulk.flush.max.size.mb", String.valueOf(maxSizeMb));
        }

        public void setBulkFlushInterval(long intervalMillis) {
            Preconditions.checkArgument((intervalMillis == -1L || intervalMillis >= 0L ? 1 : 0) != 0, (Object)"Interval (in milliseconds) between each flush must be larger than or equal to 0.");
            this.bulkRequestsConfig.put("bulk.flush.interval.ms", String.valueOf(intervalMillis));
        }

        public void setBulkFlushBackoff(boolean enabled) {
            this.bulkRequestsConfig.put("bulk.flush.backoff.enable", String.valueOf(enabled));
        }

        public void setBulkFlushBackoffType(ElasticsearchSinkBase.FlushBackoffType flushBackoffType) {
            this.bulkRequestsConfig.put("bulk.flush.backoff.type", ((ElasticsearchSinkBase.FlushBackoffType)((Object)Preconditions.checkNotNull((Object)((Object)flushBackoffType)))).toString());
        }

        public void setBulkFlushBackoffRetries(int maxRetries) {
            Preconditions.checkArgument((maxRetries > 0 ? 1 : 0) != 0, (Object)"Max number of backoff attempts must be larger than 0.");
            this.bulkRequestsConfig.put("bulk.flush.backoff.retries", String.valueOf(maxRetries));
        }

        public void setBulkFlushBackoffDelay(long delayMillis) {
            Preconditions.checkArgument((delayMillis >= 0L ? 1 : 0) != 0, (Object)"Delay (in milliseconds) between each backoff attempt must be larger than or equal to 0.");
            this.bulkRequestsConfig.put("bulk.flush.backoff.delay", String.valueOf(delayMillis));
        }

        public void setFailureHandler(ActionRequestFailureHandler failureHandler) {
            this.failureHandler = (ActionRequestFailureHandler)Preconditions.checkNotNull((Object)failureHandler);
        }

        public void setRestClientFactory(RestClientFactory restClientFactory) {
            this.restClientFactory = (RestClientFactory)Preconditions.checkNotNull((Object)restClientFactory);
        }

        public ElasticsearchSink<T> build() {
            return new ElasticsearchSink(this.bulkRequestsConfig, this.httpHosts, this.elasticsearchSinkFunction, this.failureHandler, this.restClientFactory);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Builder builder = (Builder)o;
            return Objects.equals(this.httpHosts, builder.httpHosts) && Objects.equals(this.elasticsearchSinkFunction, builder.elasticsearchSinkFunction) && Objects.equals(this.bulkRequestsConfig, builder.bulkRequestsConfig) && Objects.equals(this.failureHandler, builder.failureHandler) && Objects.equals(this.restClientFactory, builder.restClientFactory);
        }

        public int hashCode() {
            return Objects.hash(this.httpHosts, this.elasticsearchSinkFunction, this.bulkRequestsConfig, this.failureHandler, this.restClientFactory);
        }
    }
}

