/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.logging.log4j;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;

public class JmxAppender
extends AppenderSkeleton {
    public static final String JMX_OBJECT_DOMAIN = JmxAppender.class.getName();
    public static final String JMX_OBJECT_TYPE = "jmx-log4j-appender";
    public static final String JMX_OBJECT_NAME = "jmx-log4j-appender";
    private static final Logger log = Logger.getLogger((String)JmxAppender.class.getName());

    public JmxAppender() {
        this(ManagementFactory.getPlatformMBeanServer());
    }

    public JmxAppender(MBeanServer mbeanServer) {
        try {
            JmxLog4J mbean = new JmxLog4J();
            ObjectName name = new ObjectName(JMX_OBJECT_DOMAIN + ":type=" + "jmx-log4j-appender" + ",name=" + "jmx-log4j-appender");
            mbeanServer.registerMBean(mbean, name);
        }
        catch (Exception e) {
            log.error((Object)"Unable to register Log4J MBean.", (Throwable)e);
        }
    }

    public void close() {
        log.debug((Object)"Ignoring close call.");
    }

    public boolean requiresLayout() {
        log.debug((Object)"Ignoring requresLayout call.");
        return false;
    }

    protected void append(LoggingEvent event) {
    }

    public static class JmxLog4J
    implements JmxLog4JMBean {
        @Override
        public void setLevel(String level) {
            try {
                LogManager.getRootLogger().setLevel(Level.toLevel((String)level));
            }
            catch (Exception e) {
                log.error((Object)("Unable to set level to: " + level), (Throwable)e);
            }
        }

        @Override
        public String getLevel() {
            return LogManager.getRootLogger().getLevel().toString();
        }
    }

    public static interface JmxLog4JMBean {
        public void setLevel(String var1);

        public String getLevel();
    }
}

