/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.storage.kv;

import java.io.File;
import org.apache.samza.SamzaException;
import org.apache.samza.config.Config;
import org.apache.samza.container.SamzaContainerContext;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.serializers.Serde;
import org.apache.samza.storage.StorageEngine;
import org.apache.samza.storage.kv.BaseKeyValueStorageEngineFactory;
import org.apache.samza.storage.kv.CachedStore;
import org.apache.samza.storage.kv.CachedStoreMetrics;
import org.apache.samza.storage.kv.KeyValueStorageEngine;
import org.apache.samza.storage.kv.KeyValueStorageEngineMetrics;
import org.apache.samza.storage.kv.LoggedStore;
import org.apache.samza.storage.kv.LoggedStoreMetrics;
import org.apache.samza.storage.kv.NullSafeKeyValueStore;
import org.apache.samza.storage.kv.SerializedKeyValueStore;
import org.apache.samza.storage.kv.SerializedKeyValueStoreMetrics;
import org.apache.samza.system.SystemStreamPartition;
import org.apache.samza.task.MessageCollector;
import org.apache.samza.util.Logging;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;

public abstract class BaseKeyValueStorageEngineFactory$class {
    public static StorageEngine getStorageEngine(BaseKeyValueStorageEngineFactory $this, String storeName, File storeDir, Serde keySerde, Serde msgSerde, MessageCollector collector, MetricsRegistry registry, SystemStreamPartition changeLogSystemStreamPartition, SamzaContainerContext containerContext) {
        Logging logging;
        LoggedStore<byte[], byte[]> loggedStore;
        boolean enableCache;
        int batchSize;
        Config storageConfig = containerContext.config.subset(new StringBuilder().append((Object)"stores.").append((Object)storeName).append((Object)".").toString(), true);
        int cacheSize = storageConfig.getInt("object.cache.size", package$.MODULE$.max(batchSize = storageConfig.getInt("write.batch.size", 500), 1000));
        boolean bl = enableCache = cacheSize > 0;
        if (cacheSize > 0 && cacheSize < batchSize) {
            throw new SamzaException("A store's cache.size cannot be less than batch.size as batched values reside in cache.");
        }
        if (keySerde == null) {
            throw new SamzaException("Must define a key serde when using key value storage.");
        }
        if (msgSerde == null) {
            throw new SamzaException("Must define a message serde when using key value storage.");
        }
        LoggedStore<byte[], byte[]> kvStore = $this.getKVStore(storeName, storeDir, registry, changeLogSystemStreamPartition, containerContext);
        if (changeLogSystemStreamPartition == null) {
            loggedStore = kvStore;
        } else {
            LoggedStoreMetrics loggedStoreMetrics = new LoggedStoreMetrics(storeName, registry);
            loggedStore = new LoggedStore<byte[], byte[]>(kvStore, changeLogSystemStreamPartition, collector, loggedStoreMetrics);
        }
        LoggedStore<byte[], byte[]> maybeLoggedStore = loggedStore;
        SerializedKeyValueStoreMetrics serializedMetrics = new SerializedKeyValueStoreMetrics(storeName, registry);
        SerializedKeyValueStore serialized = new SerializedKeyValueStore(maybeLoggedStore, keySerde, msgSerde, serializedMetrics);
        if (enableCache) {
            CachedStoreMetrics cachedStoreMetrics = new CachedStoreMetrics(storeName, registry);
            logging = new CachedStore(serialized, cacheSize, batchSize, cachedStoreMetrics);
        } else {
            logging = serialized;
        }
        SerializedKeyValueStore maybeCachedStore = logging;
        NullSafeKeyValueStore db = new NullSafeKeyValueStore(maybeCachedStore);
        KeyValueStorageEngineMetrics keyValueStorageEngineMetrics = new KeyValueStorageEngineMetrics(storeName, registry);
        return new KeyValueStorageEngine(db, kvStore, keyValueStorageEngineMetrics, batchSize);
    }

    public static void $init$(BaseKeyValueStorageEngineFactory $this) {
    }
}

