/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.storage.kv;

import java.io.File;
import org.apache.samza.SamzaException;
import org.apache.samza.config.Config;
import org.apache.samza.container.SamzaContainerContext;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.serializers.Serde;
import org.apache.samza.storage.StorageEngine;
import org.apache.samza.storage.StorageEngineFactory;
import org.apache.samza.storage.kv.CachedStore;
import org.apache.samza.storage.kv.CachedStoreMetrics;
import org.apache.samza.storage.kv.KeyValueStorageEngine;
import org.apache.samza.storage.kv.KeyValueStorageEngineMetrics;
import org.apache.samza.storage.kv.KeyValueStore;
import org.apache.samza.storage.kv.LevelDbKeyValueStore;
import org.apache.samza.storage.kv.LevelDbKeyValueStore$;
import org.apache.samza.storage.kv.LevelDbKeyValueStoreMetrics;
import org.apache.samza.storage.kv.LoggedStore;
import org.apache.samza.storage.kv.LoggedStoreMetrics;
import org.apache.samza.storage.kv.NullSafeKeyValueStore;
import org.apache.samza.storage.kv.SerializedKeyValueStore;
import org.apache.samza.storage.kv.SerializedKeyValueStoreMetrics;
import org.apache.samza.system.SystemStreamPartition;
import org.apache.samza.task.MessageCollector;
import org.iq80.leveldb.Options;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001M4A!\u0001\u0002\u0001\u001b\ta2*Z=WC2,Xm\u0015;pe\u0006<W-\u00128hS:,g)Y2u_JL(BA\u0002\u0005\u0003\tYgO\u0003\u0002\u0006\r\u000591\u000f^8sC\u001e,'BA\u0004\t\u0003\u0015\u0019\u0018-\u001c>b\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001U\u0019a\"\b\u0016\u0014\u0007\u0001yq\u0003\u0005\u0002\u0011+5\t\u0011C\u0003\u0002\u0013'\u0005!A.\u00198h\u0015\u0005!\u0012\u0001\u00026bm\u0006L!AF\t\u0003\r=\u0013'.Z2u!\u0011A\u0012dG\u0015\u000e\u0003\u0011I!A\u0007\u0003\u0003)M#xN]1hK\u0016sw-\u001b8f\r\u0006\u001cGo\u001c:z!\taR\u0004\u0004\u0001\u0005\u000by\u0001!\u0019A\u0010\u0003\u0003-\u000b\"\u0001\t\u0014\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\u000f9{G\u000f[5oOB\u0011\u0011eJ\u0005\u0003Q\t\u00121!\u00118z!\ta\"\u0006B\u0003,\u0001\t\u0007qDA\u0001W\u0011\u0015i\u0003\u0001\"\u0001/\u0003\u0019a\u0014N\\5u}Q\tq\u0006\u0005\u00031\u0001mIS\"\u0001\u0002\t\u000bI\u0002A\u0011A\u001a\u0002!\u001d,Go\u0015;pe\u0006<W-\u00128hS:,G#\u0003\u001b8\u0001\"\u00036kW2l!\tAR'\u0003\u00027\t\ti1\u000b^8sC\u001e,WI\\4j]\u0016DQ\u0001O\u0019A\u0002e\n\u0011b\u001d;pe\u0016t\u0015-\\3\u0011\u0005ijdBA\u0011<\u0013\ta$%\u0001\u0004Qe\u0016$WMZ\u0005\u0003}}\u0012aa\u0015;sS:<'B\u0001\u001f#\u0011\u0015\t\u0015\u00071\u0001C\u0003!\u0019Ho\u001c:f\t&\u0014\bCA\"G\u001b\u0005!%BA#\u0014\u0003\tIw.\u0003\u0002H\t\n!a)\u001b7f\u0011\u0015I\u0015\u00071\u0001K\u0003!YW-_*fe\u0012,\u0007cA&O75\tAJ\u0003\u0002N\r\u0005Y1/\u001a:jC2L'0\u001a:t\u0013\tyEJA\u0003TKJ$W\rC\u0003Rc\u0001\u0007!+\u0001\u0005ng\u001e\u001cVM\u001d3f!\rYe*\u000b\u0005\u0006)F\u0002\r!V\u0001\nG>dG.Z2u_J\u0004\"AV-\u000e\u0003]S!\u0001\u0017\u0004\u0002\tQ\f7o[\u0005\u00035^\u0013\u0001#T3tg\u0006<WmQ8mY\u0016\u001cGo\u001c:\t\u000bq\u000b\u0004\u0019A/\u0002\u0011I,w-[:uef\u0004\"AX1\u000e\u0003}S!\u0001\u0019\u0004\u0002\u000f5,GO]5dg&\u0011!m\u0018\u0002\u0010\u001b\u0016$(/[2t%\u0016<\u0017n\u001d;ss\")A-\ra\u0001K\u0006q2\r[1oO\u0016dunZ*zgR,Wn\u0015;sK\u0006l\u0007+\u0019:uSRLwN\u001c\t\u0003M&l\u0011a\u001a\u0006\u0003Q\u001a\taa]=ti\u0016l\u0017B\u00016h\u0005U\u0019\u0016p\u001d;f[N#(/Z1n!\u0006\u0014H/\u001b;j_:DQ\u0001\\\u0019A\u00025\f\u0001cY8oi\u0006Lg.\u001a:D_:$X\r\u001f;\u0011\u00059\fX\"A8\u000b\u0005A4\u0011!C2p]R\f\u0017N\\3s\u0013\t\u0011xNA\u000bTC6T\u0018mQ8oi\u0006Lg.\u001a:D_:$X\r\u001f;")
public class KeyValueStorageEngineFactory<K, V>
implements StorageEngineFactory<K, V> {
    public StorageEngine getStorageEngine(String storeName, File storeDir, Serde<K> keySerde, Serde<V> msgSerde, MessageCollector collector, MetricsRegistry registry, SystemStreamPartition changeLogSystemStreamPartition, SamzaContainerContext containerContext) {
        KeyValueStore<K, V> keyValueStore;
        KeyValueStore<byte[], byte[]> keyValueStore2;
        boolean enableCache;
        Config storageConfig = containerContext.config.subset(new StringBuilder().append((Object)"stores.").append((Object)storeName).append((Object)".").toString(), true);
        int batchSize = storageConfig.getInt("write.batch.size", 500);
        int cacheSize = storageConfig.getInt("object.cache.size", package$.MODULE$.max(batchSize, 1000));
        int deleteCompactionThreshold = storageConfig.getInt("compaction.delete.threshold", -1);
        boolean bl = enableCache = cacheSize > 0;
        if (cacheSize > 0 && cacheSize < batchSize) {
            throw new SamzaException("A stores cache.size cannot be less than batch.size as batched values reside in cache.");
        }
        if (keySerde == null) {
            throw new SamzaException("Must define a key serde when using key value storage.");
        }
        if (msgSerde == null) {
            throw new SamzaException("Must define a message serde when using key value storage.");
        }
        LevelDbKeyValueStoreMetrics levelDbMetrics = new LevelDbKeyValueStoreMetrics(storeName, registry);
        Options levelDbOptions = LevelDbKeyValueStore$.MODULE$.options(storageConfig, containerContext);
        LevelDbKeyValueStore levelDb = new LevelDbKeyValueStore(storeDir, levelDbOptions, deleteCompactionThreshold, levelDbMetrics);
        if (changeLogSystemStreamPartition == null) {
            keyValueStore2 = levelDb;
        } else {
            LoggedStoreMetrics loggedStoreMetrics = new LoggedStoreMetrics(storeName, registry);
            keyValueStore2 = new LoggedStore<byte[], byte[]>(levelDb, changeLogSystemStreamPartition, collector, loggedStoreMetrics);
        }
        LevelDbKeyValueStore maybeLoggedStore = keyValueStore2;
        SerializedKeyValueStoreMetrics serializedMetrics = new SerializedKeyValueStoreMetrics(storeName, registry);
        SerializedKeyValueStore<K, V> serialized = new SerializedKeyValueStore<K, V>(maybeLoggedStore, keySerde, msgSerde, serializedMetrics);
        if (enableCache) {
            CachedStoreMetrics cachedStoreMetrics = new CachedStoreMetrics(storeName, registry);
            keyValueStore = new CachedStore<K, V>(serialized, cacheSize, batchSize, cachedStoreMetrics);
        } else {
            keyValueStore = serialized;
        }
        SerializedKeyValueStore<K, V> maybeCachedStore = keyValueStore;
        NullSafeKeyValueStore<K, V> db = new NullSafeKeyValueStore<K, V>(maybeCachedStore);
        KeyValueStorageEngineMetrics keyValueStorageEngineMetrics = new KeyValueStorageEngineMetrics(storeName, registry);
        return new KeyValueStorageEngine<K, V>(db, levelDb, keyValueStorageEngineMetrics, batchSize);
    }
}

