/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.tool.envcheck.plugins;

import com.sun.jini.start.SharedActivationGroupDescriptor;
import com.sun.jini.tool.envcheck.AbstractPlugin;
import com.sun.jini.tool.envcheck.EnvCheck;
import com.sun.jini.tool.envcheck.Reporter;
import com.sun.jini.tool.envcheck.SubVMTask;

public class CheckJSKPolicy
extends AbstractPlugin {
    private EnvCheck envCheck;
    private String codebase;
    private static String provider = "net.jini.security.policy.DynamicPolicyProvider";

    public void run(EnvCheck envCheck) {
        this.envCheck = envCheck;
        this.checkPolicy(null);
        SharedActivationGroupDescriptor gd = envCheck.getGroupDescriptor();
        if (gd != null) {
            this.checkPolicy(gd);
        }
    }

    private void checkPolicy(SharedActivationGroupDescriptor gd) {
        String source = gd == null ? this.getString("vmsource") : this.getString("groupsource", gd.getServerCommand());
        Object o = this.envCheck.launch(null, gd, this.taskName("JSKPolicyTask"));
        if (o instanceof Boolean) {
            Reporter.Message message = (Boolean)o != false ? new Reporter.Message(0, this.getString("policyOK"), this.getString("policyExp")) : new Reporter.Message(2, this.getString("policyBad"), this.getString("missingPolicyExp"));
            Reporter.print(message, source);
        } else {
            this.handleUnexpectedSubtaskReturn(o, source);
        }
    }

    public static class JSKPolicyTask
    implements SubVMTask {
        public Object run(String[] args) {
            try {
                Class<?> c = Class.forName(provider);
                if (c.getClassLoader().getParent() == null) {
                    return new Boolean(true);
                }
                return new Boolean(false);
            }
            catch (ClassNotFoundException e) {
                return new Boolean(false);
            }
        }
    }
}

