/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.tool.envcheck.plugins;

import com.sun.jini.start.SharedActivationGroupDescriptor;
import com.sun.jini.tool.envcheck.AbstractPlugin;
import com.sun.jini.tool.envcheck.EnvCheck;
import com.sun.jini.tool.envcheck.Reporter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class CheckJSKPlatform
extends AbstractPlugin {
    private EnvCheck envCheck;
    private HashSet seen = new HashSet();

    public void run(EnvCheck envCheck) {
        this.envCheck = envCheck;
        String classpath = envCheck.getJarToRun();
        if (classpath != null) {
            this.checkPlatform(classpath, this.getString("jarfile"));
        } else {
            classpath = envCheck.getClasspath();
            this.checkPlatform(classpath, this.getString("cmdline"));
        }
        SharedActivationGroupDescriptor gd = envCheck.getGroupDescriptor();
        if (gd != null) {
            classpath = gd.getClasspath();
            this.checkPlatform(classpath, this.getString("grouppath"));
        }
    }

    private void checkPlatform(String classpath, String source) {
        String[] paths = this.parseClasspath(classpath, source);
        for (int i = 0; i < paths.length; ++i) {
            if (!paths[i].endsWith("jsk-platform.jar")) continue;
            Reporter.Message message = new Reporter.Message(0, this.getString("hasplatform"), this.getString("platformExp"));
            Reporter.print(message, source);
            return;
        }
        Reporter.Message message = new Reporter.Message(1, this.getString("noplatform"), this.getString("platformExp"));
        Reporter.print(message, source);
    }

    private String[] parseClasspath(String path, String source) {
        if (path == null || path.trim().length() == 0) {
            return new String[0];
        }
        ArrayList list = new ArrayList();
        StringTokenizer tok = new StringTokenizer(path, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            String item = tok.nextToken();
            list.addAll(this.checkItem(item, source));
        }
        return list.toArray(new String[list.size()]);
    }

    private ArrayList checkItem(String item, String source) {
        Manifest manifest;
        JarFile jar;
        ArrayList<String> list = new ArrayList<String>();
        if (this.seen.contains(item)) {
            return list;
        }
        this.seen.add(item);
        File itemFile = new File(item);
        if (!itemFile.exists()) {
            Reporter.Message message = new Reporter.Message(1, this.getString("nosuchitem", item), null);
            Reporter.print(message, source);
            return list;
        }
        if (!itemFile.canRead()) {
            Reporter.Message message = new Reporter.Message(1, this.getString("unreadableitem", item), null);
            Reporter.print(message, source);
            return list;
        }
        list.add(item);
        try {
            jar = new JarFile(item);
        }
        catch (IOException e) {
            return list;
        }
        try {
            manifest = jar.getManifest();
            if (manifest == null) {
                return list;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return list;
        }
        String classPath = manifest.getMainAttributes().getValue("Class-Path");
        if (classPath != null) {
            StringTokenizer tok = new StringTokenizer(classPath);
            while (tok.hasMoreTokens()) {
                String fileName = tok.nextToken();
                File nextJar = new File(itemFile.getParentFile(), fileName);
                source = source + ": " + item + " Manifest Class-Path";
                list.addAll(this.checkItem(nextJar.toString(), source));
            }
        }
        return list;
    }
}

