/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.tool.envcheck.plugins;

import com.sun.jini.tool.envcheck.AbstractPlugin;
import com.sun.jini.tool.envcheck.EnvCheck;
import com.sun.jini.tool.envcheck.Reporter;
import com.sun.jini.tool.envcheck.SubVMTask;
import java.rmi.ConnectException;
import java.rmi.activation.ActivationGroup;
import java.security.AccessControlException;

public class CheckActivationSystem
extends AbstractPlugin {
    private EnvCheck envCheck;
    private static boolean doCheck = false;

    public boolean isPluginOption(String opt) {
        if (opt.equals("-activation")) {
            doCheck = true;
            return true;
        }
        return false;
    }

    public void run(EnvCheck envCheck) {
        this.envCheck = envCheck;
        if (doCheck || envCheck.getGroupDescriptor() != null) {
            this.checkAvailability();
        }
    }

    private void checkAvailability() {
        Reporter.Message message;
        String taskName = this.taskName("CheckActivationTask");
        Object launchReturn = this.envCheck.launch(null, this.envCheck.getGroupDescriptor(), taskName);
        if (launchReturn == null) {
            message = new Reporter.Message(0, this.getString("running"), this.getString("explanationString"));
        } else {
            Throwable ex = (Throwable)launchReturn;
            Throwable t = ex.getCause();
            if (t == null) {
                t = ex;
            }
            message = t instanceof ConnectException ? new Reporter.Message(1, this.getString("notRunning"), t, this.getString("explanationString")) : (t instanceof AccessControlException ? new Reporter.Message(1, this.getString("nopermission"), t, this.getString("noPermExplanationString")) : new Reporter.Message(1, this.getString("unexpectedException"), ex, this.getString("unexpectedExplanationString")));
        }
        Reporter.print(message);
    }

    public static class CheckActivationTask
    implements SubVMTask {
        public Object run(String[] args) {
            try {
                ActivationGroup.getSystem();
                return null;
            }
            catch (Throwable e) {
                return e;
            }
        }
    }
}

