/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.tool.classdepend;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClasspathPackages {
    public static void main(String[] args) {
        String classpath;
        if (args.length == 0) {
            classpath = System.getProperty("java.class.path");
        } else if (args.length == 1) {
            classpath = args[0];
        } else {
            throw new IllegalArgumentException("Usage: java " + ClasspathPackages.class.getName() + " [classpath]");
        }
        TreeSet packages = new TreeSet(ClasspathPackages.compute(classpath));
        for (String pkg : packages) {
            System.out.println(pkg.length() == 0 ? "[empty package]" : pkg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set compute(String classpath) {
        if (classpath == null) {
            throw new NullPointerException("The classpath cannot be null");
        }
        HashSet packages = new HashSet();
        StringTokenizer tokens = new StringTokenizer(classpath, File.pathSeparator);
        while (tokens.hasMoreTokens()) {
            IOException e3;
            Object var9_9;
            JarFile jarFile;
            File file;
            String token = tokens.nextToken();
            if (token.equals("")) {
                token = ".";
            }
            if (!(file = new File(token)).exists()) continue;
            if (file.isDirectory()) {
                String dir = file.getPath();
                if (!dir.endsWith(File.separator)) {
                    dir = dir + File.separator;
                }
                ClasspathPackages.addPackages(dir, dir, packages);
                continue;
            }
            try {
                jarFile = new JarFile(file);
            }
            catch (IOException e2) {
                continue;
            }
            try {
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    ClasspathPackages.addPackage(entry, packages);
                }
                var9_9 = null;
            }
            catch (Throwable throwable) {
                var9_9 = null;
                try {
                    jarFile.close();
                }
                catch (IOException e3) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                jarFile.close();
            }
            catch (IOException e3) {}
        }
        return packages;
    }

    private static void addPackages(final String top, String dir, final Set packages) {
        File file = new File(dir);
        if (file.exists()) {
            file.listFiles(new FileFilter(){

                public boolean accept(File child) {
                    String path = child.getPath();
                    String name = path.substring(top.length());
                    if (name.endsWith(".class") && child.isFile()) {
                        int sep = name.lastIndexOf(File.separatorChar);
                        if (sep <= 0) {
                            packages.add("");
                        } else {
                            packages.add(name.substring(0, sep).replace(File.separatorChar, '.'));
                        }
                    } else if (child.isDirectory()) {
                        ClasspathPackages.addPackages(top, path, packages);
                    }
                    return false;
                }
            });
        }
    }

    private static void addPackage(JarEntry entry, Set packages) {
        String name = entry.getName();
        if (name.endsWith(".class")) {
            int slash = (name = name.substring(0, name.length() - 6)).lastIndexOf(47);
            if (slash <= 0) {
                name = "";
            } else {
                name = name.substring(0, slash);
                name = name.replace('/', '.');
            }
            packages.add(name);
        }
    }
}

