/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.tool.classdepend;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ClassDependParameters {
    private final String[] outsidePackagesOrClasses;
    private final String[] insidePackages;
    private final String[] showPackages;
    private final String[] hidePackages;
    private final boolean ignoreOuterParentClass;
    private final boolean excludePlatformClasses;
    private final boolean edges;

    private ClassDependParameters(CDPBuilder builder) {
        this.outsidePackagesOrClasses = builder.outsidePackagesOrClasses.toArray(new String[builder.outsidePackagesOrClasses.size()]);
        this.insidePackages = builder.insidePackages.toArray(new String[builder.insidePackages.size()]);
        this.showPackages = builder.showPackages.toArray(new String[builder.showPackages.size()]);
        this.hidePackages = builder.hidePackages.toArray(new String[builder.hidePackages.size()]);
        this.ignoreOuterParentClass = builder.ignoreOuterParentClass;
        this.excludePlatformClasses = builder.excludePlatformClasses;
        this.edges = builder.edges;
    }

    private List cloneArraytoList(String[] array) {
        String[] ac = (String[])array.clone();
        return Arrays.asList(ac);
    }

    public List outsidePackagesOrClasses() {
        return this.cloneArraytoList(this.outsidePackagesOrClasses);
    }

    public List insidePackages() {
        return this.cloneArraytoList(this.insidePackages);
    }

    public List showPackages() {
        return this.cloneArraytoList(this.showPackages);
    }

    public List hidePackages() {
        return this.cloneArraytoList(this.hidePackages);
    }

    public boolean ignoreOuterParentClass() {
        return this.ignoreOuterParentClass;
    }

    public boolean excludePlatformClasses() {
        return this.excludePlatformClasses;
    }

    public boolean edges() {
        return this.edges;
    }

    public static class CDPBuilder {
        private List outsidePackagesOrClasses = new ArrayList();
        private List insidePackages = new ArrayList();
        private List showPackages = new ArrayList();
        private List hidePackages = new ArrayList();
        private boolean ignoreOuterParentClass = false;
        private boolean excludePlatformClasses = false;
        private boolean edges = false;

        public CDPBuilder addOutsidePackageOrClass(String outsidePackageOrClass) {
            this.outsidePackagesOrClasses.add(outsidePackageOrClass);
            return this;
        }

        public CDPBuilder addOutsidePackagesOrClasses(String[] outsidePackagesOrClasses) {
            int l = outsidePackagesOrClasses.length;
            for (int i = 0; i < l; ++i) {
                this.outsidePackagesOrClasses.add(outsidePackagesOrClasses[i]);
            }
            return this;
        }

        public CDPBuilder addOutsidePackagesOrClasses(List excludes) {
            this.outsidePackagesOrClasses.addAll(excludes);
            return this;
        }

        public CDPBuilder addInsidePackage(String insidePackage) {
            this.insidePackages.add(insidePackage);
            return this;
        }

        public CDPBuilder addInsidePackages(String[] insidePackages) {
            int l = insidePackages.length;
            for (int i = 0; i < l; ++i) {
                this.insidePackages.add(insidePackages[i]);
            }
            return this;
        }

        public CDPBuilder addInsidePackages(List inside) {
            this.insidePackages.addAll(inside);
            return this;
        }

        public CDPBuilder addShowPackages(String[] showPackages) {
            int l = showPackages.length;
            for (int i = 0; i < l; ++i) {
                this.showPackages.add(showPackages[i]);
            }
            return this;
        }

        public CDPBuilder addShowPackages(List showPackages) {
            this.showPackages.addAll(showPackages);
            return this;
        }

        public CDPBuilder addShowPackage(String showPackage) {
            this.showPackages.add(showPackage);
            return this;
        }

        public CDPBuilder addHidePackages(String[] hidePackages) {
            int l = hidePackages.length;
            for (int i = 0; i < l; ++i) {
                this.hidePackages.add(hidePackages[i]);
            }
            return this;
        }

        public CDPBuilder addHidePackages(List hidePackages) {
            this.hidePackages.addAll(hidePackages);
            return this;
        }

        public CDPBuilder addHidePackage(String hidePackage) {
            this.hidePackages.add(hidePackage);
            return this;
        }

        public CDPBuilder ignoreOuterParentClass(boolean b) {
            this.ignoreOuterParentClass = b;
            return this;
        }

        public CDPBuilder excludePlatformClasses(boolean b) {
            this.excludePlatformClasses = b;
            return this;
        }

        public CDPBuilder edges(boolean e) {
            this.edges = e;
            return this;
        }

        public ClassDependParameters build() {
            return new ClassDependParameters(this);
        }
    }
}

