/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.tool.classdepend;

import com.sun.jini.tool.classdepend.ClassDependParameters;
import com.sun.jini.tool.classdepend.ClassDependencyRelationship;
import com.sun.jini.tool.classdepend.PackageClasses;
import com.sun.jini.tool.classdepend.ReferencedClasses;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class ClassDepend {
    private static final String systemClasspath = System.getProperty("java.class.path");
    private final ClassLoader loader;
    private final ClassLoader platformLoader;
    private final PackageClasses packageClasses;
    private volatile boolean printClassesWithFileSeparator = false;

    public static ClassDepend newInstance(String classpath, String platform, boolean warn) throws MalformedURLException, IOException {
        ClassDepend classDepend = !warn ? new ClassDepend(classpath, platform) : new ClassDepend(classpath, platform){

            protected void noteClassNotFound(String name) {
                System.err.println("Warning: Class not found: " + name);
            }

            protected void noteClassLoadingFailed(String name, IOException e) {
                System.err.println("Warning: Problem loading class " + name + ": " + e.getMessage());
            }
        };
        return classDepend;
    }

    public static void main(String[] args) {
        try {
            ClassDependParameters.CDPBuilder cdpb = new ClassDependParameters.CDPBuilder();
            String classpath = null;
            String platform = null;
            HashSet<String> rootClasses = new HashSet<String>();
            boolean recurse = true;
            boolean warn = false;
            boolean files = false;
            boolean graph = false;
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (arg.equals("-cp")) {
                    classpath = args[++i];
                    continue;
                }
                if (arg.equals("-platform")) {
                    platform = args[++i];
                    continue;
                }
                if (arg.equals("-exclude")) {
                    cdpb.addOutsidePackageOrClass(args[++i]);
                    continue;
                }
                if (arg.equals("-norecurse")) {
                    recurse = false;
                    continue;
                }
                if (arg.equals("-warn")) {
                    warn = true;
                    continue;
                }
                if (arg.equals("-files")) {
                    files = true;
                    continue;
                }
                if (arg.equals("-graph")) {
                    graph = true;
                    continue;
                }
                if (arg.equals("-excljava")) {
                    cdpb.excludePlatformClasses(true);
                    continue;
                }
                if (arg.startsWith("-")) {
                    throw new IllegalArgumentException("Bad option: " + arg);
                }
                rootClasses.add(arg);
            }
            ClassDependParameters cdp = cdpb.build();
            ClassDepend classDepend = ClassDepend.newInstance(classpath, platform, warn);
            Set result = classDepend.filterClassDependencyRelationShipMap(classDepend.getDependencyRelationshipMap(rootClasses, recurse), cdp);
            for (Object rezult : result) {
                if (!(rezult instanceof ClassDependencyRelationship)) continue;
                ClassDependencyRelationship cl = (ClassDependencyRelationship)rezult;
                String str = cl.toString();
                if (files) {
                    str = str.replace('.', File.separatorChar).concat(".class");
                    System.out.println(str);
                }
                if (!graph) continue;
                Set deps = cl.getProviders();
                for (Object dep : deps) {
                    if (!result.contains(dep)) continue;
                    System.out.println("\"" + cl + "\"" + " -> " + "\"" + dep + "\"" + ";");
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    ClassDepend(String classpath, String platform) throws MalformedURLException, IOException {
        if (classpath == null) {
            classpath = systemClasspath;
        }
        ClassLoader system = ClassLoader.getSystemClassLoader();
        ClassLoader parent = system.getParent();
        this.loader = systemClasspath.equals(classpath) ? system : new URLClassLoader(this.getClasspathURLs(classpath), parent);
        this.packageClasses = new PackageClasses(classpath);
        this.platformLoader = platform == null ? parent : new URLClassLoader(this.getClasspathURLs(platform), parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Map getDependencyRelationshipMap(Collection rootClasses, boolean recurse) throws IOException, ClassNotFoundException {
        HashMap<String, ClassDependencyRelationship> result = new HashMap<String, ClassDependencyRelationship>();
        HashSet<String> seen = new HashSet<String>();
        HashSet compute = this.computeClasses(rootClasses);
        while (!compute.isEmpty()) {
            HashSet computeNext = new HashSet();
            for (String name : compute) {
                Set providerClassNames;
                block17: {
                    String resource;
                    block18: {
                        IOException e2222;
                        Object var14_16;
                        if (seen.contains(name)) continue;
                        seen.add(name);
                        if (rootClasses.contains(name)) {
                            ClassDependencyRelationship rootClass = new ClassDependencyRelationship(name, true);
                            result.put(name, rootClass);
                        }
                        providerClassNames = new HashSet();
                        resource = this.getResourceName(name);
                        if (!recurse) break block18;
                        InputStream in = this.loader.getResourceAsStream(resource);
                        if (in == null) {
                            this.noteClassNotFound(name);
                        } else {
                            providerClassNames = ReferencedClasses.compute(new BufferedInputStream(in));
                            computeNext.addAll(providerClassNames);
                            var14_16 = null;
                            try {
                                in.close();
                            }
                            catch (IOException e2222) {}
                        }
                        break block17;
                        {
                            catch (IOException e3) {
                                this.noteClassLoadingFailed(name, e3);
                                var14_16 = null;
                                try {
                                    in.close();
                                }
                                catch (IOException e2222) {}
                                break block17;
                            }
                        }
                        catch (Throwable throwable) {
                            var14_16 = null;
                            try {
                                in.close();
                            }
                            catch (IOException e2222) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                    }
                    if (this.loader.getResource(resource) == null) {
                        this.noteClassNotFound(name);
                    }
                }
                for (String provider : providerClassNames) {
                    ClassDependencyRelationship providerClass;
                    if (!result.containsKey(provider)) {
                        providerClass = new ClassDependencyRelationship(provider);
                        result.put(provider, providerClass);
                    } else {
                        providerClass = (ClassDependencyRelationship)result.get(provider);
                    }
                    ((ClassDependencyRelationship)result.get(name)).addProvider(providerClass);
                }
            }
            compute = computeNext;
        }
        return result;
    }

    public Set filterClassDependencyRelationShipMap(Map dependencyRelationShipMap, ClassDependParameters cdp) {
        String name;
        HashSet result = new HashSet();
        HashSet<ClassDependencyRelationship> preliminaryResult = new HashSet<ClassDependencyRelationship>();
        Pattern excludePattern = this.createPattern(cdp.outsidePackagesOrClasses());
        Pattern includePattern = this.createPattern(cdp.insidePackages());
        Pattern hidePattern = this.createPattern(cdp.hidePackages());
        Pattern showPattern = this.createPattern(cdp.showPackages());
        Collection classRelations = dependencyRelationShipMap.values();
        HashSet<ClassDependencyRelationship> rootClasses = new HashSet<ClassDependencyRelationship>();
        for (ClassDependencyRelationship cdr : classRelations) {
            if (!cdr.isRootClass()) continue;
            rootClasses.add(cdr);
        }
        while (!rootClasses.isEmpty()) {
            HashSet computeNext = new HashSet();
            for (ClassDependencyRelationship cdr : rootClasses) {
                name = cdr.toString();
                if (preliminaryResult.contains(cdr) || cdp.excludePlatformClasses() && this.classPresent(name, this.platformLoader) || this.matches(name, excludePattern) || cdp.insidePackages().size() != 0 && !this.matches(name, includePattern)) continue;
                preliminaryResult.add(cdr);
                computeNext.addAll(cdr.getProviders());
            }
            rootClasses = computeNext;
        }
        if (cdp.edges()) {
            for (ClassDependencyRelationship cdr : preliminaryResult) {
                result.addAll(cdr.getProviders());
            }
            result.removeAll(preliminaryResult);
        } else {
            result = preliminaryResult;
        }
        HashSet<ClassDependencyRelationship> remove = new HashSet<ClassDependencyRelationship>();
        for (ClassDependencyRelationship cdr : result) {
            name = cdr.toString();
            if (!this.matches(name, hidePattern) && (showPattern == null || this.matches(name, showPattern))) continue;
            remove.add(cdr);
        }
        result.removeAll(remove);
        return result;
    }

    protected void noteClassNotFound(String name) throws ClassNotFoundException {
        throw new ClassNotFoundException("Class not found: " + name);
    }

    protected void noteClassLoadingFailed(String name, IOException e) throws IOException {
        throw e;
    }

    private Set computeClasses(Collection names) throws IOException {
        HashSet<String> result = new HashSet<String>();
        for (String name : names) {
            if (name.endsWith(".*")) {
                name = name.substring(0, name.length() - 2);
                result.addAll(this.packageClasses.compute(false, name));
                continue;
            }
            if (name.endsWith(".**")) {
                name = name.substring(0, name.length() - 3);
                result.addAll(this.packageClasses.compute(true, name));
                continue;
            }
            result.add(name);
        }
        return result;
    }

    private URL[] getClasspathURLs(String classpath) throws MalformedURLException {
        StringTokenizer tokens = new StringTokenizer(classpath, File.pathSeparator);
        URL[] urls = new URL[tokens.countTokens()];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            String file = tokens.nextToken();
            try {
                urls[i] = new File(file).toURI().toURL();
            }
            catch (MalformedURLException e) {
                urls[i] = new URL(file);
            }
            ++i;
        }
        return urls;
    }

    private boolean classPresent(String name, ClassLoader loader) {
        return loader.getResource(this.getResourceName(name)) != null;
    }

    private String getResourceName(String classname) {
        return classname.replace('.', '/').concat(".class");
    }

    public Pattern createPattern(Collection names) {
        if (names.isEmpty()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (String name : names) {
            if (!first) {
                sb.append('|');
            } else {
                first = false;
            }
            if (name.endsWith(".*")) {
                sb.append(this.quote(name.substring(0, name.length() - 1)) + "[^.]+");
                continue;
            }
            if (name.endsWith(".**")) {
                sb.append(this.quote(name.substring(0, name.length() - 2)) + ".+");
                continue;
            }
            sb.append(this.quote(name));
        }
        return Pattern.compile(sb.toString());
    }

    public boolean matches(String string, Pattern pattern) {
        return pattern != null && pattern.matcher(string).matches();
    }

    private String quote(String s) {
        StringBuffer sb = new StringBuffer(s.length() * 2).append("\\Q");
        int previousEndQuotationIndex = 0;
        int endQuotationIndex = 0;
        while ((endQuotationIndex = s.indexOf("\\E", previousEndQuotationIndex)) >= 0) {
            sb.append(s.substring(previousEndQuotationIndex, endQuotationIndex));
            sb.append("\\E\\\\E\\Q");
            previousEndQuotationIndex = endQuotationIndex + 2;
        }
        sb.append(s.substring(previousEndQuotationIndex));
        sb.append("\\E");
        String literalPattern = sb.toString();
        return literalPattern;
    }

    public boolean printClassesWithFileSeparator() {
        return this.printClassesWithFileSeparator;
    }

    public void setPrintClassesWithFileSeparator(boolean printClassesWithFileSeparator) {
        this.printClassesWithFileSeparator = printClassesWithFileSeparator;
    }
}

