/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.tool.classdepend;

import com.sun.jini.tool.classdepend.AbstractVisitor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

abstract class AbstractDependencyVisitor
extends AbstractVisitor {
    String pattern = "^\\[{0,2}L{0,1}(\\w+[/.]{1}[\\w$\\d/.]+);{0,1}$";
    Pattern arrayOfObjects = Pattern.compile(this.pattern);

    AbstractDependencyVisitor() {
    }

    protected abstract void addName(String var1);

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (signature == null) {
            this.addNameInternal(superName);
            this.addNames(interfaces);
        } else {
            this.addSignature(signature);
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.addDesc(desc);
        return this;
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (signature == null) {
            this.addDesc(desc);
        } else {
            this.addTypeSignature(signature);
        }
        if (value instanceof Type) {
            this.addType((Type)value);
        }
        return this;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (signature == null) {
            this.addMethodDesc(desc);
        } else {
            this.addSignature(signature);
        }
        this.addNames(exceptions);
        return this;
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.addNameInternal(outerName);
        this.addNameInternal(name);
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        this.addDesc(desc);
        return this;
    }

    public void visitTypeInsn(int opcode, String desc) {
        if (desc.charAt(0) == '[') {
            this.addDesc(desc);
        } else {
            this.addNameInternal(desc);
        }
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.addNameInternal(owner);
        this.addDesc(desc);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        Matcher match = this.arrayOfObjects.matcher(owner);
        while (match.find()) {
            String object = match.group(1);
            this.addNameInternal(object);
        }
        this.addMethodDesc(desc);
    }

    public void visitLdcInsn(Object cst) {
        if (cst instanceof Type) {
            this.addType((Type)cst);
        }
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.addDesc(desc);
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        if (signature != null) {
            this.addTypeSignature(signature);
        }
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.addNameInternal(type);
    }

    public void visit(String name, Object value) {
        if (value instanceof Type) {
            this.addType((Type)value);
        }
    }

    public void visitEnum(String name, String desc, String value) {
        this.addDesc(desc);
    }

    public AnnotationVisitor visitAnnotation(String name, String desc) {
        this.addDesc(desc);
        return this;
    }

    public void visitTypeVariable(String name) {
    }

    public void visitClassType(String name) {
        this.addNameInternal(name);
    }

    public void visitInnerClassType(String name) {
    }

    private void addNameInternal(String name) {
        if (name != null) {
            this.addName(name.replace('/', '.'));
        }
    }

    private void addNames(String[] names) {
        if (names != null) {
            for (String name : names) {
                this.addNameInternal(name);
            }
        }
    }

    private void addDesc(String desc) {
        this.addType(Type.getType((String)desc));
    }

    private void addMethodDesc(String desc) {
        this.addType(Type.getReturnType((String)desc));
        Type[] type = Type.getArgumentTypes((String)desc);
        int l = type.length;
        for (int i = 0; i < l; ++i) {
            this.addType(type[i]);
        }
    }

    private void addType(Type t) {
        switch (t.getSort()) {
            case 9: {
                this.addType(t.getElementType());
                break;
            }
            case 10: {
                this.addNameInternal(t.getClassName());
            }
        }
    }

    private void addSignature(String signature) {
        new SignatureReader(signature).accept((SignatureVisitor)this);
    }

    private void addTypeSignature(String signature) {
        new SignatureReader(signature).acceptType((SignatureVisitor)this);
    }
}

