/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.tool;

import com.sun.jini.logging.Levels;
import com.sun.jini.start.LifeCycle;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClassServer
extends Thread {
    private static int DEFAULT_PORT = 8080;
    private static String DEFAULT_DIR = "/vob/jive/lib-dl";
    private static String DEFAULT_WIN_DIR = "J:";
    private static Logger logger = Logger.getLogger("com.sun.jini.tool.ClassServer");
    private ServerSocket server;
    private String[] dirs;
    private Map map;
    private boolean verbose;
    private boolean stoppable;
    private FilePermission[] perms;
    private LifeCycle lifeCycle;
    private static ResourceBundle resources;
    private static boolean resinit;

    public ClassServer(int port, String dirlist, boolean trees, boolean verbose) throws IOException {
        this.init(port, dirlist, trees, verbose, false, null);
    }

    public ClassServer(int port, String dirlist, boolean trees, boolean verbose, boolean stoppable) throws IOException {
        this.init(port, dirlist, trees, verbose, stoppable, null);
    }

    private void init(int port, String dirlist, boolean trees, boolean verbose, boolean stoppable, LifeCycle lifeCycle) throws IOException {
        StringTokenizer st = new StringTokenizer(dirlist, File.pathSeparator);
        this.dirs = new String[st.countTokens()];
        this.perms = new FilePermission[this.dirs.length];
        int i = 0;
        while (st.hasMoreTokens()) {
            String dir = st.nextToken();
            if (!dir.endsWith(File.separator)) {
                dir = dir + File.separatorChar;
            }
            this.dirs[i] = dir;
            this.perms[i] = new FilePermission(dir + '-', "read");
            ++i;
        }
        this.verbose = verbose;
        this.stoppable = stoppable;
        this.lifeCycle = lifeCycle;
        this.server = new ServerSocket();
        this.server.setReuseAddress(true);
        try {
            this.server.bind(new InetSocketAddress(port));
        }
        catch (BindException be) {
            IOException ioe = new IOException("failure to bind to port: " + port);
            ioe.initCause(be);
            throw ioe;
        }
        if (!trees) {
            return;
        }
        this.map = new HashMap();
        HashMap jfmap = new HashMap();
        for (int i2 = 0; i2 < this.dirs.length; ++i2) {
            String[] files = new File(this.dirs[i2]).list();
            if (files == null) continue;
            for (int j = 0; j < files.length; ++j) {
                String name;
                String jar = files[j];
                if (!jar.endsWith(".jar") && !jar.endsWith(".zip") || this.map.containsKey(name = jar.substring(0, jar.length() - 4))) continue;
                ArrayList jflist = new ArrayList(1);
                this.addJar(jar, jflist, jfmap);
                this.map.put(name, jflist.toArray(new JarFile[jflist.size()]));
            }
        }
    }

    public ClassServer(String[] args, LifeCycle lifeCycle) throws IOException {
        int port = DEFAULT_PORT;
        String dirlist = DEFAULT_DIR;
        if (File.separatorChar == '\\') {
            dirlist = DEFAULT_WIN_DIR;
        }
        boolean trees = false;
        boolean verbose = false;
        boolean stoppable = false;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-port")) {
                port = Integer.parseInt(args[++i]);
                continue;
            }
            if (arg.equals("-dir") || arg.equals("-dirs")) {
                dirlist = args[++i];
                continue;
            }
            if (arg.equals("-verbose")) {
                verbose = true;
                continue;
            }
            if (arg.equals("-trees")) {
                trees = true;
                continue;
            }
            if (arg.equals("-stoppable")) {
                stoppable = true;
                continue;
            }
            throw new IllegalArgumentException(arg);
        }
        this.init(port, dirlist, trees, verbose, stoppable, lifeCycle);
        this.start();
    }

    private void addJar(String jar, List jflist, Map jfmap) throws IOException {
        JarFile jf = (JarFile)jfmap.get(jar);
        if (jf != null) {
            if (jflist.contains(jf)) {
                return;
            }
        } else {
            for (int i = 0; i < this.dirs.length; ++i) {
                File f = new File(this.dirs[i] + jar).getCanonicalFile();
                if (!f.exists()) continue;
                jf = new JarFile(f);
                jfmap.put(jar, jf);
                if (this.verbose) {
                    ClassServer.print("classserver.jar", f.getPath());
                }
                logger.config(f.getPath());
                break;
            }
            if (jf == null) {
                if (this.verbose) {
                    ClassServer.print("classserver.notfound", jar);
                }
                logger.log(Level.CONFIG, "{0} not found", jar);
                return;
            }
        }
        jflist.add(jf);
        Manifest man = jf.getManifest();
        if (man == null) {
            return;
        }
        Attributes attrs = man.getMainAttributes();
        if (attrs == null) {
            return;
        }
        String val = attrs.getValue(Attributes.Name.CLASS_PATH);
        if (val == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(val);
        while (st.hasMoreTokens()) {
            String elt = st.nextToken();
            String path = ClassServer.decode(elt);
            if (path == null) {
                if (this.verbose) {
                    ClassServer.print("classserver.notfound", elt);
                }
                logger.log(Level.CONFIG, "{0} not found", elt);
            }
            if ('/' != File.separatorChar) {
                path = path.replace('/', File.separatorChar);
            }
            this.addJar(path, jflist, jfmap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        logger.log(Level.INFO, "ClassServer started [{0}, port {1}]", new Object[]{Arrays.asList(this.dirs), Integer.toString(this.getPort())});
        try {
            while (true) {
                new Task(this.server.accept()).start();
            }
        }
        catch (IOException e) {
            ClassServer classServer = this;
            synchronized (classServer) {
                if (this.verbose) {
                    e.printStackTrace();
                }
                if (!this.server.isClosed()) {
                    logger.log(Level.SEVERE, "accepting connection", e);
                }
                this.terminate();
            }
            return;
        }
    }

    public synchronized void terminate() {
        this.verbose = false;
        try {
            this.server.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.lifeCycle != null) {
            this.lifeCycle.unregister(this);
        }
        logger.log(Level.INFO, "ClassServer terminated [port {0}]", Integer.toString(this.getPort()));
    }

    public int getPort() {
        return this.server.getLocalPort();
    }

    private static boolean readLine(InputStream in, StringBuffer buf) throws IOException {
        int c;
        while ((c = in.read()) >= 0) {
            if (c == 13) {
                in.mark(1);
                c = in.read();
                if (c != 10) {
                    in.reset();
                }
                return true;
            }
            if (c == 10) {
                return true;
            }
            buf.append((char)c);
        }
        return buf.length() > 0;
    }

    private static char decode(String s, int i) {
        return (char)Integer.parseInt(s.substring(i + 1, i + 3), 16);
    }

    private static String decode(String path) {
        try {
            int i = path.indexOf(37);
            while (i >= 0) {
                char c = ClassServer.decode(path, i);
                int n = 3;
                if ((c & 0x80) != 0) {
                    switch (c >> 4) {
                        case 12: 
                        case 13: {
                            n = 6;
                            c = (char)((c & 0x1F) << 6 | ClassServer.decode(path, i + 3) & 0x3F);
                            break;
                        }
                        case 14: {
                            n = 9;
                            c = (char)((c & 0xF) << 12 | (ClassServer.decode(path, i + 3) & 0x3F) << 6 | ClassServer.decode(path, i + 6) & 0x3F);
                            break;
                        }
                        default: {
                            return null;
                        }
                    }
                }
                path = path.substring(0, i) + c + path.substring(i + n);
                i = path.indexOf(37, i + 1);
            }
        }
        catch (Exception e) {
            return null;
        }
        return path;
    }

    private static String getInput(Socket sock, boolean isRequest) throws IOException {
        BufferedInputStream in = new BufferedInputStream(sock.getInputStream(), 256);
        StringBuffer buf = new StringBuffer(80);
        do {
            if (ClassServer.readLine(in, buf)) continue;
            return null;
        } while (isRequest && buf.length() == 0);
        String initial = buf.toString();
        do {
            buf.setLength(0);
        } while (ClassServer.readLine(in, buf) && buf.length() > 0);
        return initial;
    }

    private static synchronized String getString(String key) {
        if (!resinit) {
            resinit = true;
            try {
                resources = ResourceBundle.getBundle("com.sun.jini.tool.resources.classserver");
            }
            catch (MissingResourceException e) {
                logger.log(Level.WARNING, "missing resource bundle {0}", "com.sun.jini.tool.resources.classserver");
            }
        }
        if (resources != null) {
            try {
                return resources.getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return null;
    }

    private static void print(String key, String val) {
        String fmt = ClassServer.getString(key);
        if (fmt == null) {
            fmt = "no text found: \"" + key + "\" {0}";
        }
        System.out.println(MessageFormat.format(fmt, val));
    }

    private static void print(String key, String[] vals) {
        String fmt = ClassServer.getString(key);
        if (fmt == null) {
            fmt = "no text found: \"" + key + "\" {0} {1} {2}";
        }
        System.out.println(MessageFormat.format(fmt, vals));
    }

    protected void fileDownloaded(String fp, InetAddress addr) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block20: {
            int port = DEFAULT_PORT;
            String dirlist = DEFAULT_DIR;
            if (File.separatorChar == '\\') {
                dirlist = DEFAULT_WIN_DIR;
            }
            boolean trees = false;
            boolean verbose = false;
            boolean stoppable = false;
            boolean stop = false;
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (arg.equals("-port")) {
                    port = Integer.parseInt(args[++i]);
                    continue;
                }
                if (arg.equals("-dir") || arg.equals("-dirs")) {
                    dirlist = args[++i];
                    continue;
                }
                if (arg.equals("-verbose")) {
                    verbose = true;
                    continue;
                }
                if (arg.equals("-trees")) {
                    trees = true;
                    continue;
                }
                if (arg.equals("-stoppable")) {
                    stoppable = true;
                    continue;
                }
                if (arg.equals("-stop")) {
                    stop = true;
                    continue;
                }
                ClassServer.print("classserver.usage", (String)null);
                return;
            }
            try {
                if (stop) {
                    Socket sock = new Socket(InetAddress.getLocalHost(), port);
                    try {
                        DataOutputStream out = new DataOutputStream(sock.getOutputStream());
                        out.writeBytes("SHUTDOWN *\r\n\r\n");
                        out.flush();
                        String status = ClassServer.getInput(sock, false);
                        if (status != null && status.startsWith("HTTP/")) {
                            if ((status = status.substring(status.indexOf(32) + 1)).startsWith("403 ")) {
                                ClassServer.print("classserver.forbidden", status);
                            } else if (!status.startsWith("200 ") && status.indexOf(32) == 3) {
                                ClassServer.print("classserver.status", new String[]{status.substring(0, 3), status.substring(4)});
                            }
                        }
                        Object var11_12 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_13 = null;
                        try {
                            sock.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        sock.close();
                    }
                    catch (IOException e) {}
                    break block20;
                }
                new ClassServer(port, dirlist, trees, verbose, stoppable).start();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "requesting shutdown", e);
            }
        }
    }

    static /* synthetic */ String access$400(Socket x0, boolean x1) throws IOException {
        return ClassServer.getInput(x0, x1);
    }

    static /* synthetic */ boolean access$500(ClassServer x0) {
        return x0.verbose;
    }

    static /* synthetic */ void access$600(String x0, String[] x1) {
        ClassServer.print(x0, x1);
    }

    static /* synthetic */ Logger access$700() {
        return logger;
    }

    static /* synthetic */ boolean access$800(ClassServer x0) {
        return x0.stoppable;
    }

    static /* synthetic */ void access$900(String x0, String x1) {
        ClassServer.print(x0, x1);
    }

    static {
        resinit = false;
    }

    private class Task
    extends Thread {
        private Socket sock;

        public Task(Socket sock) {
            this.sock = sock;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] getBytes(InputStream in, long length) throws IOException {
            DataInputStream din = new DataInputStream(in);
            byte[] bytes = new byte[(int)length];
            try {
                din.readFully(bytes);
                Object var7_5 = null;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                din.close();
                throw throwable;
            }
            din.close();
            return bytes;
        }

        private String canon(String path) {
            if (path.regionMatches(true, 0, "http://", 0, 7)) {
                int i = path.indexOf(47, 7);
                path = i < 0 ? "/" : path.substring(i);
            }
            if ((path = ClassServer.decode(path)) == null || path.length() == 0 || path.charAt(0) != '/') {
                return null;
            }
            return path.substring(1);
        }

        private byte[] getBytes(String path) throws IOException {
            JarFile[] jfs;
            int i;
            if (ClassServer.this.map != null && (i = path.indexOf(47)) > 0 && (jfs = (JarFile[])ClassServer.this.map.get(path.substring(0, i))) != null) {
                String jpath = path.substring(i + 1);
                for (i = 0; i < jfs.length; ++i) {
                    JarEntry je = jfs[i].getJarEntry(jpath);
                    if (je == null) continue;
                    return this.getBytes(jfs[i].getInputStream(je), je.getSize());
                }
            }
            if ('/' != File.separatorChar) {
                path = path.replace('/', File.separatorChar);
            }
            for (i = 0; i < ClassServer.this.dirs.length; ++i) {
                File f = new File(ClassServer.this.dirs[i] + path);
                if (!ClassServer.this.perms[i].implies(new FilePermission(f.getPath(), "read"))) continue;
                try {
                    return this.getBytes(new FileInputStream(f), f.length());
                }
                catch (FileNotFoundException e) {
                    // empty catch block
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block51: {
                block50: {
                    block49: {
                        block48: {
                            block47: {
                                block46: {
                                    block45: {
                                        try {
                                            try {
                                                out = new DataOutputStream(this.sock.getOutputStream());
                                                try {
                                                    req = ClassServer.access$400(this.sock, true);
                                                }
                                                catch (Exception e) {
                                                    if (ClassServer.access$500(ClassServer.this)) {
                                                        ClassServer.access$600("classserver.inputerror", new String[]{this.sock.getInetAddress().getHostName(), Integer.toString(this.sock.getPort())});
                                                        e.printStackTrace();
                                                    }
                                                    ClassServer.access$700().log(Levels.HANDLED, "reading request", e);
                                                    var10_7 = null;
                                                    try {
                                                        this.sock.close();
                                                        return;
                                                    }
                                                    catch (IOException e) {
                                                        // empty catch block
                                                    }
                                                    return;
                                                }
                                                if (req == null) {
                                                    var10_8 = null;
                                                    break block45;
                                                }
                                                if (req.startsWith("SHUTDOWN *")) {
                                                    if (ClassServer.access$500(ClassServer.this)) {
                                                        ClassServer.access$600("classserver.shutdown", new String[]{this.sock.getInetAddress().getHostName(), Integer.toString(this.sock.getPort())});
                                                    }
                                                    ok = ClassServer.access$800(ClassServer.this);
                                                    try {
                                                        new ServerSocket(0, 1, this.sock.getInetAddress());
                                                    }
                                                    catch (IOException e) {
                                                        ok = false;
                                                    }
                                                    if (!ok) {
                                                        out.writeBytes("HTTP/1.0 403 Forbidden\r\n\r\n");
                                                        out.flush();
                                                        break block46;
                                                    }
                                                    try {
                                                        out.writeBytes("HTTP/1.0 200 OK\r\n\r\n");
                                                        out.flush();
                                                    }
                                                    catch (Exception e) {
                                                        if (ClassServer.access$500(ClassServer.this)) {
                                                            e.printStackTrace();
                                                        }
                                                        ClassServer.access$700().log(Levels.HANDLED, "writing response", e);
                                                    }
                                                    ClassServer.this.terminate();
                                                    break block47;
                                                }
                                                args = null;
                                                if (ClassServer.access$500(ClassServer.this) || ClassServer.access$700().isLoggable(Level.FINE)) {
                                                    args = new String[]{req, this.sock.getInetAddress().getHostName(), Integer.toString(this.sock.getPort())};
                                                }
                                                if (!(get = req.startsWith("GET ")) && !req.startsWith("HEAD ")) {
                                                    if (ClassServer.access$500(ClassServer.this)) {
                                                        ClassServer.access$600("classserver.badrequest", args);
                                                    }
                                                    ClassServer.access$700().log(Level.FINE, "bad request \"{0}\" from {1}:{2}", args);
                                                    out.writeBytes("HTTP/1.0 400 Bad Request\r\n\r\n");
                                                    out.flush();
                                                    break block48;
                                                }
                                                path = req.substring(get != false ? 4 : 5);
                                                i = path.indexOf(32);
                                                if (i > 0) {
                                                    path = path.substring(0, i);
                                                }
                                                if ((path = this.canon(path)) == null) {
                                                    if (ClassServer.access$500(ClassServer.this)) {
                                                        ClassServer.access$600("classserver.badrequest", (String[])args);
                                                    }
                                                    ClassServer.access$700().log(Level.FINE, "bad request \"{0}\" from {1}:{2}", args);
                                                    out.writeBytes("HTTP/1.0 400 Bad Request\r\n\r\n");
                                                    out.flush();
                                                    break block49;
                                                }
                                                if (args != null) {
                                                    args[0] = path;
                                                }
                                                if (ClassServer.access$500(ClassServer.this)) {
                                                    ClassServer.access$600(get != false ? "classserver.request" : "classserver.probe", (String[])args);
                                                }
                                                ClassServer.access$700().log(Level.FINER, get != false ? "{0} requested from {1}:{2}" : "{0} probed from {1}:{2}", args);
                                                try {
                                                    bytes = this.getBytes(path);
                                                }
                                                catch (Exception e) {
                                                    if (ClassServer.access$500(ClassServer.this)) {
                                                        e.printStackTrace();
                                                    }
                                                    ClassServer.access$700().log(Level.WARNING, "getting bytes", e);
                                                    out.writeBytes("HTTP/1.0 500 Internal Error\r\n\r\n");
                                                    out.flush();
                                                    var10_13 = null;
                                                    ** try [egrp 6[TRYBLOCK] [24 : 765->775)] { 
lbl90:
                                                    // 1 sources

                                                    this.sock.close();
                                                    return;
lbl92:
                                                    // 1 sources

                                                    catch (IOException e) {
                                                        // empty catch block
                                                    }
                                                    return;
                                                }
                                                if (bytes == null) {
                                                    if (ClassServer.access$500(ClassServer.this)) {
                                                        ClassServer.access$900("classserver.notfound", path);
                                                    }
                                                    ClassServer.access$700().log(Level.FINE, "{0} not found", path);
                                                    out.writeBytes("HTTP/1.0 404 Not Found\r\n\r\n");
                                                    out.flush();
                                                    break block50;
                                                }
                                                out.writeBytes("HTTP/1.0 200 OK\r\n");
                                                out.writeBytes("Content-Length: " + bytes.length + "\r\n");
                                                out.writeBytes("Content-Type: application/java\r\n\r\n");
                                                if (get) {
                                                    out.write(bytes);
                                                }
                                                out.flush();
                                                if (get) {
                                                    ClassServer.this.fileDownloaded(path, this.sock.getInetAddress());
                                                }
                                                break block51;
                                            }
                                            catch (Exception e) {
                                                if (ClassServer.access$500(ClassServer.this)) {
                                                    e.printStackTrace();
                                                }
                                                ClassServer.access$700().log(Levels.HANDLED, "writing response", e);
                                                var10_16 = null;
                                                try {}
                                                catch (IOException e) {
                                                    return;
                                                }
                                                this.sock.close();
                                                return;
                                            }
                                        }
                                        catch (Throwable var9_36) {
                                            var10_17 = null;
                                            ** try [egrp 6[TRYBLOCK] [24 : 765->775)] { 
lbl127:
                                            // 1 sources

                                            this.sock.close();
                                            throw var9_36;
lbl129:
                                            // 1 sources

                                            catch (IOException e) {
                                                // empty catch block
                                            }
                                            throw var9_36;
                                        }
                                    }
                                    ** try [egrp 6[TRYBLOCK] [24 : 765->775)] { 
lbl134:
                                    // 1 sources

                                    this.sock.close();
                                    return;
lbl136:
                                    // 1 sources

                                    catch (IOException e) {
                                        // empty catch block
                                    }
                                    return;
                                }
                                var10_9 = null;
                                ** try [egrp 6[TRYBLOCK] [24 : 765->775)] { 
lbl142:
                                // 1 sources

                                this.sock.close();
                                return;
lbl144:
                                // 1 sources

                                catch (IOException e) {
                                    // empty catch block
                                }
                                return;
                            }
                            var10_10 = null;
                            ** try [egrp 6[TRYBLOCK] [24 : 765->775)] { 
lbl150:
                            // 1 sources

                            this.sock.close();
                            return;
lbl152:
                            // 1 sources

                            catch (IOException e) {
                                // empty catch block
                            }
                            return;
                        }
                        var10_11 = null;
                        ** try [egrp 6[TRYBLOCK] [24 : 765->775)] { 
lbl158:
                        // 1 sources

                        this.sock.close();
                        return;
lbl160:
                        // 1 sources

                        catch (IOException e) {
                            // empty catch block
                        }
                        return;
                    }
                    var10_12 = null;
                    ** try [egrp 6[TRYBLOCK] [24 : 765->775)] { 
lbl166:
                    // 1 sources

                    this.sock.close();
                    return;
lbl168:
                    // 1 sources

                    catch (IOException e) {
                        // empty catch block
                    }
                    return;
                }
                var10_14 = null;
                ** try [egrp 6[TRYBLOCK] [24 : 765->775)] { 
lbl174:
                // 1 sources

                this.sock.close();
                return;
lbl176:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return;
            }
            var10_15 = null;
            try {}
            catch (IOException e) {}
            this.sock.close();
            return;
        }
    }
}

