/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.tool;

import com.sun.jini.tool.classdepend.ClassDepend;
import com.sun.jini.tool.classdepend.ClassDependParameters;
import com.sun.jini.tool.classdepend.ClassDependencyRelationship;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class ClassDep {
    private ClassDepend cd;
    private boolean files = false;
    private String classpath = "";
    private boolean edges = false;
    private boolean ignoreOuter = true;
    private final ArrayList inside = new ArrayList();
    private final ArrayList outside = new ArrayList();
    private final ArrayList classes = new ArrayList();
    private final ArrayList roots = new ArrayList();
    private final ArrayList prunes = new ArrayList();
    private boolean newRootDirBehavior;
    private final ArrayList insideRoots = new ArrayList();
    private final ArrayList outsideRoots = new ArrayList();
    private final ArrayList skips = new ArrayList();
    private final ArrayList tells = new ArrayList();
    private final ArrayList shows = new ArrayList();
    private final ArrayList hides = new ArrayList();
    private final SortedSet results = new TreeSet();
    private boolean failed;
    private static ResourceBundle resources;
    private static boolean resinit;

    public ClassDep() {
    }

    public ClassDep(String[] cmdLine) {
        this.setupOptions(cmdLine);
    }

    private static void add(String arg, ArrayList elts) {
        if (!arg.endsWith(".")) {
            arg = arg + '.';
        }
        if (".".equals(arg)) {
            arg = null;
        }
        elts.add(arg);
    }

    private void traverse(String path) {
        String apath = path;
        if (!apath.startsWith(File.separator)) {
            apath = File.separator + apath;
        }
        for (int i = 0; i < this.prunes.size(); ++i) {
            if (!apath.endsWith((String)this.prunes.get(i))) continue;
            return;
        }
        String[] files_ = new File(path).list();
        if (files_ == null) {
            return;
        }
        block1: for (int i = 0; i < files_.length; ++i) {
            int j;
            String file = files_[i];
            if (!file.endsWith(".class")) {
                this.traverse(path + File.separatorChar + file);
                continue;
            }
            file = apath + File.separatorChar + file.substring(0, file.length() - 6);
            for (j = 0; j < this.skips.size(); ++j) {
                String skip = (String)this.skips.get(j);
                int k = file.indexOf(skip);
                if (k >= 0 && (file.length() == (k += skip.length()) || file.charAt(k) == '$')) continue block1;
            }
            for (j = 0; j < this.inside.size(); ++j) {
                int k;
                if (this.inside.get(j) == null || (k = file.indexOf(File.separatorChar + ((String)this.inside.get(j)).replace('.', File.separatorChar))) < 0) continue;
                this.classes.add(file.substring(k + 1).replace(File.separatorChar, '.'));
            }
        }
    }

    private void traverse(String path, String rootPath) {
        String[] files_ = new File(path).list();
        if (files_ == null) {
            return;
        }
        String packageName = path.substring(rootPath.length(), path.length()) + File.separatorChar;
        block0: for (int i = 0; i < files_.length; ++i) {
            int j;
            String file = files_[i];
            if (!file.endsWith(".class")) {
                this.traverse(path + File.separatorChar + file, rootPath);
                continue;
            }
            if (!this.insideRoots.isEmpty()) {
                boolean matched = false;
                for (j = 0; j < this.insideRoots.size(); ++j) {
                    if (!packageName.startsWith((String)this.insideRoots.get(j))) continue;
                    matched = true;
                    break;
                }
                if (!matched) continue;
            }
            if (!this.outsideRoots.isEmpty()) {
                for (int j2 = 0; j2 < this.outsideRoots.size(); ++j2) {
                    if (!packageName.startsWith((String)this.outsideRoots.get(j2))) continue;
                    return;
                }
            }
            String className = packageName + file.substring(0, file.length() - 6);
            for (j = 0; j < this.skips.size(); ++j) {
                String skip = (String)this.skips.get(j);
                if (className.startsWith(skip) && (className.length() == skip.length() || className.charAt(skip.length()) == '$')) continue block0;
            }
            this.classes.add(className.substring(1).replace(File.separatorChar, '.'));
        }
    }

    public String[] compute() {
        this.failed = false;
        if (!this.newRootDirBehavior) {
            if (!this.insideRoots.isEmpty()) {
                this.failed = true;
                ClassDep.print("classdep.invalidoption", "-newdirbehavior", "-inroot");
            }
            if (!this.outsideRoots.isEmpty()) {
                this.failed = true;
                ClassDep.print("classdep.invalidoption", "-newdirbehavior", "-outroot");
            }
            if (this.failed) {
                return new String[0];
            }
        }
        Compare c = new Compare();
        Collections.sort(this.inside, c);
        Collections.sort(this.outside, c);
        Collections.sort(this.shows, c);
        Collections.sort(this.hides, c);
        for (int i = 0; i < this.roots.size(); ++i) {
            if (this.newRootDirBehavior) {
                this.traverse((String)this.roots.get(i), (String)this.roots.get(i));
                continue;
            }
            this.traverse((String)this.roots.get(i));
        }
        if (this.classpath.length() == 0) {
            this.classpath = null;
        }
        try {
            this.cd = ClassDepend.newInstance(this.classpath, null, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Map classDependencyRelationMap = null;
        try {
            classDependencyRelationMap = this.cd.getDependencyRelationshipMap(this.classes, true);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.tells.isEmpty()) {
            ClassDependParameters.CDPBuilder cdpb = new ClassDependParameters.CDPBuilder();
            ClassDependParameters cdp = cdpb.addOutsidePackagesOrClasses(this.addClassesRecursively(this.outside)).addOutsidePackagesOrClasses(this.skips).addInsidePackages(this.addClassesRecursively(this.inside)).addShowPackages(this.addClassesRecursively(this.shows)).addHidePackages(this.addClassesRecursively(this.hides)).ignoreOuterParentClass(this.ignoreOuter).excludePlatformClasses(false).edges(this.edges).build();
            Set result = this.cd.filterClassDependencyRelationShipMap(classDependencyRelationMap, cdp);
            Iterator itr = result.iterator();
            while (itr.hasNext()) {
                this.results.add(itr.next().toString());
            }
        } else {
            for (String name : this.tells) {
                ClassDependencyRelationship provider;
                Set dependants;
                if (!classDependencyRelationMap.containsKey(name) || (dependants = (provider = (ClassDependencyRelationship)classDependencyRelationMap.get(name)).getDependants()).isEmpty()) continue;
                for (ClassDependencyRelationship dependant : dependants) {
                    if (this.tells.size() > 1) {
                        ClassDep.print("classdep.cause", provider, dependant);
                        continue;
                    }
                    ClassDep.print("classdep.cause1", dependant);
                }
            }
        }
        return this.results.toArray(new String[this.results.size()]);
    }

    private List addClassesRecursively(List list) {
        int l = list.size();
        for (int i = 0; i < l; ++i) {
            list.set(i, list.get(i) + "**");
        }
        return list;
    }

    public static void usage() {
        ClassDep.print("classdep.usage", null);
    }

    public void setClassPath(String classpath) {
        this.classpath = classpath;
    }

    public void setFiles(boolean files) {
        this.files = files;
    }

    public void addHides(String packagePrefix) {
        ClassDep.add(packagePrefix, this.hides);
    }

    public void addInside(String packagePrefix) {
        ClassDep.add(packagePrefix, this.inside);
    }

    public void setEdges(boolean edges) {
        this.edges = edges;
    }

    public void addOutside(String packagePrefix) {
        ClassDep.add(packagePrefix, this.outside);
    }

    public void addPrune(String packagePrefix) {
        String arg = packagePrefix;
        if (arg.endsWith(".")) {
            arg = arg.substring(0, arg.length() - 1);
        }
        arg = File.separator + arg.replace('.', File.separatorChar);
        this.prunes.add(arg);
    }

    public void setRootDirBehavior(boolean newBehavior) {
        this.newRootDirBehavior = newBehavior;
    }

    public void addInsideRoot(String packagePrefix) {
        String arg = packagePrefix;
        if (arg.endsWith(".")) {
            arg = arg.substring(0, arg.length() - 1);
        }
        arg = arg.trim().length() == 0 ? File.separator : File.separator + arg.replace('.', File.separatorChar) + File.separator;
        this.insideRoots.add(arg);
    }

    public void addOutsideRoot(String packagePrefix) {
        String arg = packagePrefix;
        if (arg.endsWith(".")) {
            arg = arg.substring(0, arg.length() - 1);
        }
        arg = arg.trim().length() == 0 ? File.separator : File.separator + arg.replace('.', File.separatorChar) + File.separator;
        this.outsideRoots.add(arg);
    }

    public void addShow(String packagePrefix) {
        ClassDep.add(packagePrefix, this.shows);
    }

    public void addSkip(String packagePrefix) {
        String arg = packagePrefix;
        if (arg.endsWith(".")) {
            arg = arg.substring(0, arg.length() - 1);
        }
        arg = File.separator + arg.replace('.', File.separatorChar);
        this.skips.add(arg);
    }

    public void addTells(String className) {
        this.tells.add(className);
    }

    public void addRoots(String rootName) {
        if (rootName.endsWith(File.separator)) {
            rootName = rootName.substring(0, rootName.length() - 1);
        }
        this.roots.add(rootName);
    }

    public void addClasses(String className) {
        this.classes.add(className);
    }

    public boolean getFiles() {
        return this.files;
    }

    public String[] getResults() {
        Object[] vals = this.results.toArray(new String[this.results.size()]);
        Arrays.sort(vals);
        return vals;
    }

    public boolean hasFailed() {
        return this.failed;
    }

    public void setupOptions(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-newdirbehavior")) {
                this.newRootDirBehavior = true;
                continue;
            }
            if (arg.equals("-cp")) {
                this.setClassPath(args[++i]);
                continue;
            }
            if (arg.equals("-files")) {
                this.setFiles(true);
                continue;
            }
            if (arg.equals("-hide")) {
                this.addHides(args[++i]);
                continue;
            }
            if (arg.equals("-in")) {
                this.addInside(args[++i]);
                continue;
            }
            if (arg.equals("-edges")) {
                this.setEdges(true);
                continue;
            }
            if (arg.equals("-out")) {
                this.addOutside(args[++i]);
                continue;
            }
            if (arg.equals("-outer")) {
                this.ignoreOuter = false;
                continue;
            }
            if (arg.equals("-prune")) {
                this.addPrune(args[++i]);
                continue;
            }
            if (arg.equals("-inroot")) {
                this.addInsideRoot(args[++i]);
                continue;
            }
            if (arg.equals("-outroot")) {
                this.addOutsideRoot(args[++i]);
                continue;
            }
            if (arg.equals("-show")) {
                this.addShow(args[++i]);
                continue;
            }
            if (arg.equals("-skip")) {
                this.addSkip(args[++i]);
                continue;
            }
            if (arg.equals("-tell")) {
                this.addTells(args[++i]);
                continue;
            }
            if (arg.indexOf(File.separator) >= 0) {
                this.addRoots(arg);
                continue;
            }
            if (arg.startsWith("-")) {
                ClassDep.usage();
                continue;
            }
            this.addClasses(arg);
        }
    }

    private static synchronized String getString(String key) {
        if (!resinit) {
            resinit = true;
            try {
                resources = ResourceBundle.getBundle("com.sun.jini.tool.resources.classdep");
            }
            catch (MissingResourceException e) {
                e.printStackTrace();
            }
        }
        if (resources != null) {
            try {
                return resources.getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return null;
    }

    private static void print(String key, Object val) {
        String fmt = ClassDep.getString(key);
        if (fmt == null) {
            fmt = "no text found: \"" + key + "\" {0}";
        }
        System.err.println(MessageFormat.format(fmt, val));
    }

    private static void print(String key, Object val1, Object val2) {
        String fmt = ClassDep.getString(key);
        if (fmt == null) {
            fmt = "no text found: \"" + key + "\" {0} {1}";
        }
        System.err.println(MessageFormat.format(fmt, val1, val2));
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            ClassDep.usage();
            return;
        }
        ClassDep dep = new ClassDep();
        dep.setupOptions(args);
        String[] vals = dep.compute();
        for (int i = 0; i < vals.length; ++i) {
            if (dep.getFiles()) {
                System.out.println(vals[i].replace('.', File.separatorChar) + ".class");
                continue;
            }
            System.out.println(vals[i]);
        }
    }

    static {
        resinit = false;
    }

    private static class Compare
    implements Comparator {
        private Compare() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 == null) {
                return o2 == null ? 0 : 1;
            }
            return o2 == null ? -1 : ((Comparable)o2).compareTo(o1);
        }
    }
}

