/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.tool;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationFile;

public class CheckConfigurationFile {
    private static final Class[] primitives = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
    private static final String RESOURCE = "META-INF/services/" + Configuration.class.getName();
    private static ResourceBundle resources;
    private static boolean resinit;

    private CheckConfigurationFile() {
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            CheckConfigurationFile.usage();
        } else if (args.length == 1 && "-help".equals(args[0])) {
            CheckConfigurationFile.print(System.err, "checkconfig.usage", File.pathSeparator);
            return;
        }
        String classPath = null;
        String entriesPath = null;
        boolean stdin = false;
        int i = 0;
        while (i < args.length) {
            if ("-cp".equals(args[i])) {
                if (args.length < i + 2) {
                    CheckConfigurationFile.usage();
                }
                classPath = args[i + 1];
                i += 2;
                continue;
            }
            if ("-entries".equals(args[i])) {
                if (args.length < i + 2) {
                    CheckConfigurationFile.usage();
                }
                entriesPath = args[i + 1];
                i += 2;
                continue;
            }
            if (!"-stdin".equals(args[i])) break;
            stdin = true;
            ++i;
        }
        if (!stdin && i == args.length) {
            CheckConfigurationFile.usage();
        }
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        if (classPath != null) {
            loader = loader.getParent();
        }
        String[] configOptions = new String[args.length - i];
        System.arraycopy(args, i, configOptions, 0, configOptions.length);
        boolean ok = CheckConfigurationFile.check(classPath, loader, stdin, configOptions, entriesPath, System.err);
        if (!ok) {
            System.exit(1);
        }
    }

    private static void usage() {
        CheckConfigurationFile.print(System.err, "checkconfig.usage", File.pathSeparator);
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static Properties getEntries(String files, PrintStream err) {
        Properties entries = new Properties();
        StringTokenizer tokens = new StringTokenizer(files, File.pathSeparator);
        while (tokens.hasMoreTokens()) {
            String file = tokens.nextToken();
            BufferedInputStream in = null;
            in = new BufferedInputStream(new FileInputStream(file));
            entries.load(in);
            Object var9_6 = null;
            if (in == null) continue;
            try {
                ((InputStream)in).close();
            }
            catch (IOException e2) {}
            continue;
            {
                catch (FileNotFoundException e) {
                    CheckConfigurationFile.print(err, "checkconfig.notfound", file);
                    Properties properties = null;
                    var9_6 = null;
                    if (in != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                    }
                    return properties;
                }
                catch (Throwable t) {
                    Properties properties;
                    block15: {
                        try {
                            CheckConfigurationFile.print(err, "checkconfig.read.err", new String[]{file, t.getClass().getName(), t.getLocalizedMessage()});
                            t.printStackTrace(err);
                            properties = null;
                            var9_6 = null;
                            if (in == null) break block15;
                        }
                        catch (Throwable throwable) {
                            var9_6 = null;
                            if (in != null) {
                                try {
                                    ((InputStream)in).close();
                                }
                                catch (IOException e2) {
                                    // empty catch block
                                }
                            }
                            throw throwable;
                        }
                        try {
                            ((InputStream)in).close();
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                    }
                    return properties;
                }
            }
        }
        return entries;
    }

    public static boolean check(String classPath, ClassLoader loader, String[] configOptions, String entriesPath, PrintStream err) {
        if (loader == null || configOptions == null || err == null) {
            throw new NullPointerException();
        }
        return CheckConfigurationFile.check(classPath, loader, false, configOptions, entriesPath, err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean check(String classPath, ClassLoader loader, boolean stdin, String[] configOptions, String entriesPath, PrintStream err) {
        String location;
        if (classPath != null) {
            StringTokenizer st = new StringTokenizer(classPath, File.pathSeparator);
            URL[] urls = new URL[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                String elt = st.nextToken();
                try {
                    urls[i] = new File(elt).toURI().toURL();
                }
                catch (MalformedURLException e) {
                    CheckConfigurationFile.print(err, "checkconfig.classpath", elt);
                    return false;
                }
                ++i;
            }
            loader = URLClassLoader.newInstance(urls, loader);
        }
        Properties entries = null;
        if (entriesPath != null && (entries = CheckConfigurationFile.getEntries(entriesPath, err)) == null) {
            return false;
        }
        if (configOptions.length == 0) {
            location = "(stdin)";
        } else {
            configOptions = (String[])configOptions.clone();
            location = configOptions[0];
            configOptions[0] = "-";
        }
        Constructor configCons = CheckConfigurationFile.getProviderConstructor(loader, err);
        if (configCons == null) {
            return false;
        }
        try {
            Object config;
            InputStream in;
            if (stdin) {
                in = System.in;
            } else if ("-".equals(location)) {
                in = new ByteArrayInputStream(new byte[0]);
            } else {
                try {
                    URL url = new URL(location);
                    in = url.openStream();
                }
                catch (MalformedURLException e) {
                    in = new FileInputStream(location);
                }
            }
            try {
                config = configCons.newInstance(new InputStreamReader(in), configOptions, loader);
                Object var12_16 = null;
                if (stdin) return CheckConfigurationFile.check(config, entries, loader, err);
            }
            catch (Throwable throwable) {
                Object var12_17 = null;
                if (stdin) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                in.close();
                return CheckConfigurationFile.check(config, entries, loader, err);
            }
            catch (IOException e) {}
            return CheckConfigurationFile.check(config, entries, loader, err);
        }
        catch (FileNotFoundException e) {
            CheckConfigurationFile.print(err, "checkconfig.notfound", location);
            return false;
        }
        catch (Throwable t) {
            CheckConfigurationFile.print(err, "checkconfig.read", location, t);
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private static Constructor getProviderConstructor(ClassLoader loader, PrintStream err) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getProviderName(URL url, PrintStream err) {
        block19: {
            block18: {
                block17: {
                    in = null;
                    try {
                        try {
                            block16: {
                                in = url.openStream();
                                reader = new BufferedReader(new InputStreamReader(in, "utf-8"));
                                result = null;
                                while (true) {
                                    if ((line = reader.readLine()) == null) {
                                        if (result == null) {
                                            break;
                                        }
                                        break block16;
                                    }
                                    commentPos = line.indexOf(35);
                                    if (commentPos >= 0) {
                                        line = line.substring(0, commentPos);
                                    }
                                    if ((len = (line = line.trim()).length()) == 0) continue;
                                    if (result != null) {
                                        CheckConfigurationFile.print(err, "checkconfig.multiproviders", url.toString());
                                        var8_10 = null;
                                        var10_11 = null;
                                        if (in == null) return var8_10;
                                        break block17;
                                    }
                                    result = line;
                                }
                                CheckConfigurationFile.print(err, "checkconfig.missingprovider", url.toString());
                                var5_7 = null;
                                break block18;
                            }
                            var5_7 = result;
                            break block19;
                        }
                        catch (IOException e) {
                            CheckConfigurationFile.print(err, "configconfig.read", url.toString(), e);
                            var4_6 = null;
                            var10_14 = null;
                            if (in == null) return var4_6;
                            try {
                                in.close();
                                return var4_6;
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                            return var4_6;
                        }
                    }
                    catch (Throwable var9_21) {
                        var10_15 = null;
                        if (in == null) throw var9_21;
                        try {}
                        catch (IOException e) {
                            throw var9_21;
                        }
                        in.close();
                        throw var9_21;
                    }
                }
                ** try [egrp 2[TRYBLOCK] [8 : 185->192)] { 
lbl56:
                // 1 sources

                in.close();
                return var8_10;
lbl58:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return var8_10;
            }
            var10_12 = null;
            if (in == null) return var5_7;
            ** try [egrp 2[TRYBLOCK] [8 : 185->192)] { 
lbl65:
            // 1 sources

            in.close();
            return var5_7;
lbl67:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
            return var5_7;
        }
        var10_13 = null;
        if (in == null) return var5_7;
        try {}
        catch (IOException e) {
            // empty catch block
            return var5_7;
        }
        in.close();
        return var5_7;
    }

    public static boolean check(ConfigurationFile config, Properties entries, ClassLoader loader, PrintStream err) {
        if (config == null || loader == null || err == null) {
            throw new NullPointerException();
        }
        return CheckConfigurationFile.check((Object)config, entries, loader, err);
    }

    private static boolean check(Object config, Properties entries, ClassLoader loader, PrintStream err) {
        Object[] entryNames;
        Method getType;
        try {
            getType = config.getClass().getMethod("getEntryType", String.class, String.class);
            Method getNames = config.getClass().getMethod("getEntryNames", null);
            Set entrySet = (Set)getNames.invoke(config, new Object[0]);
            entryNames = entrySet.toArray(new String[entrySet.size()]);
        }
        catch (Throwable t) {
            CheckConfigurationFile.print(err, "checkconfig.unexpected", "", t);
            return false;
        }
        Arrays.sort(entryNames);
        boolean ok = true;
        for (int i = 0; i < entryNames.length; ++i) {
            String expectedTypeName;
            Object entryName = entryNames[i];
            String string = expectedTypeName = entries != null ? entries.getProperty((String)entryName) : null;
            if (entries != null && expectedTypeName == null) {
                CheckConfigurationFile.print(err, "checkconfig.unknown", (String)entryName);
                ok = false;
            }
            try {
                int dot = ((String)entryName).lastIndexOf(46);
                String component = ((String)entryName).substring(0, dot);
                String name = ((String)entryName).substring(dot + 1);
                Class type = (Class)getType.invoke(config, component, name);
                if (expectedTypeName == null) continue;
                try {
                    Class expectedType = CheckConfigurationFile.findClass(expectedTypeName, loader);
                    if (CheckConfigurationFile.isAssignableFrom(expectedType, type)) continue;
                    CheckConfigurationFile.print(err, "checkconfig.mismatch", new String[]{entryName, CheckConfigurationFile.typeName(type), CheckConfigurationFile.typeName(expectedType)});
                    ok = false;
                }
                catch (ClassNotFoundException e) {
                    CheckConfigurationFile.print(err, "checkconfig.expect.fail", new String[]{entryName, e.getMessage()});
                    ok = false;
                }
                catch (Throwable t) {
                    CheckConfigurationFile.print(err, "checkconfig.expect.err", new String[]{entryName, expectedTypeName, t.getClass().getName(), t.getLocalizedMessage()});
                    t.printStackTrace(err);
                    ok = false;
                }
                continue;
            }
            catch (Throwable t) {
                CheckConfigurationFile.print(err, "checkconfig.actual", (String)entryName, t);
                ok = false;
            }
        }
        return ok;
    }

    private static Class findClass(String name, ClassLoader loader) throws ClassNotFoundException {
        if (name.indexOf(46) < 0) {
            int i = primitives.length;
            while (--i >= 0) {
                if (!name.equals(primitives[i].getName())) continue;
                return primitives[i];
            }
        }
        try {
            return Class.forName(name, false, loader);
        }
        catch (ClassNotFoundException notFound) {
            int bracket = name.indexOf(91);
            if (bracket > 0) {
                int dims = 0;
                int len = name.length();
                int i = bracket;
                while (i < len) {
                    if (name.charAt(i) != '[' || i + 1 >= len || name.charAt(i + 1) != ']') {
                        throw notFound;
                    }
                    i += 2;
                    ++dims;
                }
                try {
                    Class base = CheckConfigurationFile.findClass(name.substring(0, bracket), loader);
                    return Array.newInstance(base, new int[dims]).getClass();
                }
                catch (ClassNotFoundException e) {}
            } else if (name.indexOf(46) < 0) {
                try {
                    return CheckConfigurationFile.findClass("java.lang." + name, loader);
                }
                catch (ClassNotFoundException e) {
                }
            } else {
                int dot;
                while ((dot = name.lastIndexOf(46)) >= 0) {
                    name = name.substring(0, dot) + '$' + name.substring(dot + 1);
                    try {
                        return Class.forName(name, false, loader);
                    }
                    catch (ClassNotFoundException e) {
                    }
                }
            }
            throw notFound;
        }
    }

    private static String typeName(Class type) {
        if (type == null) {
            return "null";
        }
        StringBuffer buf = new StringBuffer();
        if (type.isArray()) {
            Class<?> component;
            while ((component = type.getComponentType()) != null) {
                buf.append("[]");
                type = component;
            }
        }
        return type.getName().replace('$', '.') + buf;
    }

    private static boolean isAssignableFrom(Class dest, Class source) {
        if (dest.isPrimitive()) {
            return source == dest;
        }
        return source == null || dest.isAssignableFrom(source);
    }

    private static synchronized String getString(String key, PrintStream err) {
        if (!resinit) {
            try {
                resinit = true;
                resources = ResourceBundle.getBundle("com.sun.jini.tool.resources.checkconfig");
            }
            catch (MissingResourceException e) {
                e.printStackTrace(err);
            }
        }
        try {
            return resources != null ? resources.getString(key) : null;
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    private static void print(PrintStream err, String keyPrefix, String source, Throwable t) {
        if (t instanceof InvocationTargetException) {
            t = t.getCause();
        }
        if (t.getClass().getName().equals(ConfigurationException.class.getName())) {
            if (t.getCause() == null) {
                CheckConfigurationFile.print(err, keyPrefix + ".fail", new String[]{source, t.getLocalizedMessage()});
                return;
            }
            t = t.getCause();
        }
        CheckConfigurationFile.print(err, keyPrefix + ".err", new String[]{source, t.getClass().getName(), t.getLocalizedMessage()});
        t.printStackTrace(err);
    }

    private static void print(PrintStream err, String key, String val) {
        CheckConfigurationFile.print(err, key, new String[]{val});
    }

    private static void print(PrintStream err, String key, String[] vals) {
        String fmt = CheckConfigurationFile.getString(key, err);
        if (fmt == null) {
            fmt = "no text found: \"" + key + "\" {0}";
        }
        err.println(MessageFormat.format(fmt, vals));
    }

    static {
        resinit = false;
    }
}

