/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.start;

import com.sun.jini.start.ServiceDescriptor;
import com.sun.jini.start.ServiceStarter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroupDesc;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Logger;
import net.jini.config.Configuration;

public class SharedActivationGroupDescriptor
implements ServiceDescriptor,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String policy;
    private final String classpath;
    private final String log;
    private final String serverCommand;
    private final String[] serverOptions;
    private final Properties serverProperties;
    private final String host;
    private final int port;
    private static final String GROUP_COOKIE_FILE = "cookie";
    private static final Logger logger = ServiceStarter.logger;

    public SharedActivationGroupDescriptor(String policy, String classpath, String log, String serverCommand, String[] serverOptions, String[] serverProperties) {
        this(policy, classpath, log, serverCommand, serverOptions, serverProperties, null, ServiceStarter.getActivationSystemPort());
    }

    public SharedActivationGroupDescriptor(String policy, String classpath, String log, String serverCommand, String[] serverOptions, String[] serverProperties, String host, int port) {
        if (policy == null || classpath == null || log == null) {
            throw new NullPointerException("Policy, classpath, or log cannot be null");
        }
        this.policy = policy;
        this.classpath = classpath;
        this.log = log;
        this.serverCommand = serverCommand;
        this.serverOptions = SharedActivationGroupDescriptor.customizeSharedGroupOptions(classpath, serverOptions);
        Properties props = SharedActivationGroupDescriptor.convertToProperties(serverProperties);
        this.serverProperties = SharedActivationGroupDescriptor.customizeSharedGroupProperties(policy, props);
        this.host = host == null ? "" : host;
        this.port = port <= 0 ? ServiceStarter.getActivationSystemPort() : port;
    }

    public final String getPolicy() {
        return this.policy;
    }

    public final String getClasspath() {
        return this.classpath;
    }

    public final String getLog() {
        return this.log;
    }

    public final String getServerCommand() {
        return this.serverCommand;
    }

    public final String[] getServerOptions() {
        return (String[])this.serverOptions.clone();
    }

    public final Properties getServerProperties() {
        return (Properties)this.serverProperties.clone();
    }

    public final String getActivationSystemHost() {
        return this.host;
    }

    public final int getActivationSystemPort() {
        return this.port;
    }

    private static String[] customizeSharedGroupOptions(String classpath, String[] userOptions) {
        String[] customOpts = new String[]{"-cp", classpath};
        if (userOptions != null) {
            String[] tmp = new String[customOpts.length + userOptions.length];
            System.arraycopy(customOpts, 0, tmp, 0, customOpts.length);
            System.arraycopy(userOptions, 0, tmp, customOpts.length, userOptions.length);
            customOpts = tmp;
        }
        return customOpts;
    }

    private static Properties convertToProperties(String[] propertyValues) {
        Properties properties = new Properties();
        if (propertyValues == null || propertyValues.length == 0) {
            return properties;
        }
        if (propertyValues.length % 2 != 0) {
            throw new IllegalArgumentException("The service properties entry has an odd number of elements");
        }
        for (int i = 0; i < propertyValues.length; i += 2) {
            properties.setProperty(propertyValues[i], propertyValues[i + 1]);
        }
        return properties;
    }

    private static Properties customizeSharedGroupProperties(String policy, Properties userProperties) {
        if (userProperties == null) {
            userProperties = new Properties();
        }
        userProperties.put("java.security.policy", policy);
        return userProperties;
    }

    public Object create(Configuration config) throws Exception {
        ServiceStarter.ensureSecurityManager();
        logger.entering(SharedActivationGroupDescriptor.class.getName(), "create", new Object[]{config});
        if (config == null) {
            throw new NullPointerException("Configuration argument cannot be null");
        }
        ActivationSystem sys = ServiceStarter.getActivationSystem(this.getActivationSystemHost(), this.getActivationSystemPort(), config);
        ActivationGroupDesc.CommandEnvironment cmdToExecute = new ActivationGroupDesc.CommandEnvironment(this.getServerCommand(), this.getServerOptions());
        ActivationGroupID gid = null;
        try {
            gid = sys.registerGroup(new ActivationGroupDesc(this.getServerProperties(), cmdToExecute));
            SharedActivationGroupDescriptor.storeGroupID(this.getLog(), gid);
        }
        catch (Exception e) {
            try {
                if (gid != null) {
                    sys.unregisterGroup(gid);
                }
            }
            catch (Exception ee) {
                // empty catch block
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof ActivationException) {
                throw (ActivationException)e;
            }
            if (e instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)e;
            }
            throw new RuntimeException("Unexpected Exception", e);
        }
        logger.exiting(SharedActivationGroupDescriptor.class.getName(), "create", gid);
        return gid;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void storeGroupID(String dir, ActivationGroupID obj) throws IOException {
        File log = new File(dir);
        String absDir = log.getAbsolutePath();
        if (log.exists()) {
            throw new IOException("Log " + absDir + " exists." + " Please delete or select another path");
        }
        if (!log.mkdir()) {
            throw new IOException("Could not create directory: " + absDir);
        }
        File cookieFile = new File(log, GROUP_COOKIE_FILE);
        ObjectOutputStream oos = null;
        try {
            try {
                oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(cookieFile)));
                oos.writeObject(new MarshalledObject<ActivationGroupID>(obj));
                oos.flush();
            }
            catch (IOException e) {
                cookieFile.delete();
                throw (IOException)e.fillInStackTrace();
            }
            Object var8_6 = null;
            if (oos == null) return;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (oos == null) throw throwable;
            oos.close();
            throw throwable;
        }
        oos.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ActivationGroupID restoreGroupID(String dir) throws IOException, ClassNotFoundException {
        File log = new File(dir);
        String absDir = log.getAbsolutePath();
        if (!log.exists() || !log.isDirectory()) {
            throw new IOException("Log directory [" + absDir + "] does not exist.");
        }
        File cookieFile = new File(log, GROUP_COOKIE_FILE);
        ObjectInputStream ois = null;
        ActivationGroupID obj = null;
        try {
            ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(cookieFile)));
            MarshalledObject mo = (MarshalledObject)ois.readObject();
            obj = (ActivationGroupID)mo.get();
            Object var8_7 = null;
            if (ois == null) return obj;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (ois == null) throw throwable;
            ois.close();
            throw throwable;
        }
        ois.close();
        return obj;
    }

    public String toString() {
        ArrayList<Object> fields = new ArrayList<Object>(8);
        fields.add(this.policy);
        fields.add(this.classpath);
        fields.add(this.log);
        fields.add(this.serverCommand);
        fields.add(Arrays.asList(this.serverOptions));
        fields.add(this.serverProperties);
        fields.add(this.host);
        fields.add(new Integer(this.port));
        return fields.toString();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.policy == null) {
            throw new InvalidObjectException("null policy");
        }
        if (this.classpath == null) {
            throw new InvalidObjectException("null class path");
        }
        if (this.log == null) {
            throw new InvalidObjectException("null log");
        }
        if (this.serverOptions == null) {
            throw new InvalidObjectException("null server options");
        }
        if (this.serverProperties == null) {
            throw new InvalidObjectException("null server properties");
        }
        if (this.host == null) {
            throw new InvalidObjectException("null activation host name");
        }
        if (this.port <= 0) {
            throw new InvalidObjectException("invalid activation port: " + this.port);
        }
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new InvalidObjectException("no data");
    }
}

