/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.start;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class ClassLoaderUtil {
    static final Logger logger = Logger.getLogger("com.sun.jini.start.ClassLoaderUtil");

    private ClassLoaderUtil() {
    }

    public static URL[] getClasspathURLs(String classpath) throws IOException, MalformedURLException {
        StringTokenizer st = new StringTokenizer(classpath, File.pathSeparator);
        URL[] urls = new URL[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            urls[i] = new File(st.nextToken()).getCanonicalFile().toURI().toURL();
            ++i;
        }
        return urls;
    }

    public static URL[] getCodebaseURLs(String codebase) throws MalformedURLException {
        StringTokenizer st = new StringTokenizer(codebase);
        URL[] urls = new URL[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            urls[i] = new URL(st.nextToken());
            ++i;
        }
        return urls;
    }

    public static URL[] getImportCodebaseURLs(String importCodebase) throws IOException, MalformedURLException {
        try {
            return ClassLoaderUtil.getCodebaseURLs(importCodebase);
        }
        catch (MalformedURLException me) {
            return ClassLoaderUtil.getClasspathURLs(importCodebase);
        }
    }

    private static ArrayList getContextClassLoaderTree() {
        Thread curThread = Thread.currentThread();
        ClassLoader curClassLoader = curThread.getContextClassLoader();
        return ClassLoaderUtil.getClassLoaderTree(curClassLoader);
    }

    private static ArrayList getClassLoaderTree(ClassLoader classloader) {
        ArrayList<ClassLoader> loaderList = new ArrayList<ClassLoader>();
        while (classloader != null) {
            loaderList.add(classloader);
            classloader = classloader.getParent();
        }
        loaderList.add(null);
        Collections.reverse(loaderList);
        return loaderList;
    }

    public static void displayContextClassLoaderTree() {
        Thread curThread = Thread.currentThread();
        ClassLoader curClassLoader = curThread.getContextClassLoader();
        ClassLoaderUtil.displayClassLoaderTree(curClassLoader);
    }

    public static void displayClassLoaderTree(ClassLoader classloader) {
        ArrayList loaderList = ClassLoaderUtil.getClassLoaderTree(classloader);
        System.out.println("");
        System.out.println("ClassLoader Tree has " + loaderList.size() + " levels");
        System.out.println("  cl0 -- Boot ClassLoader ");
        ClassLoader curClassLoader = null;
        for (int i = 1; i < loaderList.size(); ++i) {
            System.out.println("   |");
            curClassLoader = (ClassLoader)loaderList.get(i);
            System.out.print("  cl" + i + " -- ClassLoader " + curClassLoader + ": ");
            if (curClassLoader instanceof URLClassLoader) {
                URL[] urls = ((URLClassLoader)curClassLoader).getURLs();
                if (urls != null) {
                    System.out.print(urls[0]);
                    for (int j = 1; j < urls.length; ++j) {
                        System.out.print(", " + urls[j]);
                    }
                } else {
                    System.out.print("null search path");
                }
            } else if (curClassLoader instanceof SecureClassLoader) {
                System.out.print("is instance of SecureClassLoader");
            } else {
                System.out.print("is unknown ClassLoader type");
            }
            System.out.println("");
        }
        System.out.println("");
    }
}

