/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.webserver;

import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.driver.catalog.NodeDescriptor;
import org.apache.reef.driver.context.ActiveContext;
import org.apache.reef.driver.evaluator.AllocatedEvaluator;
import org.apache.reef.driver.evaluator.EvaluatorDescriptor;
import org.apache.reef.driver.task.RunningTask;
import org.apache.reef.runtime.common.driver.DriverStatusManager;
import org.apache.reef.runtime.common.utils.RemoteManager;
import org.apache.reef.tang.annotations.Unit;
import org.apache.reef.wake.EventHandler;
import org.apache.reef.wake.time.event.StartTime;
import org.apache.reef.wake.time.event.StopTime;
import org.apache.reef.webserver.AvroReefServiceInfo;

@Unit
public final class ReefEventStateManager {
    private static final Logger LOG = Logger.getLogger(ReefEventStateManager.class.getName());
    private static final Format format = new SimpleDateFormat("yyyy MM dd HH:mm:ss");
    private final Map<String, EvaluatorDescriptor> evaluators = new HashMap<String, EvaluatorDescriptor>();
    private final Map<String, ActiveContext> contexts = new HashMap<String, ActiveContext>();
    private final List<AvroReefServiceInfo> serviceInfoList = new ArrayList<AvroReefServiceInfo>();
    private final RemoteManager remoteManager;
    private final DriverStatusManager driverStatusManager;
    private StartTime startTime;
    private StopTime stopTime;

    @Inject
    public ReefEventStateManager(RemoteManager remoteManager, DriverStatusManager driverStatusManager) {
        this.remoteManager = remoteManager;
        this.driverStatusManager = driverStatusManager;
    }

    public String getStartTime() {
        if (this.startTime != null) {
            return this.convertTime(this.startTime.getTimeStamp());
        }
        return null;
    }

    public String getStopTime() {
        if (this.stopTime != null) {
            return this.convertTime(this.stopTime.getTimeStamp());
        }
        return null;
    }

    private String convertTime(long time) {
        Date date = new Date(time);
        return format.format(date).toString();
    }

    public Map<String, EvaluatorDescriptor> getEvaluators() {
        return this.evaluators;
    }

    public String getDriverEndpointIdentifier() {
        return this.remoteManager.getMyIdentifier();
    }

    public List<AvroReefServiceInfo> getServicesInfo() {
        return this.serviceInfoList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerServiceInfo(AvroReefServiceInfo serviceInfo) {
        List<AvroReefServiceInfo> list = this.serviceInfoList;
        synchronized (list) {
            this.serviceInfoList.add(serviceInfo);
            LOG.log(Level.INFO, "Registered Service [{0}] with Info [{1}]", new Object[]{serviceInfo.getServiceName(), serviceInfo.getServiceInfo()});
        }
    }

    public Map<String, ActiveContext> getContexts() {
        return this.contexts;
    }

    public void put(String key, EvaluatorDescriptor value) {
        this.evaluators.put(key, value);
    }

    public EvaluatorDescriptor get(String key) {
        return this.evaluators.get(key);
    }

    public EvaluatorDescriptor getEvaluatorDescriptor(String evaluatorId) {
        return this.evaluators.get(evaluatorId);
    }

    public NodeDescriptor getEvaluatorNodeDescriptor(String evaluatorId) {
        return this.evaluators.get(evaluatorId).getNodeDescriptor();
    }

    public void OnClientKill() {
        this.driverStatusManager.onComplete();
    }

    public final class ClientMessageStateHandler
    implements EventHandler<byte[]> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(byte[] message) {
            ReefEventStateManager reefEventStateManager = ReefEventStateManager.this;
            synchronized (reefEventStateManager) {
                LOG.log(Level.INFO, "ClientMessageStateHandler OnNext called");
            }
        }
    }

    public final class DrivrRestartActiveContextStateHandler
    implements EventHandler<ActiveContext> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(ActiveContext context) {
            ReefEventStateManager reefEventStateManager = ReefEventStateManager.this;
            synchronized (reefEventStateManager) {
                LOG.log(Level.INFO, "Active Context {0} received and handled in state handler during driver restart.", context);
                ReefEventStateManager.this.evaluators.put(context.getEvaluatorId(), context.getEvaluatorDescriptor());
                ReefEventStateManager.this.contexts.put(context.getId(), context);
            }
        }
    }

    public final class ActiveContextStateHandler
    implements EventHandler<ActiveContext> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(ActiveContext context) {
            ReefEventStateManager reefEventStateManager = ReefEventStateManager.this;
            synchronized (reefEventStateManager) {
                LOG.log(Level.INFO, "Active Context {0} received and handled in state handler", context);
                ReefEventStateManager.this.contexts.put(context.getId(), context);
            }
        }
    }

    public final class DriverRestartTaskRunningStateHandler
    implements EventHandler<RunningTask> {
        public void onNext(RunningTask runningTask) {
            LOG.log(Level.INFO, "Running task {0} received during driver restart.", runningTask.getId());
        }
    }

    public final class TaskRunningStateHandler
    implements EventHandler<RunningTask> {
        public void onNext(RunningTask runningTask) {
            LOG.log(Level.INFO, "Running task {0} received.", runningTask.getId());
        }
    }

    public final class AllocatedEvaluatorStateHandler
    implements EventHandler<AllocatedEvaluator> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(AllocatedEvaluator eval) {
            ReefEventStateManager reefEventStateManager = ReefEventStateManager.this;
            synchronized (reefEventStateManager) {
                ReefEventStateManager.this.put(eval.getId(), eval.getEvaluatorDescriptor());
            }
        }
    }

    public final class StopStateHandler
    implements EventHandler<StopTime> {
        public void onNext(StopTime stopTime) {
            LOG.log(Level.INFO, "StopStateHandler called. StopTime: {0}", stopTime);
            ReefEventStateManager.this.stopTime = stopTime;
        }
    }

    public final class StartStateHandler
    implements EventHandler<StartTime> {
        public void onNext(StartTime startTime) {
            LOG.log(Level.INFO, "StartStateHandler: Driver started with endpoint identifier [{0}]  and StartTime [{1}]", new Object[]{ReefEventStateManager.this.remoteManager.getMyIdentifier(), startTime});
            ReefEventStateManager.this.startTime = startTime;
        }
    }
}

