/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.webserver;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public final class ParsedHttpRequest {
    private final String pathInfo;
    private final String method;
    private final String queryString;
    private final String requestUri;
    private final String requestUrl;
    private final byte[] inputStream;
    private final String targetSpecification;
    private final String version;
    private final String targetEntity;
    private final Map<String, String> headers = new HashMap<String, String>();
    private final Map<String, List<String>> queryPairs = new LinkedHashMap<String, List<String>>();

    public ParsedHttpRequest(HttpServletRequest request) throws IOException {
        this.pathInfo = request.getPathInfo() != null ? request.getPathInfo() : "";
        this.method = request.getMethod() != null ? request.getMethod() : "";
        this.queryString = request.getQueryString() != null ? request.getQueryString() : "";
        this.requestUri = request.getRequestURI() != null ? request.getRequestURI() : "";
        this.requestUrl = request.getRequestURL().toString();
        Enumeration en = request.getHeaderNames();
        while (en.hasMoreElements()) {
            String headerName = en.nextElement().toString();
            this.headers.put(headerName, request.getHeader(headerName));
        }
        int len = request.getContentLength();
        if (len > 0) {
            this.inputStream = new byte[len];
            request.getInputStream().read(this.inputStream);
        } else {
            this.inputStream = new byte[0];
        }
        String[] parts = this.requestUri.split("/");
        this.targetSpecification = parts.length > 1 ? parts[1] : null;
        this.version = parts.length > 2 ? parts[2] : null;
        String string = this.targetEntity = parts.length > 3 ? parts[3] : null;
        if (this.queryString != null && !this.queryString.isEmpty()) {
            String[] pairs;
            for (String pair : pairs = this.queryString.split("&")) {
                int idx = pair.indexOf("=");
                if (idx == -1) continue;
                String rKey = pair.substring(0, idx);
                String rValue = pair.substring(idx + 1);
                String key = URLDecoder.decode(rKey, "UTF-8");
                String value = URLDecoder.decode(rValue, "UTF-8");
                List<String> valuesList = this.queryPairs.get(key.toLowerCase());
                if (valuesList == null) {
                    valuesList = new ArrayList<String>(1);
                    this.queryPairs.put(key, valuesList);
                }
                valuesList.add(value);
            }
        }
    }

    public String getTargetSpecification() {
        return this.targetSpecification;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getTargetEntity() {
        return this.targetEntity;
    }

    public String getMethod() {
        return this.method;
    }

    public byte[] getInputStream() {
        return this.inputStream;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Map<String, List<String>> getQueryMap() {
        return this.queryPairs;
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public String getVersion() {
        return this.version;
    }
}

