/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.webserver;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.reef.tang.annotations.Parameter;
import org.apache.reef.webserver.HttpEventHandlers;
import org.apache.reef.webserver.HttpHandler;
import org.apache.reef.webserver.ParsedHttpRequest;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.handler.AbstractHandler;

class JettyHandler
extends AbstractHandler {
    private static final Logger LOG = Logger.getLogger(JettyHandler.class.getName());
    private final Map<String, HttpHandler> eventHandlers = new HashMap<String, HttpHandler>();

    @Inject
    JettyHandler(@Parameter(value=HttpEventHandlers.class) Set<HttpHandler> httpEventHandlers) {
        for (HttpHandler handler : httpEventHandlers) {
            if (!this.eventHandlers.containsKey(handler.getUriSpecification())) {
                this.eventHandlers.put(handler.getUriSpecification().toLowerCase(), handler);
                continue;
            }
            LOG.log(Level.WARNING, "The http event handler for {0} is already registered.", handler.getUriSpecification());
        }
    }

    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int i) throws IOException, ServletException {
        LOG.log(Level.INFO, "JettyHandler handle is entered with target: {0} ", target);
        Request baseRequest = request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest();
        response.setContentType("text/html;charset=utf-8");
        ParsedHttpRequest parsedHttpRequest = new ParsedHttpRequest(request);
        HttpHandler handler = this.validate(request, response, parsedHttpRequest);
        if (handler != null) {
            LOG.log(Level.INFO, "calling HttpHandler.onHttpRequest from JettyHandler.handle() for {0}.", handler.getUriSpecification());
            handler.onHttpRequest(parsedHttpRequest, response);
            response.setStatus(200);
        }
        baseRequest.setHandled(true);
        LOG.log(Level.INFO, "JettyHandler handle exists");
    }

    private HttpHandler validate(HttpServletRequest request, HttpServletResponse response, ParsedHttpRequest parsedHttpRequest) throws IOException, ServletException {
        String specification = parsedHttpRequest.getTargetSpecification();
        String version = parsedHttpRequest.getVersion();
        if (specification == null) {
            this.writeMessage(response, "Specification is not provided in the request.", 400);
            return null;
        }
        HttpHandler handler = this.eventHandlers.get(specification.toLowerCase());
        if (handler == null) {
            this.writeMessage(response, String.format("No event handler registered for: [%s].", specification), 404);
            return null;
        }
        if (version == null) {
            this.writeMessage(response, "Version is not provided in the request.", 400);
            return null;
        }
        return handler;
    }

    private void writeMessage(HttpServletResponse response, String message, int status) throws IOException {
        response.getWriter().println(message);
        response.setStatus(status);
    }

    final void addHandler(HttpHandler handler) {
        if (handler != null) {
            if (!this.eventHandlers.containsKey(handler.getUriSpecification().toLowerCase())) {
                this.eventHandlers.put(handler.getUriSpecification().toLowerCase(), handler);
            } else {
                LOG.log(Level.WARNING, "JettyHandler handle is already registered: {0} ", handler.getUriSpecification());
            }
        }
    }
}

