/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.webserver;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.reef.driver.evaluator.EvaluatorDescriptor;
import org.apache.reef.driver.parameters.ClientCloseHandlers;
import org.apache.reef.runtime.common.files.REEFFileNames;
import org.apache.reef.tang.Tang;
import org.apache.reef.tang.annotations.Parameter;
import org.apache.reef.tang.exceptions.InjectionException;
import org.apache.reef.util.logging.LogLevelName;
import org.apache.reef.util.logging.LogParser;
import org.apache.reef.util.logging.LoggingScopeFactory;
import org.apache.reef.wake.EventHandler;
import org.apache.reef.webserver.AvroDriverInfo;
import org.apache.reef.webserver.AvroEvaluatorList;
import org.apache.reef.webserver.AvroEvaluatorsInfo;
import org.apache.reef.webserver.AvroReefServiceInfo;
import org.apache.reef.webserver.DriverInfoSerializer;
import org.apache.reef.webserver.EvaluatorInfoSerializer;
import org.apache.reef.webserver.EvaluatorListSerializer;
import org.apache.reef.webserver.HttpHandler;
import org.apache.reef.webserver.ParsedHttpRequest;
import org.apache.reef.webserver.ReefEventStateManager;

public final class HttpServerReefEventHandler
implements HttpHandler {
    private static final Logger LOG = Logger.getLogger(HttpServerReefEventHandler.class.getName());
    private static final String ver = "v1";
    private final String driverStdoutFile;
    private final String driverStderrFile;
    private final ReefEventStateManager reefStateManager;
    private final Set<EventHandler<Void>> clientCloseHandlers;
    private final LoggingScopeFactory loggingScopeFactory;
    private final String logLevelPrefix;
    private String uriSpecification = "Reef";

    @Inject
    public HttpServerReefEventHandler(ReefEventStateManager reefStateManager, @Parameter(value=ClientCloseHandlers.class) Set<EventHandler<Void>> clientCloseHandlers, @Parameter(value=LogLevelName.class) String logLevel, LoggingScopeFactory loggingScopeFactory, REEFFileNames reefFileNames) {
        this.reefStateManager = reefStateManager;
        this.clientCloseHandlers = clientCloseHandlers;
        this.loggingScopeFactory = loggingScopeFactory;
        this.logLevelPrefix = logLevel + ": ";
        this.driverStdoutFile = reefFileNames.getDriverStdoutFileName();
        this.driverStderrFile = reefFileNames.getDriverStderrFileName();
    }

    private static String readFile(String fileName) throws IOException {
        return new String(Files.readAllBytes(Paths.get(fileName, new String[0])));
    }

    @Override
    public String getUriSpecification() {
        return this.uriSpecification;
    }

    @Override
    public void setUriSpecification(String s) {
        this.uriSpecification = s;
    }

    @Override
    public void onHttpRequest(ParsedHttpRequest parsedHttpRequest, HttpServletResponse response) throws IOException, ServletException {
        String target;
        LOG.log(Level.INFO, "HttpServerReefEventHandler in webserver onHttpRequest is called: {0}", parsedHttpRequest.getRequestUri());
        String version = parsedHttpRequest.getVersion().toLowerCase();
        switch (target = parsedHttpRequest.getTargetEntity().toLowerCase()) {
            case "evaluators": {
                String queryStr = parsedHttpRequest.getQueryString();
                if (queryStr == null || queryStr.isEmpty()) {
                    if (version.equals(ver)) {
                        this.writeEvaluatorsJsonOutput(response);
                        break;
                    }
                    this.writeEvaluatorsWebOutput(response);
                    break;
                }
                this.handleQueries(response, parsedHttpRequest.getQueryMap(), version);
                break;
            }
            case "driver": {
                if (version.equals(ver)) {
                    this.writeDriverJsonInformation(response);
                    break;
                }
                this.writeDriverWebInformation(response);
                break;
            }
            case "close": {
                for (EventHandler<Void> e : this.clientCloseHandlers) {
                    e.onNext(null);
                }
                response.getWriter().println("Enforced closing");
                break;
            }
            case "kill": {
                this.reefStateManager.OnClientKill();
                response.getWriter().println("Killing");
                break;
            }
            case "duration": {
                ArrayList lines = LogParser.getFilteredLinesFromFile((String)this.driverStderrFile, (String)" Duration = ", (String)":::", null);
                this.writeLines(response, lines, "Performance...");
                break;
            }
            case "stages": {
                ArrayList starts = LogParser.getFilteredLinesFromFile((String)this.driverStderrFile, (String)"START:::", (String)this.logLevelPrefix, null);
                ArrayList exits = LogParser.getFilteredLinesFromFile((String)this.driverStderrFile, (String)"EXIT:::", (String)this.logLevelPrefix, (String)" Duration = ");
                ArrayList startsStages = LogParser.findStages((ArrayList)starts, (String[])LogParser.startIndicators);
                ArrayList endStages = LogParser.findStages((ArrayList)exits, (String[])LogParser.endIndicators);
                ArrayList result = LogParser.mergeStages((ArrayList)startsStages, (ArrayList)endStages);
                this.writeLines(response, result, "Current Stages...");
                break;
            }
            case "logfile": {
                String fileName;
                List<String> names = parsedHttpRequest.getQueryMap().get("filename");
                if (names == null || names.size() == 0) {
                    response.getWriter().println(String.format("File name is not provided", new Object[0]));
                }
                if (!(fileName = names.get(0)).equals(this.driverStdoutFile) && !fileName.equals(this.driverStderrFile)) {
                    response.getWriter().println(String.format("Unsupported file names: [%s] ", fileName));
                }
                try {
                    byte[] outputBody = HttpServerReefEventHandler.readFile(names.get(0)).getBytes(Charset.forName("UTF-8"));
                    response.getOutputStream().write(outputBody);
                }
                catch (IOException e) {
                    response.getWriter().println(String.format("Cannot find the log file: [%s].", fileName));
                }
                break;
            }
            default: {
                response.getWriter().println(String.format("Unsupported query for entity: [%s].", target));
            }
        }
    }

    private void handleQueries(HttpServletResponse response, Map<String, List<String>> queries, String version) throws IOException {
        LOG.log(Level.INFO, "HttpServerReefEventHandler handleQueries is called");
        block6: for (Map.Entry<String, List<String>> entry : queries.entrySet()) {
            String queryTarget;
            switch (queryTarget = entry.getKey().toLowerCase()) {
                case "id": {
                    if (version.equals(ver)) {
                        this.writeEvaluatorInfoJsonOutput(response, entry.getValue());
                        continue block6;
                    }
                    this.writeEvaluatorInfoWebOutput(response, entry.getValue());
                    continue block6;
                }
            }
            response.getWriter().println("Unsupported query : " + queryTarget);
        }
    }

    private void writeEvaluatorInfoJsonOutput(HttpServletResponse response, List<String> ids) throws IOException {
        try {
            EvaluatorInfoSerializer serializer = (EvaluatorInfoSerializer)Tang.Factory.getTang().newInjector().getInstance(EvaluatorInfoSerializer.class);
            AvroEvaluatorsInfo evaluatorsInfo = serializer.toAvro(ids, this.reefStateManager.getEvaluators());
            this.writeResponse(response, serializer.toString(evaluatorsInfo));
        }
        catch (InjectionException e) {
            LOG.log(Level.SEVERE, "Error in injecting EvaluatorInfoSerializer.", e);
            this.writeResponse(response, "Error in injecting EvaluatorInfoSerializer: " + (Object)((Object)e));
        }
    }

    private void writeEvaluatorInfoWebOutput(HttpServletResponse response, List<String> ids) throws IOException {
        for (String id : ids) {
            EvaluatorDescriptor evaluatorDescriptor = this.reefStateManager.getEvaluators().get(id);
            PrintWriter writer = response.getWriter();
            if (evaluatorDescriptor != null) {
                String nodeId = evaluatorDescriptor.getNodeDescriptor().getId();
                String nodeName = evaluatorDescriptor.getNodeDescriptor().getName();
                InetSocketAddress address = evaluatorDescriptor.getNodeDescriptor().getInetSocketAddress();
                writer.println("Evaluator Id: " + id);
                writer.write("<br/>");
                writer.println("Evaluator Node Id: " + nodeId);
                writer.write("<br/>");
                writer.println("Evaluator Node Name: " + nodeName);
                writer.write("<br/>");
                writer.println("Evaluator InternetAddress: " + address);
                writer.write("<br/>");
                writer.println("Evaluator Memory: " + evaluatorDescriptor.getMemory());
                writer.write("<br/>");
                writer.println("Evaluator Core: " + evaluatorDescriptor.getNumberOfCores());
                writer.write("<br/>");
                writer.println("Evaluator Type: " + evaluatorDescriptor.getType());
                writer.write("<br/>");
                continue;
            }
            writer.println("Incorrect Evaluator Id: " + id);
        }
    }

    private void writeEvaluatorsJsonOutput(HttpServletResponse response) throws IOException {
        LOG.log(Level.INFO, "HttpServerReefEventHandler getEvaluators is called");
        try {
            EvaluatorListSerializer serializer = (EvaluatorListSerializer)Tang.Factory.getTang().newInjector().getInstance(EvaluatorListSerializer.class);
            AvroEvaluatorList evaluatorList = serializer.toAvro(this.reefStateManager.getEvaluators(), this.reefStateManager.getEvaluators().size(), this.reefStateManager.getStartTime());
            this.writeResponse(response, serializer.toString(evaluatorList));
        }
        catch (InjectionException e) {
            LOG.log(Level.SEVERE, "Error in injecting EvaluatorListSerializer.", e);
            this.writeResponse(response, "Error in injecting EvaluatorListSerializer: " + (Object)((Object)e));
        }
    }

    private void writeEvaluatorsWebOutput(HttpServletResponse response) throws IOException {
        LOG.log(Level.INFO, "HttpServerReefEventHandler getEvaluators is called");
        PrintWriter writer = response.getWriter();
        writer.println("<h1>Evaluators:</h1>");
        for (Map.Entry<String, EvaluatorDescriptor> entry : this.reefStateManager.getEvaluators().entrySet()) {
            String key = entry.getKey();
            EvaluatorDescriptor descriptor = entry.getValue();
            writer.println("Evaluator Id: " + key);
            writer.write("<br/>");
            writer.println("Evaluator Name: " + descriptor.getNodeDescriptor().getName());
            writer.write("<br/>");
        }
        writer.write("<br/>");
        writer.println("Total number of Evaluators: " + this.reefStateManager.getEvaluators().size());
        writer.write("<br/>");
        writer.println(String.format("Driver Start Time:[%s]", this.reefStateManager.getStartTime()));
    }

    private void writeDriverJsonInformation(HttpServletResponse response) throws IOException {
        try {
            DriverInfoSerializer serializer = (DriverInfoSerializer)Tang.Factory.getTang().newInjector().getInstance(DriverInfoSerializer.class);
            AvroDriverInfo driverInfo = serializer.toAvro(this.reefStateManager.getDriverEndpointIdentifier(), this.reefStateManager.getStartTime(), this.reefStateManager.getServicesInfo());
            this.writeResponse(response, serializer.toString(driverInfo));
        }
        catch (InjectionException e) {
            LOG.log(Level.SEVERE, "Error in injecting DriverInfoSerializer.", e);
            this.writeResponse(response, "Error in injecting DriverInfoSerializer: " + (Object)((Object)e));
        }
    }

    private void writeResponse(HttpServletResponse response, String data) throws IOException {
        byte[] outputBody = data.getBytes(Charset.forName("UTF-8"));
        response.getOutputStream().write(outputBody);
    }

    private void writeDriverWebInformation(HttpServletResponse response) throws IOException {
        LOG.log(Level.INFO, "HttpServerReefEventHandler writeDriverInformation invoked.");
        PrintWriter writer = response.getWriter();
        writer.println("<h1>Driver Information:</h1>");
        writer.println(String.format("Driver Remote Identifier:[%s]", this.reefStateManager.getDriverEndpointIdentifier()));
        writer.write("<br/><br/>");
        writer.println(String.format("Services registered on Driver:", new Object[0]));
        writer.write("<br/><br/>");
        for (AvroReefServiceInfo service : this.reefStateManager.getServicesInfo()) {
            writer.println(String.format("Service: [%s] , Information: [%s]", service.getServiceName(), service.getServiceInfo()));
            writer.write("<br/><br/>");
        }
        writer.println(String.format("Driver Start Time:[%s]", this.reefStateManager.getStartTime()));
    }

    private void writeLines(HttpServletResponse response, ArrayList<String> lines, String header) throws IOException {
        LOG.log(Level.INFO, "HttpServerReefEventHandler writeLines is called");
        PrintWriter writer = response.getWriter();
        writer.println("<h1>" + header + "</h1>");
        for (String line : lines) {
            writer.println(line);
            writer.write("<br/>");
        }
        writer.write("<br/>");
    }
}

