/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.webserver;

import java.net.BindException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.tang.annotations.Parameter;
import org.apache.reef.util.logging.LoggingScope;
import org.apache.reef.util.logging.LoggingScopeFactory;
import org.apache.reef.webserver.HttpHandler;
import org.apache.reef.webserver.HttpServer;
import org.apache.reef.webserver.JettyHandler;
import org.apache.reef.webserver.MaxPortNumber;
import org.apache.reef.webserver.MaxRetryAttempts;
import org.apache.reef.webserver.MinPortNumber;
import org.apache.reef.webserver.PortNumber;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;

public final class HttpServerImpl
implements HttpServer {
    private static final Logger LOG = Logger.getLogger(HttpServerImpl.class.getName());
    private JettyHandler jettyHandler;
    private final Server server;
    private final int port;
    private final LoggingScopeFactory loggingScopeFactory;

    @Inject
    HttpServerImpl(JettyHandler jettyHandler, @Parameter(value=PortNumber.class) int portNumber, @Parameter(value=MaxPortNumber.class) int maxPortNumber, @Parameter(value=MinPortNumber.class) int minPortNumber, @Parameter(value=MaxRetryAttempts.class) int maxRetryAttempts, LoggingScopeFactory loggingScopeFactory) throws Exception {
        block17: {
            this.loggingScopeFactory = loggingScopeFactory;
            try (LoggingScope ls = this.loggingScopeFactory.httpServer();){
                this.jettyHandler = jettyHandler;
                int port = portNumber;
                Server srv = null;
                boolean found = false;
                for (int attempt = 0; attempt < maxRetryAttempts; ++attempt) {
                    if (attempt > 0) {
                        port = this.getNextPort(maxPortNumber, minPortNumber);
                    }
                    srv = new Server(port);
                    try {
                        srv.start();
                        found = true;
                        break;
                    }
                    catch (BindException ex) {
                        LOG.log(Level.FINEST, "Cannot use port: {0}. Will try another", port);
                        continue;
                    }
                }
                if (found) {
                    this.server = srv;
                    this.port = port;
                    this.server.setHandler((Handler)jettyHandler);
                    LOG.log(Level.INFO, "Jetty Server started with port: {0}", port);
                    break block17;
                }
                throw new RuntimeException("Could not find available port in " + maxRetryAttempts + " attempts");
            }
        }
    }

    private int getNextPort(int maxPort, int minPort) {
        return minPort + (int)(Math.random() * (double)(maxPort - minPort + 1));
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() throws Exception {
        this.server.stop();
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void addHttpHandler(HttpHandler httpHandler) {
        LOG.log(Level.INFO, "addHttpHandler: {0}", httpHandler.getUriSpecification());
        this.jettyHandler.addHandler(httpHandler);
    }
}

