/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.webserver;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.wake.EventHandler;
import org.apache.reef.wake.time.runtime.event.RuntimeStop;
import org.apache.reef.webserver.HttpServer;

final class HttpRuntimeStopHandler
implements EventHandler<RuntimeStop> {
    private static final Logger LOG = Logger.getLogger(HttpRuntimeStopHandler.class.getName());
    private final HttpServer httpServer;

    @Inject
    HttpRuntimeStopHandler(HttpServer httpServer) {
        this.httpServer = httpServer;
    }

    public synchronized void onNext(RuntimeStop runtimeStop) {
        LOG.log(Level.FINEST, "HttpRuntimeStopHandler: {0}", runtimeStop);
        try {
            this.httpServer.stop();
            LOG.log(Level.FINEST, "HttpRuntimeStopHandler complete.");
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "HttpRuntimeStopHandler cannot stop the Server. {0}", e);
        }
    }
}

