/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.webserver;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.wake.EventHandler;
import org.apache.reef.wake.time.runtime.event.RuntimeStart;
import org.apache.reef.webserver.HttpServer;

final class HttpRuntimeStartHandler
implements EventHandler<RuntimeStart> {
    private static final Logger LOG = Logger.getLogger(HttpRuntimeStartHandler.class.getName());
    private final HttpServer httpServer;

    @Inject
    HttpRuntimeStartHandler(HttpServer httpServer) {
        this.httpServer = httpServer;
    }

    public synchronized void onNext(RuntimeStart runtimeStart) {
        LOG.log(Level.FINEST, "HttpRuntimeStartHandler: {0}", runtimeStart);
        try {
            this.httpServer.start();
            LOG.log(Level.FINEST, "HttpRuntimeStartHandler complete.");
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "HttpRuntimeStartHandler cannot start the Server. {0}", e);
            throw new RuntimeException("HttpRuntimeStartHandler cannot start the Server.", e);
        }
    }
}

