/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.webserver;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonEncoder;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.reef.driver.evaluator.EvaluatorDescriptor;
import org.apache.reef.webserver.AvroEvaluatorInfo;
import org.apache.reef.webserver.AvroEvaluatorsInfo;
import org.apache.reef.webserver.EvaluatorInfoSerializer;

public class AvroEvaluatorInfoSerializer
implements EvaluatorInfoSerializer {
    @Inject
    AvroEvaluatorInfoSerializer() {
    }

    @Override
    public AvroEvaluatorsInfo toAvro(List<String> ids, Map<String, EvaluatorDescriptor> evaluators) {
        ArrayList<AvroEvaluatorInfo> evaluatorsInfo = new ArrayList<AvroEvaluatorInfo>();
        for (String id : ids) {
            EvaluatorDescriptor evaluatorDescriptor = evaluators.get(id);
            String nodeId = null;
            String nodeName = null;
            InetSocketAddress address = null;
            int memory = 0;
            String type = null;
            if (evaluatorDescriptor != null) {
                nodeId = evaluatorDescriptor.getNodeDescriptor().getId();
                nodeName = evaluatorDescriptor.getNodeDescriptor().getName();
                address = evaluatorDescriptor.getNodeDescriptor().getInetSocketAddress();
                memory = evaluatorDescriptor.getMemory();
                type = evaluatorDescriptor.getType().toString();
            }
            evaluatorsInfo.add(AvroEvaluatorInfo.newBuilder().setEvaluatorId(id).setNodeId(nodeId != null ? nodeId : "").setNodeName(nodeName != null ? nodeName : "").setInternetAddress(address != null ? address.toString() : "").setMemory(memory).setType(type != null ? type : "").build());
        }
        return AvroEvaluatorsInfo.newBuilder().setEvaluatorsInfo(evaluatorsInfo).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String toString(AvroEvaluatorsInfo avroEvaluatorsInfo) {
        SpecificDatumWriter evaluatorWriter = new SpecificDatumWriter(AvroEvaluatorsInfo.class);
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            JsonEncoder encoder = EncoderFactory.get().jsonEncoder(avroEvaluatorsInfo.getSchema(), (OutputStream)out);
            evaluatorWriter.write((Object)avroEvaluatorsInfo, (Encoder)encoder);
            encoder.flush();
            String string = out.toString("ISO-8859-1");
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

