/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.integrationtests.steps;

import org.apache.rave.integrationtests.pages.Portal;
import org.apache.rave.integrationtests.steps.Step;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jbehave.core.annotations.Then;
import org.jbehave.core.annotations.When;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.springframework.beans.factory.annotation.Autowired;

@Step
public class CommonSteps {
    @Autowired
    private Portal portal;

    @When(value="I go to \"$url\"")
    public void goTo(String url) {
        this.portal.go(url);
    }

    @Then(value="I see the login page")
    public void isLoginPage() {
        WebElement title = this.portal.findElement(By.tagName((String)"title"));
        MatcherAssert.assertThat((Object)title.getText().trim(), (Matcher)CoreMatchers.equalTo((Object)"Login - Rave"));
    }

    @When(value="I log in as an administrator with username \"$username\" and password \"$password\"")
    public void loginAsAdmin(String username, String password) {
        this.portal.login(username, password);
    }

    @Then(value="I see the admin interface link")
    public void getAdminInterfaceLink() {
        WebElement adminInterfaceLink = this.portal.findElement(By.linkText((String)"Admin interface"));
    }

    @When(value="I click the admin interface link")
    public void clickAdminInterfaceLink() {
        WebElement adminInterfaceLink = this.portal.findElement(By.linkText((String)"Admin interface"));
        this.portal.clickLink(adminInterfaceLink);
    }

    @Then(value="I see the admin interface")
    public void getAdminInterface() {
        WebElement adminInterface = this.portal.findElement(By.tagName((String)"title"));
        MatcherAssert.assertThat((Object)adminInterface.getText().trim(), (Matcher)Matchers.startsWith((String)"Rave admin interface"));
    }

    @When(value="I click the \"$linkName\" link")
    public void clickLink(String linkName) {
        WebElement usersLink = this.portal.findElement(By.linkText((String)linkName));
        usersLink.click();
    }

    @When(value="I log out")
    public void iLogOut() {
        this.portal.logout();
    }

    @Then(value="I see the Rave login page")
    public void backToLoginPage() {
        WebElement title = this.portal.findElement(By.tagName((String)"title"));
        MatcherAssert.assertThat((Object)title.getText().trim(), (Matcher)CoreMatchers.equalTo((Object)"Login - Rave"));
    }
}

