/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.raftlog.segmented;

import com.codahale.metrics.Timer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.metrics.SegmentedRaftLogMetrics;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.raftlog.LogEntryHeader;
import org.apache.ratis.server.raftlog.LogProtoUtils;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.server.raftlog.RaftLogBase;
import org.apache.ratis.server.raftlog.RaftLogIOException;
import org.apache.ratis.server.raftlog.segmented.LogSegment;
import org.apache.ratis.server.raftlog.segmented.LogSegmentPath;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLog;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLogCache;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLogWorker;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.server.storage.RaftStorageMetadata;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.util.AutoCloseableLock;
import org.apache.ratis.util.JavaUtils;

public class SegmentedRaftLog
extends RaftLogBase {
    private final ServerLogMethods server;
    private final RaftStorage storage;
    private final StateMachine stateMachine;
    private final SegmentedRaftLogCache cache;
    private final SegmentedRaftLogWorker fileLogWorker;
    private final long segmentMaxSize;
    private final boolean stateMachineCachingEnabled;
    private final SegmentedRaftLogMetrics metrics;

    private ServerLogMethods newServerLogMethods(RaftServer.Division impl, Consumer<RaftProtos.LogEntryProto> notifyTruncatedLogEntry) {
        if (impl == null) {
            return ServerLogMethods.DUMMY;
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public SegmentedRaftLog(RaftGroupMemberId memberId, RaftServer.Division server, StateMachine stateMachine, Consumer<RaftProtos.LogEntryProto> notifyTruncatedLogEntry, Runnable submitUpdateCommitEvent, RaftStorage storage, LongSupplier snapshotIndexSupplier, RaftProperties properties) {
        super(memberId, snapshotIndexSupplier, properties);
        this.metrics = new SegmentedRaftLogMetrics(memberId);
        this.server = this.newServerLogMethods(server, notifyTruncatedLogEntry);
        this.storage = storage;
        this.stateMachine = stateMachine;
        this.segmentMaxSize = RaftServerConfigKeys.Log.segmentSizeMax((RaftProperties)properties).getSize();
        this.cache = new SegmentedRaftLogCache((Object)memberId, storage, properties, this.getRaftLogMetrics());
        this.fileLogWorker = new SegmentedRaftLogWorker(memberId, stateMachine, submitUpdateCommitEvent, server, storage, properties, this.getRaftLogMetrics());
        this.stateMachineCachingEnabled = RaftServerConfigKeys.Log.StateMachineData.cachingEnabled((RaftProperties)properties);
    }

    public SegmentedRaftLogMetrics getRaftLogMetrics() {
        return this.metrics;
    }

    protected void openImpl(long lastIndexInSnapshot, Consumer<RaftProtos.LogEntryProto> consumer) throws IOException {
        this.loadLogSegments(lastIndexInSnapshot, consumer);
        File openSegmentFile = Optional.ofNullable(this.cache.getOpenSegment()).map(LogSegment::getFile).orElse(null);
        this.fileLogWorker.start(Math.max(this.cache.getEndIndex(), lastIndexInSnapshot), Math.min(this.cache.getLastIndexInClosedSegments(), lastIndexInSnapshot), openSegmentFile);
    }

    public long getStartIndex() {
        return this.cache.getStartIndex();
    }

    private void loadLogSegments(long lastIndexInSnapshot, Consumer<RaftProtos.LogEntryProto> logConsumer) throws IOException {
        try (AutoCloseableLock writeLock = this.writeLock();){
            List paths = LogSegmentPath.getLogSegmentPaths((RaftStorage)this.storage);
            int i = 0;
            for (LogSegmentPath pi : paths) {
                boolean keepEntryInCache = paths.size() - i++ <= this.cache.getMaxCachedSegments();
                Timer.Context loadSegmentContext = this.getRaftLogMetrics().getRaftLogLoadSegmentTimer().time();
                this.cache.loadSegment(pi, keepEntryInCache, logConsumer);
                loadSegmentContext.stop();
            }
            if (!this.cache.isEmpty() && this.cache.getEndIndex() < lastIndexInSnapshot) {
                LOG.warn("End log index {} is smaller than last index in snapshot {}", (Object)this.cache.getEndIndex(), (Object)lastIndexInSnapshot);
                this.purgeImpl(lastIndexInSnapshot);
            }
        }
    }

    public RaftProtos.LogEntryProto get(long index) throws RaftLogIOException {
        LogSegment.LogRecord record;
        LogSegment segment;
        this.checkLogState();
        try (AutoCloseableLock readLock = this.readLock();){
            segment = this.cache.getSegment(index);
            if (segment == null) {
                RaftProtos.LogEntryProto logEntryProto = null;
                return logEntryProto;
            }
            record = segment.getLogRecord(index);
            if (record == null) {
                RaftProtos.LogEntryProto logEntryProto = null;
                return logEntryProto;
            }
            RaftProtos.LogEntryProto entry = segment.getEntryFromCache(record.getTermIndex());
            if (entry != null) {
                this.getRaftLogMetrics().onRaftLogCacheHit();
                RaftProtos.LogEntryProto logEntryProto = entry;
                return logEntryProto;
            }
        }
        this.getRaftLogMetrics().onRaftLogCacheMiss();
        this.checkAndEvictCache();
        return segment.loadCache(record);
    }

    public RaftLog.EntryWithData getEntryWithData(long index) throws RaftLogIOException {
        RaftProtos.LogEntryProto entry = this.get(index);
        if (entry == null) {
            throw new RaftLogIOException("Log entry not found: index = " + index);
        }
        if (!LogProtoUtils.isStateMachineDataEmpty((RaftProtos.LogEntryProto)entry)) {
            return this.newEntryWithData(entry, null);
        }
        try {
            CompletionStage future = null;
            if (this.stateMachine != null) {
                future = this.stateMachine.data().read(entry).exceptionally(ex -> {
                    this.stateMachine.event().notifyLogFailed(ex, entry);
                    throw new CompletionException("Failed to read state machine data for log entry " + entry, (Throwable)ex);
                });
            }
            return this.newEntryWithData(entry, future);
        }
        catch (Exception e) {
            String err = this.getName() + ": Failed readStateMachineData for " + LogProtoUtils.toLogEntryString((RaftProtos.LogEntryProto)entry);
            LOG.error(err, (Throwable)e);
            throw new RaftLogIOException(err, JavaUtils.unwrapCompletionException((Throwable)e));
        }
    }

    private void checkAndEvictCache() {
        if (this.cache.shouldEvict()) {
            this.cache.evictCache(this.server.getFollowerNextIndices(), this.fileLogWorker.getSafeCacheEvictIndex(), this.server.getLastAppliedIndex());
        }
    }

    public TermIndex getTermIndex(long index) {
        this.checkLogState();
        try (AutoCloseableLock readLock = this.readLock();){
            LogSegment.LogRecord record = this.cache.getLogRecord(index);
            TermIndex termIndex = record != null ? record.getTermIndex() : null;
            return termIndex;
        }
    }

    public LogEntryHeader[] getEntries(long startIndex, long endIndex) {
        this.checkLogState();
        try (AutoCloseableLock readLock = this.readLock();){
            LogEntryHeader[] logEntryHeaderArray = this.cache.getTermIndices(startIndex, endIndex);
            return logEntryHeaderArray;
        }
    }

    public TermIndex getLastEntryTermIndex() {
        this.checkLogState();
        try (AutoCloseableLock readLock = this.readLock();){
            TermIndex termIndex = this.cache.getLastTermIndex();
            return termIndex;
        }
    }

    protected CompletableFuture<Long> truncateImpl(long index) {
        this.checkLogState();
        try (AutoCloseableLock writeLock = this.writeLock();){
            SegmentedRaftLogCache.TruncationSegments ts = this.cache.truncate(index);
            if (ts != null) {
                Task task = this.fileLogWorker.truncate(ts, index);
                CompletableFuture completableFuture = task.getFuture();
                return completableFuture;
            }
        }
        return CompletableFuture.completedFuture(index);
    }

    protected CompletableFuture<Long> purgeImpl(long index) {
        try (AutoCloseableLock writeLock = this.writeLock();){
            SegmentedRaftLogCache.TruncationSegments ts = this.cache.purge(index);
            this.updateSnapshotIndexFromStateMachine();
            LOG.debug("purging segments:{}", (Object)ts);
            if (ts != null) {
                Task task = this.fileLogWorker.purge(ts);
                CompletableFuture completableFuture = task.getFuture();
                return completableFuture;
            }
        }
        return CompletableFuture.completedFuture(index);
    }

    /*
     * Exception decompiling
     */
    protected CompletableFuture<Long> appendEntryImpl(RaftProtos.LogEntryProto entry) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isSegmentFull(LogSegment segment, RaftProtos.LogEntryProto entry) {
        if (segment.getTotalFileSize() >= this.segmentMaxSize) {
            return true;
        }
        long entrySize = LogSegment.getEntrySize((RaftProtos.LogEntryProto)entry, (LogSegment.Op)LogSegment.Op.CHECK_SEGMENT_FILE_FULL);
        return entrySize <= this.segmentMaxSize && segment.getTotalFileSize() + entrySize > this.segmentMaxSize;
    }

    public List<CompletableFuture<Long>> appendImpl(List<RaftProtos.LogEntryProto> entries) {
        this.checkLogState();
        if (entries == null || entries.isEmpty()) {
            return Collections.emptyList();
        }
        try (AutoCloseableLock writeLock = this.writeLock();){
            ArrayList<CompletableFuture<Long>> futures;
            SegmentedRaftLogCache.TruncateIndices ti = this.cache.computeTruncateIndices(arg_0 -> ((ServerLogMethods)this.server).notifyTruncatedLogEntry(arg_0), entries);
            long truncateIndex = ti.getTruncateIndex();
            int index = ti.getArrayIndex();
            LOG.debug("truncateIndex={}, arrayIndex={}", (Object)truncateIndex, (Object)index);
            if (truncateIndex != -1L) {
                futures = new ArrayList(entries.size() - index + 1);
                futures.add(this.truncate(truncateIndex));
            } else {
                futures = new ArrayList<CompletableFuture<Long>>(entries.size() - index);
            }
            for (int i = index; i < entries.size(); ++i) {
                futures.add(this.appendEntry(entries.get(i)));
            }
            ArrayList<CompletableFuture<Long>> arrayList = futures;
            return arrayList;
        }
    }

    public long getFlushIndex() {
        return this.fileLogWorker.getFlushIndex();
    }

    public void persistMetadata(RaftStorageMetadata metadata) throws IOException {
        this.storage.getMetadataFile().persist(metadata);
    }

    public RaftStorageMetadata loadMetadata() throws IOException {
        return this.storage.getMetadataFile().getMetadata();
    }

    public CompletableFuture<Long> onSnapshotInstalled(long lastSnapshotIndex) {
        this.fileLogWorker.syncWithSnapshot(lastSnapshotIndex);
        LogSegment openSegment = this.cache.getOpenSegment();
        if (openSegment != null && openSegment.hasEntries()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("syncWithSnapshot : Found open segment {}, with end index {}, snapshotIndex {}", new Object[]{openSegment, openSegment.getEndIndex(), lastSnapshotIndex});
            }
            if (openSegment.getEndIndex() <= lastSnapshotIndex) {
                this.fileLogWorker.closeLogSegment(openSegment);
                this.cache.rollOpenSegment(false);
            }
        }
        return this.purgeImpl(lastSnapshotIndex);
    }

    public void close() throws IOException {
        try (AutoCloseableLock writeLock = this.writeLock();){
            super.close();
            this.cache.close();
        }
        this.fileLogWorker.close();
        this.storage.close();
        this.getRaftLogMetrics().unregister();
    }

    SegmentedRaftLogCache getRaftLogCache() {
        return this.cache;
    }

    public String toLogEntryString(RaftProtos.LogEntryProto logEntry) {
        return LogProtoUtils.toLogEntryString((RaftProtos.LogEntryProto)logEntry, arg_0 -> ((StateMachine)this.stateMachine).toStateMachineLogEntryString(arg_0));
    }
}

