/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.concurrent.CompletableFuture;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.ClientInvocationId;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.exceptions.StreamException;
import org.apache.ratis.server.impl.MessageStreamRequests;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MessageStreamRequests {
    public static final Logger LOG = LoggerFactory.getLogger(MessageStreamRequests.class);
    private final String name;
    private final StreamMap streams = new StreamMap();

    MessageStreamRequests(Object name) {
        this.name = name + "-" + JavaUtils.getClassSimpleName(this.getClass());
    }

    CompletableFuture<?> streamAsync(RaftClientRequest request) {
        RaftProtos.MessageStreamRequestTypeProto stream = request.getType().getMessageStream();
        Preconditions.assertTrue((!stream.getEndOfRequest() ? 1 : 0) != 0);
        ClientInvocationId key = ClientInvocationId.valueOf((ClientId)request.getClientId(), (long)stream.getStreamId());
        PendingStream pending = this.streams.computeIfAbsent(key);
        return pending.append(stream.getMessageId(), request.getMessage());
    }

    CompletableFuture<ByteString> streamEndOfRequestAsync(RaftClientRequest request) {
        RaftProtos.MessageStreamRequestTypeProto stream = request.getType().getMessageStream();
        Preconditions.assertTrue((boolean)stream.getEndOfRequest());
        ClientInvocationId key = ClientInvocationId.valueOf((ClientId)request.getClientId(), (long)stream.getStreamId());
        PendingStream pending = this.streams.remove(key);
        if (pending == null) {
            return JavaUtils.completeExceptionally((Throwable)new StreamException(this.name + ": " + key + " not found"));
        }
        return pending.getBytes(stream.getMessageId(), request.getMessage());
    }

    void clear() {
        this.streams.clear();
    }
}

