/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.netty;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.apache.ratis.conf.ConfUtils;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.security.TlsConf;
import org.apache.ratis.thirdparty.io.netty.util.NettyRuntime;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface NettyConfigKeys {
    public static final String PREFIX = "raft.netty";

    public static void main(String[] args) {
        ConfUtils.printAll(NettyConfigKeys.class);
    }

    public static interface DataStream {
        public static final Logger LOG = LoggerFactory.getLogger(DataStream.class);
        public static final String PREFIX = "raft.netty.dataStream";
        public static final String PORT_KEY = "raft.netty.dataStream.port";
        public static final int PORT_DEFAULT = 0;

        public static Consumer<String> getDefaultLog() {
            return arg_0 -> ((Logger)LOG).info(arg_0);
        }

        public static int port(RaftProperties properties) {
            return ConfUtils.getInt((arg_0, arg_1) -> ((RaftProperties)properties).getInt(arg_0, arg_1), (String)PORT_KEY, (int)0, DataStream.getDefaultLog(), (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((int)0), ConfUtils.requireMax((int)65536)});
        }

        public static void setPort(RaftProperties properties, int port) {
            ConfUtils.setInt((arg_0, arg_1) -> ((RaftProperties)properties).setInt(arg_0, arg_1), (String)PORT_KEY, (int)port, (BiConsumer[])new BiConsumer[0]);
        }

        public static interface Server {
            public static final String PREFIX = "raft.netty.dataStream.server";
            public static final String TLS_CONF_PARAMETER = "raft.netty.dataStream.server.tls.conf";
            public static final Class<TlsConf> TLS_CONF_CLASS = TlsConf.class;
            public static final String USE_EPOLL_KEY = "raft.netty.dataStream.server.use-epoll";
            public static final boolean USE_EPOLL_DEFAULT = false;
            public static final String BOSS_GROUP_SIZE_KEY = "raft.netty.dataStream.server.boss-group.size";
            public static final int BOSS_GROUP_SIZE_DEFAULT = 0;
            public static final String WORKER_GROUP_SIZE_KEY = "raft.netty.dataStream.server.worker-group.size";
            public static final int WORKER_GROUP_SIZE_DEFAULT = 0;

            public static TlsConf tlsConf(Parameters parameters) {
                return ConfUtils.getTlsConf(key -> (TlsConf)parameters.get(key, TLS_CONF_CLASS), (String)TLS_CONF_PARAMETER, DataStream.getDefaultLog());
            }

            public static void setTlsConf(Parameters parameters, TlsConf conf) {
                LOG.info("setTlsConf " + conf);
                ConfUtils.setTlsConf((key, value) -> {
                    TlsConf cfr_ignored_0 = (TlsConf)parameters.put(key, value, TLS_CONF_CLASS);
                }, (String)TLS_CONF_PARAMETER, (TlsConf)conf);
            }

            public static boolean useEpoll(RaftProperties properties) {
                return ConfUtils.getBoolean((arg_0, arg_1) -> ((RaftProperties)properties).getBoolean(arg_0, arg_1), (String)USE_EPOLL_KEY, (boolean)false, DataStream.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
            }

            public static void setUseEpoll(RaftProperties properties, boolean enable) {
                ConfUtils.setBoolean((arg_0, arg_1) -> ((RaftProperties)properties).setBoolean(arg_0, arg_1), (String)USE_EPOLL_KEY, (boolean)enable, (BiConsumer[])new BiConsumer[0]);
            }

            public static int bossGroupSize(RaftProperties properties) {
                return ConfUtils.getInt((arg_0, arg_1) -> ((RaftProperties)properties).getInt(arg_0, arg_1), (String)BOSS_GROUP_SIZE_KEY, (int)0, DataStream.getDefaultLog(), (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((int)0), ConfUtils.requireMax((int)65536)});
            }

            public static void setBossGroupSize(RaftProperties properties, int num) {
                ConfUtils.setInt((arg_0, arg_1) -> ((RaftProperties)properties).setInt(arg_0, arg_1), (String)BOSS_GROUP_SIZE_KEY, (int)num, (BiConsumer[])new BiConsumer[0]);
            }

            public static int workerGroupSize(RaftProperties properties) {
                return ConfUtils.getInt((arg_0, arg_1) -> ((RaftProperties)properties).getInt(arg_0, arg_1), (String)WORKER_GROUP_SIZE_KEY, (int)0, DataStream.getDefaultLog(), (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((int)0), ConfUtils.requireMax((int)65536)});
            }

            public static void setWorkerGroupSize(RaftProperties properties, int num) {
                ConfUtils.setInt((arg_0, arg_1) -> ((RaftProperties)properties).setInt(arg_0, arg_1), (String)WORKER_GROUP_SIZE_KEY, (int)num, (BiConsumer[])new BiConsumer[0]);
            }
        }

        public static interface Client {
            public static final String PREFIX = "raft.netty.dataStream.client";
            public static final String TLS_CONF_PARAMETER = "raft.netty.dataStream.client.tls.conf";
            public static final Class<TlsConf> TLS_CONF_CLASS = TlsConf.class;
            public static final String WORKER_GROUP_SIZE_KEY = "raft.netty.dataStream.client.worker-group.size";
            public static final int WORKER_GROUP_SIZE_DEFAULT = Math.max(1, NettyRuntime.availableProcessors() * 2);
            public static final String WORKER_GROUP_SHARE_KEY = "raft.netty.dataStream.client.worker-group.share";
            public static final boolean WORKER_GROUP_SHARE_DEFAULT = false;
            public static final String REPLY_QUEUE_GRACE_PERIOD_KEY = "raft.netty.dataStream.client.reply.queue.grace-period";
            public static final TimeDuration REPLY_QUEUE_GRACE_PERIOD_DEFAULT = TimeDuration.ONE_SECOND;

            public static TlsConf tlsConf(Parameters parameters) {
                return ConfUtils.getTlsConf(key -> (TlsConf)parameters.get(key, TLS_CONF_CLASS), (String)TLS_CONF_PARAMETER, DataStream.getDefaultLog());
            }

            public static void setTlsConf(Parameters parameters, TlsConf conf) {
                LOG.info("setTlsConf " + conf);
                ConfUtils.setTlsConf((key, value) -> {
                    TlsConf cfr_ignored_0 = (TlsConf)parameters.put(key, value, TLS_CONF_CLASS);
                }, (String)TLS_CONF_PARAMETER, (TlsConf)conf);
            }

            public static int workerGroupSize(RaftProperties properties) {
                return ConfUtils.getInt((arg_0, arg_1) -> ((RaftProperties)properties).getInt(arg_0, arg_1), (String)WORKER_GROUP_SIZE_KEY, (int)WORKER_GROUP_SIZE_DEFAULT, DataStream.getDefaultLog(), (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((int)1), ConfUtils.requireMax((int)65536)});
            }

            public static void setWorkerGroupSize(RaftProperties properties, int clientWorkerGroupSize) {
                ConfUtils.setInt((arg_0, arg_1) -> ((RaftProperties)properties).setInt(arg_0, arg_1), (String)WORKER_GROUP_SIZE_KEY, (int)clientWorkerGroupSize, (BiConsumer[])new BiConsumer[0]);
            }

            public static boolean workerGroupShare(RaftProperties properties) {
                return ConfUtils.getBoolean((arg_0, arg_1) -> ((RaftProperties)properties).getBoolean(arg_0, arg_1), (String)WORKER_GROUP_SHARE_KEY, (boolean)false, DataStream.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
            }

            public static void setWorkerGroupShare(RaftProperties properties, boolean clientWorkerGroupShare) {
                ConfUtils.setBoolean((arg_0, arg_1) -> ((RaftProperties)properties).setBoolean(arg_0, arg_1), (String)WORKER_GROUP_SHARE_KEY, (boolean)clientWorkerGroupShare, (BiConsumer[])new BiConsumer[0]);
            }

            public static TimeDuration replyQueueGracePeriod(RaftProperties properties) {
                return ConfUtils.getTimeDuration((BiFunction)properties.getTimeDuration(REPLY_QUEUE_GRACE_PERIOD_DEFAULT.getUnit()), (String)REPLY_QUEUE_GRACE_PERIOD_KEY, (TimeDuration)REPLY_QUEUE_GRACE_PERIOD_DEFAULT, DataStream.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
            }

            public static void setReplyQueueGracePeriod(RaftProperties properties, TimeDuration timeoutDuration) {
                ConfUtils.setTimeDuration((arg_0, arg_1) -> ((RaftProperties)properties).setTimeDuration(arg_0, arg_1), (String)REPLY_QUEUE_GRACE_PERIOD_KEY, (TimeDuration)timeoutDuration, (BiConsumer[])new BiConsumer[0]);
            }
        }
    }

    public static interface Server {
        public static final Logger LOG = LoggerFactory.getLogger(Server.class);
        public static final String PREFIX = "raft.netty.server";
        public static final String PORT_KEY = "raft.netty.server.port";
        public static final int PORT_DEFAULT = 0;

        public static Consumer<String> getDefaultLog() {
            return arg_0 -> ((Logger)LOG).info(arg_0);
        }

        public static int port(RaftProperties properties) {
            return ConfUtils.getInt((arg_0, arg_1) -> ((RaftProperties)properties).getInt(arg_0, arg_1), (String)PORT_KEY, (int)0, Server.getDefaultLog(), (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((int)0), ConfUtils.requireMax((int)65536)});
        }

        public static void setPort(RaftProperties properties, int port) {
            ConfUtils.setInt((arg_0, arg_1) -> ((RaftProperties)properties).setInt(arg_0, arg_1), (String)PORT_KEY, (int)port, (BiConsumer[])new BiConsumer[0]);
        }
    }
}

