/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc.metrics;

import org.apache.ratis.metrics.MetricRegistryInfo;
import org.apache.ratis.metrics.RatisMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageMetrics
extends RatisMetrics {
    static final Logger LOG = LoggerFactory.getLogger(MessageMetrics.class);
    public static final String GRPC_MESSAGE_METRICS = "%s_message_metrics";
    public static final String GRPC_MESSAGE_METRICS_DESC = "Outbound/Inbound message counters";

    public MessageMetrics(String endpointId, String endpointType) {
        this.registry = MessageMetrics.create((MetricRegistryInfo)new MetricRegistryInfo(endpointId, "ratis", String.format(GRPC_MESSAGE_METRICS, endpointType), GRPC_MESSAGE_METRICS_DESC));
    }

    public void rpcStarted(String rpcType) {
        this.registry.counter(rpcType + "_started_total").inc();
    }

    public void rpcCompleted(String rpcType) {
        this.registry.counter(rpcType + "_completed_total").inc();
    }

    public void rpcReceived(String rpcType) {
        this.registry.counter(rpcType + "_received_executed").inc();
    }
}

