/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.LogUtils;
import org.apache.ratis.util.function.CheckedSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskQueue {
    public static final Logger LOG = LoggerFactory.getLogger(TaskQueue.class);
    private final String name;
    private final Queue<Runnable> q = new LinkedList<Runnable>();

    public TaskQueue(String name) {
        this.name = name;
    }

    private synchronized Runnable pollAndSubmit(ExecutorService executor) {
        Runnable head = this.q.poll();
        Runnable next = this.q.peek();
        if (next != null) {
            executor.submit(next);
        }
        return head;
    }

    private synchronized void offerAndSubmit(Runnable task, ExecutorService executor) {
        this.q.offer(task);
        if (this.q.size() == 1) {
            executor.submit(task);
        }
    }

    public <OUTPUT, THROWABLE extends Throwable> CompletableFuture<OUTPUT> submit(CheckedSupplier<OUTPUT, THROWABLE> task, ExecutorService executor) {
        return this.submit(task, executor, Function.identity());
    }

    public <OUTPUT, THROWABLE extends Throwable> CompletableFuture<OUTPUT> submit(CheckedSupplier<OUTPUT, THROWABLE> task, ExecutorService executor, Function<Throwable, Throwable> newThrowable) {
        CompletableFuture f = new CompletableFuture();
        Runnable runnable = LogUtils.newRunnable(LOG, () -> {
            LOG.trace("{}: running {}", (Object)this, (Object)task);
            try {
                f.complete(task.get());
            }
            catch (Throwable t) {
                f.completeExceptionally((Throwable)newThrowable.apply(t));
            }
            this.pollAndSubmit(executor);
        }, task::toString);
        this.offerAndSubmit(runnable, executor);
        return f;
    }

    public String toString() {
        return this.name + "-" + JavaUtils.getClassSimpleName(this.getClass());
    }
}

