/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.client.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ratis.client.DataStreamClient;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.client.RaftClientRpc;
import org.apache.ratis.client.api.DataStreamApi;
import org.apache.ratis.client.impl.AdminImpl;
import org.apache.ratis.client.impl.AsyncImpl;
import org.apache.ratis.client.impl.BlockingImpl;
import org.apache.ratis.client.impl.GroupManagementImpl;
import org.apache.ratis.client.impl.MessageStreamImpl;
import org.apache.ratis.client.impl.OrderedAsync;
import org.apache.ratis.client.retry.ClientRetryEvent;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.exceptions.LeaderNotReadyException;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.apache.ratis.protocol.exceptions.RaftException;
import org.apache.ratis.protocol.exceptions.RaftRetryFailureException;
import org.apache.ratis.protocol.exceptions.ResourceUnavailableException;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.util.CollectionUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.MemoizedSupplier;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.TimeoutScheduler;

public final class RaftClientImpl
implements RaftClient {
    private final ClientId clientId;
    private final RaftClientRpc clientRpc;
    private final RaftPeerList peers = new RaftPeerList();
    private final RaftGroupId groupId;
    private final RetryPolicy retryPolicy;
    private volatile RaftPeerId leaderId;
    private final TimeoutScheduler scheduler = TimeoutScheduler.getInstance();
    private final Supplier<OrderedAsync> orderedAsync;
    private final Supplier<AsyncImpl> asyncApi;
    private final Supplier<BlockingImpl> blockingApi;
    private final Supplier<MessageStreamImpl> messageStreamApi;
    private final MemoizedSupplier<DataStreamApi> dataStreamApi;
    private final Supplier<AdminImpl> adminApi;
    private final ConcurrentMap<RaftPeerId, GroupManagementImpl> groupManagmenets = new ConcurrentHashMap<RaftPeerId, GroupManagementImpl>();

    RaftClientImpl(ClientId clientId, RaftGroup group, RaftPeerId leaderId, RaftPeer primaryDataStreamServer, RaftClientRpc clientRpc, RaftProperties properties, RetryPolicy retryPolicy) {
        this.clientId = clientId;
        this.peers.set(group.getPeers());
        this.groupId = group.getGroupId();
        this.leaderId = leaderId != null ? leaderId : this.getHighestPriorityPeerId();
        this.retryPolicy = Objects.requireNonNull(retryPolicy, "retry policy can't be null");
        clientRpc.addRaftPeers(group.getPeers());
        this.clientRpc = clientRpc;
        this.orderedAsync = JavaUtils.memoize(() -> OrderedAsync.newInstance(this, properties));
        this.messageStreamApi = JavaUtils.memoize(() -> MessageStreamImpl.newInstance(this, properties));
        this.asyncApi = JavaUtils.memoize(() -> new AsyncImpl(this));
        this.blockingApi = JavaUtils.memoize(() -> new BlockingImpl(this));
        this.dataStreamApi = JavaUtils.memoize(() -> DataStreamClient.newBuilder().setClientId(clientId).setRaftGroupId(this.groupId).setDataStreamServer(primaryDataStreamServer).setProperties(properties).build());
        this.adminApi = JavaUtils.memoize(() -> new AdminImpl(this));
    }

    @Override
    public RaftPeerId getLeaderId() {
        return this.leaderId;
    }

    RaftGroupId getGroupId() {
        return this.groupId;
    }

    private RaftPeerId getHighestPriorityPeerId() {
        int maxPriority = Integer.MIN_VALUE;
        RaftPeerId highestPriorityPeerId = null;
        for (RaftPeer peer : this.peers) {
            if (maxPriority >= peer.getPriority()) continue;
            maxPriority = peer.getPriority();
            highestPriorityPeerId = peer.getId();
        }
        return highestPriorityPeerId;
    }

    @Override
    public ClientId getId() {
        return this.clientId;
    }

    RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    TimeDuration getEffectiveSleepTime(Throwable t, TimeDuration sleepDefault) {
        return t instanceof NotLeaderException && ((NotLeaderException)t).getSuggestedLeader() != null ? TimeDuration.ZERO : sleepDefault;
    }

    TimeoutScheduler getScheduler() {
        return this.scheduler;
    }

    OrderedAsync getOrderedAsync() {
        return this.orderedAsync.get();
    }

    RaftClientRequest newRaftClientRequest(RaftPeerId server, long callId, Message message, RaftClientRequest.Type type, RaftProtos.SlidingWindowEntry slidingWindowEntry) {
        return RaftClientRequest.newBuilder().setClientId(this.clientId).setServerId(server != null ? server : this.leaderId).setGroupId(this.groupId).setCallId(callId).setMessage(message).setType(type).setSlidingWindowEntry(slidingWindowEntry).build();
    }

    @Override
    public AdminImpl admin() {
        return this.adminApi.get();
    }

    @Override
    public GroupManagementImpl getGroupManagementApi(RaftPeerId server) {
        return this.groupManagmenets.computeIfAbsent(server, id -> new GroupManagementImpl((RaftPeerId)id, this));
    }

    @Override
    public BlockingImpl io() {
        return this.blockingApi.get();
    }

    @Override
    public AsyncImpl async() {
        return this.asyncApi.get();
    }

    @Override
    public MessageStreamImpl getMessageStreamApi() {
        return this.messageStreamApi.get();
    }

    @Override
    public DataStreamApi getDataStreamApi() {
        return (DataStreamApi)this.dataStreamApi.get();
    }

    Throwable noMoreRetries(ClientRetryEvent event) {
        int attemptCount = event.getAttemptCount();
        Throwable throwable = event.getCause();
        if (attemptCount == 1 && throwable != null) {
            return throwable;
        }
        return new RaftRetryFailureException(event.getRequest(), attemptCount, this.retryPolicy, throwable);
    }

    static <E extends Throwable> RaftClientReply handleRaftException(RaftClientReply reply, Function<RaftException, E> converter) throws E {
        RaftException e;
        if (reply != null && (e = reply.getException()) != null) {
            throw (Throwable)converter.apply(e);
        }
        return reply;
    }

    RaftClientReply handleLeaderException(RaftClientRequest request, RaftClientReply reply) {
        if (reply == null || reply.getException() instanceof LeaderNotReadyException) {
            return null;
        }
        NotLeaderException nle = reply.getNotLeaderException();
        if (nle == null) {
            return reply;
        }
        return this.handleNotLeaderException(request, nle, null);
    }

    RaftClientReply handleNotLeaderException(RaftClientRequest request, NotLeaderException nle, Consumer<RaftClientRequest> handler) {
        this.refreshPeers(nle.getPeers());
        RaftPeerId newLeader = nle.getSuggestedLeader() == null ? null : nle.getSuggestedLeader().getId();
        this.handleIOException(request, (IOException)nle, newLeader, handler);
        return null;
    }

    private void refreshPeers(Collection<RaftPeer> newPeers) {
        if (newPeers != null && newPeers.size() > 0) {
            this.peers.set(newPeers);
            this.clientRpc.addRaftPeers(newPeers);
        }
    }

    void handleIOException(RaftClientRequest request, IOException ioe) {
        this.handleIOException(request, ioe, null, null);
    }

    void handleIOException(RaftClientRequest request, IOException ioe, RaftPeerId newLeader, Consumer<RaftClientRequest> handler) {
        boolean reconnect;
        LOG.debug("{}: suggested new leader: {}. Failed {} with {}", new Object[]{this.clientId, newLeader, request, ioe});
        if (LOG.isTraceEnabled()) {
            LOG.trace("Stack trace", new Throwable("TRACE"));
        }
        Optional.ofNullable(handler).ifPresent(h -> h.accept(request));
        if (ioe instanceof LeaderNotReadyException || ioe instanceof ResourceUnavailableException) {
            return;
        }
        RaftPeerId oldLeader = request.getServerId();
        RaftPeerId curLeader = this.leaderId;
        boolean stillLeader = oldLeader.equals((Object)curLeader);
        if (newLeader == null && stillLeader) {
            newLeader = (RaftPeerId)CollectionUtils.random((Object)oldLeader, (Iterable)CollectionUtils.as((Iterable)this.peers, RaftPeer::getId));
        }
        LOG.debug("{}: oldLeader={},  curLeader={}, newLeader={}", new Object[]{this.clientId, oldLeader, curLeader, newLeader});
        boolean changeLeader = newLeader != null && stillLeader;
        boolean bl = reconnect = changeLeader || this.clientRpc.shouldReconnect(ioe);
        if (reconnect) {
            if (changeLeader && oldLeader.equals((Object)this.leaderId)) {
                LOG.debug("{} {}: client change Leader from {} to {} ex={}", new Object[]{this.groupId, this.clientId, oldLeader, newLeader, ioe.getClass().getName()});
                this.leaderId = newLeader;
            }
            this.clientRpc.handleException(oldLeader, ioe, true);
        }
    }

    @Override
    public RaftClientRpc getClientRpc() {
        return this.clientRpc;
    }

    @Override
    public void close() throws IOException {
        this.scheduler.close();
        this.clientRpc.close();
        if (this.dataStreamApi.isInitialized()) {
            ((DataStreamApi)this.dataStreamApi.get()).close();
        }
    }

    static class RaftPeerList
    implements Iterable<RaftPeer> {
        private final AtomicReference<List<RaftPeer>> list = new AtomicReference();

        RaftPeerList() {
        }

        @Override
        public Iterator<RaftPeer> iterator() {
            return this.list.get().iterator();
        }

        void set(Collection<RaftPeer> newPeers) {
            this.list.set(Collections.unmodifiableList(new ArrayList<RaftPeer>(newPeers)));
        }
    }

    public static abstract class PendingClientRequest {
        private final long creationTimeInMs = System.currentTimeMillis();
        private final CompletableFuture<RaftClientReply> replyFuture = new CompletableFuture();
        private final AtomicInteger attemptCount = new AtomicInteger();
        private final Map<Class<?>, Integer> exceptionCount = new ConcurrentHashMap();

        public abstract RaftClientRequest newRequestImpl();

        final RaftClientRequest newRequest() {
            this.attemptCount.incrementAndGet();
            return this.newRequestImpl();
        }

        CompletableFuture<RaftClientReply> getReplyFuture() {
            return this.replyFuture;
        }

        public int getAttemptCount() {
            return this.attemptCount.get();
        }

        int incrementExceptionCount(Throwable t) {
            return t != null ? this.exceptionCount.compute(t.getClass(), (k, v) -> v != null ? v + 1 : 1) : 0;
        }

        public int getExceptionCount(Throwable t) {
            return t != null ? Optional.ofNullable(this.exceptionCount.get(t.getClass())).orElse(0) : 0;
        }

        public boolean isRequestTimeout(TimeDuration timeout) {
            if (timeout == null) {
                return false;
            }
            return System.currentTimeMillis() - this.creationTimeInMs > timeout.toLong(TimeUnit.MILLISECONDS);
        }
    }
}

