/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.client;

import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.apache.ratis.conf.ConfUtils;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface RaftClientConfigKeys {
    public static final Logger LOG = LoggerFactory.getLogger(RaftClientConfigKeys.class);
    public static final String PREFIX = "raft.client";

    public static Consumer<String> getDefaultLog() {
        return arg_0 -> ((Logger)LOG).debug(arg_0);
    }

    public static void main(String[] args) {
        ConfUtils.printAll(RaftClientConfigKeys.class);
    }

    public static interface MessageStream {
        public static final String PREFIX = "raft.client.message-stream";
        public static final String SUBMESSAGE_SIZE_KEY = "raft.client.message-stream.submessage-size";
        public static final SizeInBytes SUBMESSAGE_SIZE_DEFAULT = SizeInBytes.valueOf((String)"1MB");

        public static SizeInBytes submessageSize(RaftProperties properties) {
            return ConfUtils.getSizeInBytes((arg_0, arg_1) -> ((RaftProperties)properties).getSizeInBytes(arg_0, arg_1), (String)SUBMESSAGE_SIZE_KEY, (SizeInBytes)SUBMESSAGE_SIZE_DEFAULT, RaftClientConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
        }

        public static void setSubmessageSize(RaftProperties properties, SizeInBytes submessageSize) {
            ConfUtils.setSizeInBytes((arg_0, arg_1) -> ((RaftProperties)properties).set(arg_0, arg_1), (String)SUBMESSAGE_SIZE_KEY, (SizeInBytes)submessageSize, (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((SizeInBytes)SizeInBytes.ONE_KB)});
        }

        public static void setSubmessageSize(RaftProperties properties) {
            MessageStream.setSubmessageSize(properties, SUBMESSAGE_SIZE_DEFAULT);
        }
    }

    public static interface DataStream {
        public static final String PREFIX = "raft.client.data-stream";
        public static final String OUTSTANDING_REQUESTS_MAX_KEY = "raft.client.data-stream.outstanding-requests.max";
        public static final int OUTSTANDING_REQUESTS_MAX_DEFAULT = 100;

        public static int outstandingRequestsMax(RaftProperties properties) {
            return ConfUtils.getInt((arg_0, arg_1) -> ((RaftProperties)properties).getInt(arg_0, arg_1), (String)OUTSTANDING_REQUESTS_MAX_KEY, (int)100, RaftClientConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((int)2)});
        }

        public static void setOutstandingRequestsMax(RaftProperties properties, int outstandingRequests) {
            ConfUtils.setInt((arg_0, arg_1) -> ((RaftProperties)properties).setInt(arg_0, arg_1), (String)OUTSTANDING_REQUESTS_MAX_KEY, (int)outstandingRequests, (BiConsumer[])new BiConsumer[0]);
        }
    }

    public static interface Async {
        public static final String PREFIX = "raft.client.async";
        public static final String OUTSTANDING_REQUESTS_MAX_KEY = "raft.client.async.outstanding-requests.max";
        public static final int OUTSTANDING_REQUESTS_MAX_DEFAULT = 100;

        public static int outstandingRequestsMax(RaftProperties properties) {
            return ConfUtils.getInt((arg_0, arg_1) -> ((RaftProperties)properties).getInt(arg_0, arg_1), (String)OUTSTANDING_REQUESTS_MAX_KEY, (int)100, RaftClientConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((int)2)});
        }

        public static void setOutstandingRequestsMax(RaftProperties properties, int outstandingRequests) {
            ConfUtils.setInt((arg_0, arg_1) -> ((RaftProperties)properties).setInt(arg_0, arg_1), (String)OUTSTANDING_REQUESTS_MAX_KEY, (int)outstandingRequests, (BiConsumer[])new BiConsumer[0]);
        }

        public static interface Experimental {
            public static final String PREFIX = "raft.client.async." + JavaUtils.getClassSimpleName(Experimental.class).toLowerCase();
            public static final String SEND_DUMMY_REQUEST_KEY = PREFIX + ".send-dummy-request";
            public static final boolean SEND_DUMMY_REQUEST_DEFAULT = true;

            public static boolean sendDummyRequest(RaftProperties properties) {
                return ConfUtils.getBoolean((arg_0, arg_1) -> ((RaftProperties)properties).getBoolean(arg_0, arg_1), (String)SEND_DUMMY_REQUEST_KEY, (boolean)true, RaftClientConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
            }

            public static void setSendDummyRequest(RaftProperties properties, boolean sendDummyRequest) {
                ConfUtils.setBoolean((arg_0, arg_1) -> ((RaftProperties)properties).setBoolean(arg_0, arg_1), (String)SEND_DUMMY_REQUEST_KEY, (boolean)sendDummyRequest, (BiConsumer[])new BiConsumer[0]);
            }
        }
    }

    public static interface Rpc {
        public static final String PREFIX = "raft.client.rpc";
        public static final String REQUEST_TIMEOUT_KEY = "raft.client.rpc.request.timeout";
        public static final TimeDuration REQUEST_TIMEOUT_DEFAULT = TimeDuration.valueOf((long)3000L, (TimeUnit)TimeUnit.MILLISECONDS);
        public static final String WATCH_REQUEST_TIMEOUT_KEY = "raft.client.rpc.watch.request.timeout";
        public static final TimeDuration WATCH_REQUEST_TIMEOUT_DEFAULT = TimeDuration.valueOf((long)10000L, (TimeUnit)TimeUnit.MILLISECONDS);

        public static TimeDuration requestTimeout(RaftProperties properties) {
            return ConfUtils.getTimeDuration((BiFunction)properties.getTimeDuration(REQUEST_TIMEOUT_DEFAULT.getUnit()), (String)REQUEST_TIMEOUT_KEY, (TimeDuration)REQUEST_TIMEOUT_DEFAULT, RaftClientConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
        }

        public static void setRequestTimeout(RaftProperties properties, TimeDuration timeoutDuration) {
            ConfUtils.setTimeDuration((arg_0, arg_1) -> ((RaftProperties)properties).setTimeDuration(arg_0, arg_1), (String)REQUEST_TIMEOUT_KEY, (TimeDuration)timeoutDuration, (BiConsumer[])new BiConsumer[0]);
        }

        public static TimeDuration watchRequestTimeout(RaftProperties properties) {
            return ConfUtils.getTimeDuration((BiFunction)properties.getTimeDuration(WATCH_REQUEST_TIMEOUT_DEFAULT.getUnit()), (String)WATCH_REQUEST_TIMEOUT_KEY, (TimeDuration)WATCH_REQUEST_TIMEOUT_DEFAULT, RaftClientConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
        }

        public static void setWatchRequestTimeout(RaftProperties properties, TimeDuration timeoutDuration) {
            ConfUtils.setTimeDuration((arg_0, arg_1) -> ((RaftProperties)properties).setTimeDuration(arg_0, arg_1), (String)WATCH_REQUEST_TIMEOUT_KEY, (TimeDuration)timeoutDuration, (BiConsumer[])new BiConsumer[0]);
        }
    }
}

