/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.mp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.rat.Defaults;
import org.apache.rat.ReportConfiguration;
import org.apache.rat.mp.AbstractRatMojo;
import org.apache.rat.mp.RatCheckException;
import org.apache.rat.report.claim.ClaimStatistic;

public class RatCheckMojo
extends AbstractRatMojo {
    private File reportFile;
    private String reportStyle;
    private int numUnapprovedLicenses;
    private String addLicenseHeaders;
    private String copyrightMessage;

    private ClaimStatistic getRawReport() throws MojoExecutionException, MojoFailureException {
        FileWriter fw = null;
        try {
            fw = new FileWriter(this.reportFile);
            ClaimStatistic statistic = this.createReport(fw, this.getStyleSheet());
            fw.close();
            fw = null;
            ClaimStatistic claimStatistic = statistic;
            return claimStatistic;
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    private InputStream getStyleSheet() throws MojoExecutionException {
        if (this.reportStyle == null || this.reportStyle.equals("plain")) {
            return Defaults.getPlainStyleSheet();
        }
        if (this.reportStyle.equals("xml")) {
            return null;
        }
        try {
            return new FileInputStream(this.reportStyle);
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Unable to find report stylesheet: " + this.reportStyle, (Exception)e);
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        File parent = this.reportFile.getParentFile();
        parent.mkdirs();
        ClaimStatistic report = this.getRawReport();
        this.check(report);
    }

    protected void check(ClaimStatistic statistics) throws MojoFailureException {
        if (this.numUnapprovedLicenses < statistics.getNumUnApproved()) {
            throw new RatCheckException("Too many unapproved licenses: " + statistics.getNumUnApproved());
        }
    }

    protected ReportConfiguration getConfiguration() throws MojoFailureException, MojoExecutionException {
        ReportConfiguration configuration = super.getConfiguration();
        if ("forced".equals(this.addLicenseHeaders)) {
            configuration.setAddingLicenses(true);
            configuration.setAddingLicensesForced(true);
            configuration.setCopyrightMessage(this.copyrightMessage);
        } else if ("true".equals(this.addLicenseHeaders)) {
            configuration.setAddingLicenses(true);
            configuration.setCopyrightMessage(this.copyrightMessage);
        } else if (!"false".equals(this.addLicenseHeaders)) {
            throw new MojoFailureException("Invalid value for addLicenseHeaders: Expected forced|true|false, got " + this.addLicenseHeaders);
        }
        return configuration;
    }
}

