/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.mp.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.apache.rat.config.SourceCodeManagementSystems;
import org.apache.rat.mp.util.ignore.GitIgnoreMatcher;
import org.apache.rat.mp.util.ignore.GlobIgnoreMatcher;
import org.apache.rat.mp.util.ignore.IgnoreMatcher;

public final class ScmIgnoreParser {
    private ScmIgnoreParser() {
    }

    public static List<IgnoreMatcher> getExclusionsFromSCM(Log log, File baseDir) {
        ArrayList<IgnoreMatcher> ignoreMatchers = new ArrayList<IgnoreMatcher>();
        block3: for (SourceCodeManagementSystems scm : SourceCodeManagementSystems.values()) {
            switch (scm) {
                case GIT: {
                    GitIgnoreMatcher gitIgnoreMatcher = new GitIgnoreMatcher(log, baseDir);
                    if (gitIgnoreMatcher.isEmpty()) continue block3;
                    ignoreMatchers.add(gitIgnoreMatcher);
                    continue block3;
                }
                default: {
                    GlobIgnoreMatcher ignoreMatcher;
                    if (!scm.hasIgnoreFile() || (ignoreMatcher = new GlobIgnoreMatcher(log, new File(baseDir, scm.getIgnoreFile()))).isEmpty()) continue block3;
                    ignoreMatchers.add(ignoreMatcher);
                }
            }
        }
        return ignoreMatchers;
    }
}

