/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas.impl.util;

import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Properties;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.dom.DOMMetaFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.TrustException;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.components.crypto.CryptoType;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.processor.EncryptedKeyProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CommonUtil {
    private static Log log = LogFactory.getLog(CommonUtil.class);

    public static Document getOMDOMDocument() throws TrustException {
        DOMMetaFactory metaFactory = (DOMMetaFactory)OMAbstractFactory.getMetaFactory((String)"dom");
        DocumentBuilderFactory dbf = metaFactory.newDocumentBuilderFactory();
        try {
            return dbf.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new TrustException("Error creating Axiom compatible DOM Document", e);
        }
    }

    public static X509Certificate getCertificateByAlias(Crypto crypto, String alias) throws TrustException {
        X509Certificate[] certificates = CommonUtil.getCertificatesByAlias(crypto, alias);
        if (certificates == null) {
            log.error((Object)("Unable to retrieve certificate for alias " + alias));
            throw new TrustException("issuerCertificateNotFound");
        }
        return certificates[0];
    }

    public static X509Certificate[] getCertificatesByAlias(Crypto crypto, String alias) throws TrustException {
        CryptoType type = new CryptoType(CryptoType.TYPE.ALIAS);
        type.setAlias(alias);
        try {
            X509Certificate[] certificates = crypto.getX509Certificates(type);
            if (certificates == null) {
                log.debug((Object)("Unable to retrieve certificate for alias " + alias));
                return new X509Certificate[0];
            }
            return certificates;
        }
        catch (WSSecurityException e) {
            log.error((Object)("Unable to retrieve certificate for alias " + alias), (Throwable)e);
            throw new TrustException("issuerCertificateNotFound", e);
        }
    }

    public static byte[] getDecryptedBytes(CallbackHandler callbackHandler, Crypto crypto, Node encryptedKeyElement) throws WSSecurityException {
        EncryptedKeyProcessor encryptedKeyProcessor = new EncryptedKeyProcessor();
        RequestData requestData = new RequestData();
        requestData.setCallbackHandler(callbackHandler);
        requestData.setDecCrypto(crypto);
        WSSConfig cfg = WSSConfig.getNewInstance();
        requestData.setWssConfig(cfg);
        WSDocInfo docInfo = new WSDocInfo(encryptedKeyElement.getOwnerDocument());
        List resultList = null;
        resultList = encryptedKeyProcessor.handleToken((Element)encryptedKeyElement, requestData, docInfo);
        WSSecurityEngineResult wsSecurityEngineResult = (WSSecurityEngineResult)resultList.get(0);
        return (byte[])wsSecurityEngineResult.get((Object)"secret");
    }

    public static Crypto getCrypto(Properties properties, ClassLoader classLoader) throws TrustException {
        try {
            return CryptoFactory.getInstance((Properties)properties, (ClassLoader)classLoader);
        }
        catch (WSSecurityException e) {
            log.error((Object)"An error occurred while loading crypto properties", (Throwable)e);
            throw new TrustException("errorLoadingCryptoProperties", e);
        }
    }

    public static Crypto getCrypto(String propertiesFile, ClassLoader classLoader) throws TrustException {
        try {
            return CryptoFactory.getInstance((String)propertiesFile, (ClassLoader)classLoader);
        }
        catch (WSSecurityException e) {
            log.error((Object)("An error occurred while loading crypto properties with property file " + propertiesFile), (Throwable)e);
            throw new TrustException("errorLoadingCryptoProperties", new Object[]{propertiesFile}, e);
        }
    }
}

