/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas.impl;

import java.security.Principal;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.RahasData;
import org.apache.rahas.Token;
import org.apache.rahas.TokenIssuer;
import org.apache.rahas.TrustException;
import org.apache.rahas.TrustUtil;
import org.apache.rahas.impl.SAMLTokenIssuerConfig;
import org.apache.rahas.impl.TokenIssuerUtil;
import org.apache.rahas.impl.util.CommonUtil;
import org.apache.rahas.impl.util.SAMLAttributeCallback;
import org.apache.rahas.impl.util.SAMLCallbackHandler;
import org.apache.rahas.impl.util.SAMLNameIdentifierCallback;
import org.apache.rahas.impl.util.SAMLUtils;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.WSUsernameTokenPrincipal;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.util.Loader;
import org.apache.ws.security.util.XmlSchemaDateFormat;
import org.joda.time.DateTime;
import org.opensaml.common.SAMLException;
import org.opensaml.saml1.core.Assertion;
import org.opensaml.saml1.core.Attribute;
import org.opensaml.saml1.core.AttributeStatement;
import org.opensaml.saml1.core.AuthenticationStatement;
import org.opensaml.saml1.core.NameIdentifier;
import org.opensaml.saml1.core.Statement;
import org.opensaml.saml1.core.Subject;
import org.opensaml.xml.signature.KeyInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SAMLTokenIssuer
implements TokenIssuer {
    private String configParamName;
    private OMElement configElement;
    private String configFile;
    private static final String AUTHENTICATION_METHOD_PASSWORD = "urn:oasis:names:tc:SAML:1.0:am:password";
    private static final Log log = LogFactory.getLog(SAMLTokenIssuer.class);

    public SOAPEnvelope issue(RahasData data) throws TrustException {
        OMElement rstrElem;
        Assertion assertion;
        MessageContext inMsgCtx = data.getInMessageContext();
        SAMLTokenIssuerConfig config = null;
        if (this.configElement != null) {
            config = new SAMLTokenIssuerConfig(this.configElement.getFirstChildWithName(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG));
        }
        if (config == null && this.configFile != null) {
            config = new SAMLTokenIssuerConfig(this.configFile);
        }
        if (config == null && this.configParamName != null) {
            Parameter param = inMsgCtx.getParameter(this.configParamName);
            if (param != null && param.getParameterElement() != null) {
                config = new SAMLTokenIssuerConfig(param.getParameterElement().getFirstChildWithName(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG));
            } else {
                throw new TrustException("expectedParameterMissing", new String[]{this.configParamName});
            }
        }
        if (config == null) {
            throw new TrustException("configurationIsNull");
        }
        SOAPEnvelope env = TrustUtil.createSOAPEnvelope(inMsgCtx.getEnvelope().getNamespace().getNamespaceURI());
        Crypto crypto = config.cryptoElement != null ? CommonUtil.getCrypto(TrustUtil.toProperties(config.cryptoElement), inMsgCtx.getAxisService().getClassLoader()) : CommonUtil.getCrypto(config.cryptoPropertiesFile, inMsgCtx.getAxisService().getClassLoader());
        DateTime creationTime = new DateTime();
        DateTime expirationTime = new DateTime(creationTime.getMillis() + config.ttl);
        Document doc = ((Element)env).getOwnerDocument();
        int keySize = data.getKeysize();
        keySize = keySize == -1 ? config.keySize : keySize;
        String keyType = data.getKeyType();
        if (keyType == null) {
            throw new TrustException("InvalidRequest", new String[]{"Requested KeyType is missing"});
        }
        if (keyType.endsWith("/SymmetricKey") || keyType.endsWith("/PublicKey")) {
            assertion = this.createHoKAssertion(config, doc, crypto, creationTime, expirationTime, data);
        } else if (keyType.endsWith("/Bearer")) {
            assertion = this.createBearerAssertion(config, doc, crypto, creationTime, expirationTime, data);
        } else {
            throw new TrustException("unsupportedKeyType");
        }
        int wstVersion = data.getVersion();
        if (1 == wstVersion) {
            rstrElem = TrustUtil.createRequestSecurityTokenResponseElement(wstVersion, (OMElement)env.getBody());
        } else {
            OMElement rstrcElem = TrustUtil.createRequestSecurityTokenResponseCollectionElement(wstVersion, (OMElement)env.getBody());
            rstrElem = TrustUtil.createRequestSecurityTokenResponseElement(wstVersion, rstrcElem);
        }
        TrustUtil.createTokenTypeElement(wstVersion, rstrElem).setText("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
        if (keyType.endsWith("/SymmetricKey")) {
            TrustUtil.createKeySizeElement(wstVersion, rstrElem, keySize);
        }
        if (config.addRequestedAttachedRef) {
            TrustUtil.createRequestedAttachedRef(rstrElem, assertion.getID(), wstVersion);
        }
        if (config.addRequestedUnattachedRef) {
            TrustUtil.createRequestedUnattachedRef(rstrElem, assertion.getID(), wstVersion);
        }
        if (data.getAppliesToAddress() != null) {
            TrustUtil.createAppliesToElement(rstrElem, data.getAppliesToAddress(), data.getAddressingNs());
        }
        XmlSchemaDateFormat zulu = new XmlSchemaDateFormat();
        TrustUtil.createLifetimeElement(wstVersion, rstrElem, zulu.format(creationTime.toDate()), zulu.format(expirationTime.toDate()));
        OMElement reqSecTokenElem = TrustUtil.createRequestedSecurityTokenElement(wstVersion, rstrElem);
        Element tempNode = assertion.getDOM();
        reqSecTokenElem.addChild((OMNode)((Element)rstrElem).getOwnerDocument().importNode(tempNode, true));
        Token assertionToken = new Token(assertion.getID(), (OMElement)assertion.getDOM(), creationTime.toDate(), expirationTime.toDate());
        assertionToken.setSecret(data.getEphmeralKey());
        TrustUtil.getTokenStore(inMsgCtx).add(assertionToken);
        if (keyType.endsWith("/SymmetricKey") && config.keyComputation != 1) {
            TokenIssuerUtil.handleRequestedProofToken(data, wstVersion, config, rstrElem, assertionToken, doc);
        }
        return env;
    }

    private Assertion createBearerAssertion(SAMLTokenIssuerConfig config, Document doc, Crypto crypto, DateTime creationTime, DateTime expirationTime, RahasData data) throws TrustException {
        Principal principal = data.getPrincipal();
        if (principal instanceof WSUsernameTokenPrincipal) {
            NameIdentifier nameId = null;
            if (config.getCallbackHandler() != null) {
                SAMLNameIdentifierCallback cb = new SAMLNameIdentifierCallback(data);
                cb.setUserId(principal.getName());
                SAMLCallbackHandler callbackHandler = config.getCallbackHandler();
                try {
                    callbackHandler.handle(cb);
                }
                catch (SAMLException e) {
                    throw new TrustException("unableToRetrieveCallbackHandler", e);
                }
                nameId = cb.getNameId();
            } else {
                nameId = SAMLUtils.createNamedIdentifier(principal.getName(), "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
            }
            Assertion assertion = this.createAuthAssertion("urn:oasis:names:tc:SAML:1.0:cm:bearer", nameId, null, config, crypto, creationTime, expirationTime, data);
            return assertion;
        }
        throw new TrustException("samlUnsupportedPrincipal", new String[]{principal.getClass().getName()});
    }

    private Assertion createHoKAssertion(SAMLTokenIssuerConfig config, Document doc, Crypto crypto, DateTime creationTime, DateTime expirationTime, RahasData data) throws TrustException {
        if (data.getKeyType().endsWith("/SymmetricKey")) {
            X509Certificate serviceCert = null;
            try {
                NameIdentifier nameIdentifier = null;
                if (data.getPrincipal() != null) {
                    String subjectNameId = data.getPrincipal().getName();
                    nameIdentifier = SAMLUtils.createNamedIdentifier(subjectNameId, "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
                }
                serviceCert = this.getServiceCert(config, crypto, data.getAppliesToAddress());
                int keySize = data.getKeysize();
                keySize = keySize != -1 ? keySize : config.keySize;
                KeyInfo encryptedKeyInfoElement = SAMLUtils.getSymmetricKeyBasedKeyInfo(doc, data, serviceCert, keySize, crypto, config.keyComputation);
                return this.createAttributeAssertion(data, encryptedKeyInfoElement, nameIdentifier, config, crypto, creationTime, expirationTime);
            }
            catch (WSSecurityException e) {
                if (serviceCert != null) {
                    throw new TrustException("errorInBuildingTheEncryptedKeyForPrincipal", new String[]{serviceCert.getSubjectDN().getName()}, e);
                }
                throw new TrustException("trustedCertNotFoundForEPR", new String[]{data.getAppliesToAddress()}, e);
            }
        }
        try {
            String subjectNameId = data.getPrincipal().getName();
            NameIdentifier nameId = SAMLUtils.createNamedIdentifier(subjectNameId, "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
            X509Certificate clientCert = data.getClientCert();
            if (clientCert == null) {
                clientCert = CommonUtil.getCertificateByAlias(crypto, data.getPrincipal().getName());
            }
            KeyInfo keyInfo = SAMLUtils.getCertificateBasedKeyInfo(clientCert);
            return this.createAuthAssertion("urn:oasis:names:tc:SAML:1.0:cm:holder-of-key", nameId, keyInfo, config, crypto, creationTime, expirationTime, data);
        }
        catch (Exception e) {
            throw new TrustException("samlAssertionCreationError", e);
        }
    }

    private X509Certificate getServiceCert(SAMLTokenIssuerConfig config, Crypto crypto, String serviceAddress) throws TrustException {
        if (serviceAddress != null && !"".equals(serviceAddress)) {
            String alias = (String)config.trustedServices.get(serviceAddress);
            if (alias != null) {
                return CommonUtil.getCertificateByAlias(crypto, alias);
            }
            alias = (String)config.trustedServices.get("*");
            return CommonUtil.getCertificateByAlias(crypto, alias);
        }
        String alias = (String)config.trustedServices.get("*");
        return CommonUtil.getCertificateByAlias(crypto, alias);
    }

    private Assertion createAttributeAssertion(RahasData data, KeyInfo keyInfo, NameIdentifier subjectNameId, SAMLTokenIssuerConfig config, Crypto crypto, DateTime notBefore, DateTime notAfter) throws TrustException {
        try {
            Attribute[] attrs;
            SAMLCallbackHandler handler;
            SAMLAttributeCallback cb;
            Subject subject = SAMLUtils.createSubject(subjectNameId, "urn:oasis:names:tc:SAML:1.0:cm:holder-of-key", keyInfo);
            if (config.getCallbackHandler() != null) {
                cb = new SAMLAttributeCallback(data);
                handler = config.getCallbackHandler();
                handler.handle(cb);
                attrs = cb.getAttributes();
            } else if (config.getCallbackHandlerName() != null && config.getCallbackHandlerName().trim().length() > 0) {
                Class cbClass;
                cb = new SAMLAttributeCallback(data);
                handler = null;
                MessageContext msgContext = data.getInMessageContext();
                ClassLoader classLoader = msgContext.getAxisService().getClassLoader();
                try {
                    cbClass = Loader.loadClass((ClassLoader)classLoader, (String)config.getCallbackHandlerName());
                }
                catch (ClassNotFoundException e) {
                    throw new TrustException("cannotLoadPWCBClass", new String[]{config.getCallbackHandlerName()}, e);
                }
                try {
                    handler = (SAMLCallbackHandler)cbClass.newInstance();
                }
                catch (Exception e) {
                    throw new TrustException("cannotCreatePWCBInstance", new String[]{config.getCallbackHandlerName()}, e);
                }
                handler.handle(cb);
                attrs = cb.getAttributes();
            } else {
                Attribute attribute = SAMLUtils.createAttribute("Name", "https://rahas.apache.org/saml/attrns", "Colombo/Rahas");
                attrs = new Attribute[]{attribute};
            }
            AttributeStatement attributeStatement = SAMLUtils.createAttributeStatement(subject, Arrays.asList(attrs));
            ArrayList<Statement> attributeStatements = new ArrayList<Statement>();
            attributeStatements.add((Statement)attributeStatement);
            Assertion assertion = SAMLUtils.createAssertion(config.issuerName, notBefore, notAfter, attributeStatements);
            SAMLUtils.signAssertion(assertion, crypto, config.getIssuerKeyAlias(), config.getIssuerKeyPassword());
            return assertion;
        }
        catch (Exception e) {
            throw new TrustException("samlAssertionCreationError", e);
        }
    }

    private Assertion createAuthAssertion(String confirmationMethod, NameIdentifier subjectNameId, KeyInfo keyInfo, SAMLTokenIssuerConfig config, Crypto crypto, DateTime notBefore, DateTime notAfter, RahasData data) throws TrustException {
        try {
            Subject subject = SAMLUtils.createSubject(subjectNameId, confirmationMethod, keyInfo);
            AuthenticationStatement authenticationStatement = SAMLUtils.createAuthenticationStatement(subject, AUTHENTICATION_METHOD_PASSWORD, notBefore);
            ArrayList<Statement> statements = new ArrayList<Statement>();
            if (data.getClaimDialect() != null && data.getClaimElem() != null) {
                AttributeStatement attrStatement = this.createSAMLAttributeStatement(SAMLUtils.createSubject(subject.getNameIdentifier(), confirmationMethod, keyInfo), data, config);
                statements.add((Statement)attrStatement);
            }
            statements.add((Statement)authenticationStatement);
            Assertion assertion = SAMLUtils.createAssertion(config.issuerName, notBefore, notAfter, statements);
            SAMLUtils.signAssertion(assertion, crypto, config.getIssuerKeyAlias(), config.getIssuerKeyPassword());
            return assertion;
        }
        catch (Exception e) {
            throw new TrustException("samlAssertionCreationError", e);
        }
    }

    public String getResponseAction(RahasData data) throws TrustException {
        return TrustUtil.getActionValue(data.getVersion(), "/RSTR/Issue");
    }

    protected byte[] generateEphemeralKey(int keySize) throws TrustException {
        try {
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            byte[] temp = new byte[keySize / 8];
            random.nextBytes(temp);
            return temp;
        }
        catch (Exception e) {
            throw new TrustException("Error in creating the ephemeral key", e);
        }
    }

    public void setConfigurationFile(String configFile) {
        this.configFile = configFile;
    }

    public void setConfigurationElement(OMElement configElement) {
        this.configElement = configElement;
    }

    public void setConfigurationParamName(String configParamName) {
        this.configParamName = configParamName;
    }

    private AttributeStatement createSAMLAttributeStatement(Subject subject, RahasData rahasData, SAMLTokenIssuerConfig config) throws TrustException {
        SAMLAttributeCallback cb;
        Attribute[] attrs = null;
        if (config.getCallbackHandler() != null) {
            cb = new SAMLAttributeCallback(rahasData);
            SAMLCallbackHandler handler = config.getCallbackHandler();
            try {
                handler.handle(cb);
                attrs = cb.getAttributes();
            }
            catch (SAMLException e) {
                throw new TrustException("unableToRetrieveCallbackHandler", e);
            }
        }
        if (config.getCallbackHandlerName() != null && config.getCallbackHandlerName().trim().length() > 0) {
            cb = new SAMLAttributeCallback(rahasData);
            SAMLCallbackHandler handler = null;
            MessageContext msgContext = rahasData.getInMessageContext();
            ClassLoader classLoader = msgContext.getAxisService().getClassLoader();
            Class cbClass = null;
            try {
                cbClass = Loader.loadClass((ClassLoader)classLoader, (String)config.getCallbackHandlerName());
            }
            catch (ClassNotFoundException e) {
                throw new TrustException("cannotLoadPWCBClass", new String[]{config.getCallbackHandlerName()}, e);
            }
            try {
                handler = (SAMLCallbackHandler)cbClass.newInstance();
            }
            catch (Exception e) {
                throw new TrustException("cannotCreatePWCBInstance", new String[]{config.getCallbackHandlerName()}, e);
            }
            try {
                handler.handle(cb);
            }
            catch (SAMLException e) {
                throw new TrustException("unableToRetrieveCallbackHandler", e);
            }
            attrs = cb.getAttributes();
        } else {
            Attribute attribute = SAMLUtils.createAttribute("Name", "https://rahas.apache.org/saml/attrns", "Colombo/Rahas");
            attrs = new Attribute[]{attribute};
        }
        AttributeStatement attributeStatement = SAMLUtils.createAttributeStatement(subject, Arrays.asList(attrs));
        return attributeStatement;
    }
}

