/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.qmf2.tools;

import java.util.Arrays;
import java.util.List;
import javax.jms.Connection;
import org.apache.qpid.messaging.util.AddressParser;
import org.apache.qpid.qmf2.common.QmfData;
import org.apache.qpid.qmf2.common.QmfException;
import org.apache.qpid.qmf2.console.Agent;
import org.apache.qpid.qmf2.console.Console;
import org.apache.qpid.qmf2.console.MethodResult;
import org.apache.qpid.qmf2.console.QmfConsoleData;
import org.apache.qpid.qmf2.util.ConnectionHelper;
import org.apache.qpid.qmf2.util.GetOpt;

public final class QpidCtrl {
    private static final String _usage = "Usage: QpidCtrl [options] command [args]\nThe args need to be in a Stringified Map format (similar to an Address String)\ne.g. to set broker log level: QpidCtrl setLogLevel \"{level:\\\"debug+:Broker\\\"}\"\nThe listValues command lists property names and values of the specified object.\nThe listObjects command lists all objects of the specified package and class.\n";
    private static final String _options = "Options:\n  -h, --help            show this help message and exit\n  -v                    enable logging\n  -a <address>, --broker-address=<address>\n                        broker-addr is in the form:  [username/password@]\n                        hostname | ip-address [:<port>]   ex:  localhost,\n                        10.1.1.7:10000, broker-host:10000,\n                        guest/guest@localhost\n  -c <class>, --class=<class>\n                        class of object on which command is being invoked\n                        (default broker)\n  -p <package>, --package=<package>\n                        package of object on which command is being invoked\n                        (default org.apache.qpid.broker)\n  -i <id>, --id=<id>    identifier of object on which command is being invoked\n                        (default amqp-broker)\n  --agent=<agent name>\n                        The name of the Agent to which commands will be sent\n                        This will try to match <agent name> against the Agent name,\n                        the Agent product name and will also check if the Agent name\n                        contains the <agent name> String\n                        (default qpidd)\n  --sasl-mechanism=<mech>\n                        SASL mechanism for authentication (e.g. EXTERNAL,\n                        ANONYMOUS, PLAIN, CRAM-MD5, DIGEST-MD5, GSSAPI). SASL\n                        automatically picks the most secure available\n                        mechanism - use this option to override.\n";
    private Console _console;

    public QpidCtrl(String url, String connectionOptions, String pkg, String cls, String id, String agentName, String command, String args) {
        try {
            Connection connection = ConnectionHelper.createConnection((String)url, (String)connectionOptions);
            this._console = new Console();
            this._console.addConnection(connection);
            Agent agent = this._console.findAgent(agentName);
            if (agent == null) {
                System.out.println("Agent " + agentName + " not found");
                System.exit(1);
            }
            List<Agent> agentList = Arrays.asList(agent);
            List objects = this._console.getObjects(pkg, cls, agentList);
            QmfData inArgs = args == null ? new QmfData() : new QmfData(new AddressParser(args).map());
            MethodResult results = null;
            for (QmfConsoleData object : objects) {
                String objectName = object.getObjectId().getObjectName();
                if (command.equals("listObjects")) {
                    System.out.println(objectName);
                    continue;
                }
                if (!objectName.contains(id)) continue;
                if (command.equals("listValues")) {
                    object.listValues();
                    System.exit(1);
                    break;
                }
                results = object.invokeMethod(command, inArgs);
                break;
            }
            if (results == null) {
                if (objects.size() == 0) {
                    System.out.println("getObjects(" + pkg + ", " + cls + ", " + agentName + ") returned no objects.");
                } else {
                    System.out.println("Id " + id + " not found in " + pkg + ":" + cls);
                }
            } else if (results.succeeded()) {
                results.listValues();
            } else {
                System.err.println("QmfException " + results.getQmfException().getMessage() + " returned from " + command + " method");
            }
        }
        catch (QmfException qmfe) {
            System.err.println("QmfException " + qmfe.getMessage() + " caught in QpidCtrl constructor");
        }
    }

    public static void main(String[] args) {
        String logLevel = System.getProperty("amqj.logging.level");
        logLevel = logLevel == null ? "FATAL" : logLevel;
        System.setProperty("amqj.logging.level", logLevel);
        System.setProperty("qpid.jms.daemon.dispatcher", "true");
        String[] longOpts = new String[]{"help", "broker-address=", "class=", "package=", "id=", "agent=", "sasl-mechanism="};
        try {
            String host = "localhost";
            String connectionOptions = "{reconnect: true}";
            String cls = "broker";
            String pkg = "org.apache.qpid.broker";
            String id = "amqp-broker";
            String agentName = "qpidd";
            String command = null;
            String arg = null;
            GetOpt getopt = new GetOpt(args, "ha:c:p:i:v", longOpts);
            List optList = getopt.getOptList();
            String[] cargs = new String[]{};
            cargs = getopt.getEncArgs().toArray(cargs);
            for (String[] opt : optList) {
                if (opt[0].equals("-h") || opt[0].equals("--help")) {
                    System.out.println(_usage);
                    System.out.println(_options);
                    System.exit(1);
                    continue;
                }
                if (opt[0].equals("-a") || opt[0].equals("--broker-address")) {
                    host = opt[1];
                    continue;
                }
                if (opt[0].equals("-c") || opt[0].equals("--class")) {
                    cls = opt[1];
                    continue;
                }
                if (opt[0].equals("-p") || opt[0].equals("--package")) {
                    pkg = opt[1];
                    continue;
                }
                if (opt[0].equals("-i") || opt[0].equals("--id")) {
                    id = opt[1];
                    continue;
                }
                if (opt[0].equals("--agent")) {
                    agentName = opt[1];
                    continue;
                }
                if (opt[0].equals("-v")) {
                    System.setProperty("amqj.logging.level", "DEBUG");
                    continue;
                }
                if (!opt[0].equals("--sasl-mechanism")) continue;
                connectionOptions = "{reconnect: true, sasl_mechs: " + opt[1] + "}";
            }
            if (cargs.length < 1 || cargs.length > 2) {
                System.out.println(Arrays.asList(cargs));
                System.out.println(_usage);
                System.exit(1);
            }
            command = cargs[0];
            if (!(cargs.length != 2 || (arg = cargs[1]).startsWith("{") && arg.endsWith("}"))) {
                System.out.println("Incorrect format for args.");
                System.out.println("This needs to be in a Stringified Map format similar to an Address String");
                System.exit(1);
            }
            QpidCtrl qpidCtrl = new QpidCtrl(host, connectionOptions, pkg, cls, id, agentName, command, arg);
        }
        catch (IllegalArgumentException e) {
            System.out.println(_usage);
            System.out.println(e.getMessage());
            System.exit(1);
        }
    }
}

