/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.qmf2.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Connection;
import org.apache.qpid.qmf2.common.ObjectId;
import org.apache.qpid.qmf2.common.QmfData;
import org.apache.qpid.qmf2.common.QmfException;
import org.apache.qpid.qmf2.console.Console;
import org.apache.qpid.qmf2.console.QmfConsoleData;
import org.apache.qpid.qmf2.util.ConnectionHelper;
import org.apache.qpid.qmf2.util.GetOpt;

public final class QpidConfig {
    private static final String _usage = "Usage:  qpid-config [OPTIONS]\n        qpid-config [OPTIONS] exchanges [filter-string]\n        qpid-config [OPTIONS] queues    [filter-string]\n        qpid-config [OPTIONS] add exchange <type> <name> [AddExchangeOptions]\n        qpid-config [OPTIONS] del exchange <name>\n        qpid-config [OPTIONS] add queue <name> [AddQueueOptions]\n        qpid-config [OPTIONS] del queue <name> [DelQueueOptions]\n        qpid-config [OPTIONS] bind   <exchange-name> <queue-name> [binding-key]\n                  <for type xml>     [-f -|filename]\n                  <for type header>  [all|any] k1=v1 [, k2=v2...]\n        qpid-config [OPTIONS] unbind <exchange-name> <queue-name> [binding-key]\n";
    private static final String _description = "ADDRESS syntax:\n\n      [username/password@] hostname\n      ip-address [:<port>]\n\nExamples:\n\n$ qpid-config add queue q\n$ qpid-config add exchange direct d localhost:5672\n$ qpid-config exchanges 10.1.1.7:10000\n$ qpid-config queues guest/guest@broker-host:10000\n\nAdd Exchange <type> values:\n\n    direct     Direct exchange for point-to-point communication\n    fanout     Fanout exchange for broadcast communication\n    topic      Topic exchange that routes messages using binding keys with wildcards\n    headers    Headers exchange that matches header fields against the binding keys\n    xml        XML Exchange - allows content filtering using an XQuery\n\n\nQueue Limit Actions\n\n    none (default) - Use broker's default policy\n    reject         - Reject enqueued messages\n    flow-to-disk   - Page messages to disk\n    ring           - Replace oldest unacquired message with new\n    ring-strict    - Replace oldest message, reject if oldest is acquired\n\nQueue Ordering Policies\n\n    fifo (default) - First in, first out\n    lvq            - Last Value Queue ordering, allows queue browsing\n    lvq-no-browse  - Last Value Queue ordering, browsing clients may lose data\n";
    private static final String _options = "Options:\n  -h, --help            show this help message and exit\n\n  General Options:\n    -t <secs>, --timeout=<secs>\n                        Maximum time to wait for broker connection (in\n                        seconds)\n    -b, --bindings      Show bindings in queue or exchange list\n    -a <address>, --broker-addr=<address>\n                        Maximum time to wait for broker connection (in\n                        seconds)\n    --sasl-mechanism=<mech>\n                        SASL mechanism for authentication (e.g. EXTERNAL,\n                        ANONYMOUS, PLAIN, CRAM-MD5, DIGEST-MD5, GSSAPI). SASL\n                        automatically picks the most secure available\n                        mechanism - use this option to override.\n\n  Options for Adding Exchanges and Queues:\n    --alternate-exchange=<aexname>\n                        Name of the alternate-exchange for the new queue or\n                        exchange. Exchanges route messages to the alternate\n                        exchange if they are unable to route them elsewhere.\n                        Queues route messages to the alternate exchange if\n                        they are rejected by a subscriber or orphaned by queue\n                        deletion.\n    --passive, --dry-run\n                        Do not actually add the exchange or queue, ensure that\n                        all parameters and permissions are correct and would\n                        allow it to be created.\n    --durable           The new queue or exchange is durable.\n\n  Options for Adding Queues:\n    --file-count=<n>    Number of files in queue's persistence journal\n    --file-size=<n>     File size in pages (64Kib/page)\n    --max-queue-size=<n>\n                        Maximum in-memory queue size as bytes\n    --max-queue-count=<n>\n                        Maximum in-memory queue size as a number of messages\n    --limit-policy=<policy>\n                        Action to take when queue limit is reached\n    --order=<ordering>  Queue ordering policy\n    --generate-queue-events=<n>\n                        If set to 1, every enqueue will generate an event that\n                        can be processed by registered listeners (e.g. for\n                        replication). If set to 2, events will be generated\n                        for enqueues and dequeues.\n    --flow-stop-size=<n>\n                        Turn on sender flow control when the number of queued\n                        bytes exceeds this value.\n    --flow-resume-size=<n>\n                        Turn off sender flow control when the number of queued\n                        bytes drops below this value.\n    --flow-stop-count=<n>\n                        Turn on sender flow control when the number of queued\n                        messages exceeds this value.\n    --flow-resume-count=<n>\n                        Turn off sender flow control when the number of queued\n                        messages drops below this value.\n    --argument=<NAME=VALUE>\n                        Specify a key-value pair to add to queue arguments\n\n  Options for Adding Exchanges:\n    --sequence          Exchange will insert a 'qpid.msg_sequence' field in\n                        the message header\n    --ive               Exchange will behave as an 'initial-value-exchange',\n                        keeping a reference  to the last message forwarded and\n                        enqueuing that message to newly bound queues.\n\n  Options for Deleting Queues:\n    --force             Force delete of queue even if it's currently used or\n                        it's not empty\n    --force-if-not-empty\n                        Force delete of queue even if it's not empty\n    --force-if-not-used\n                        Force delete of queue even if it's currently used\n\n  Options for Declaring Bindings:\n    -f <file.xq>, --file=<file.xq>\n                        For XML Exchange bindings - specifies the name of a\n                        file containing an XQuery.\n";
    private Console _console;
    private QmfConsoleData _broker;
    private boolean _recursive = false;
    private String _host = "localhost";
    private int _connTimeout = 10;
    private String _altExchange = null;
    private boolean _passive = false;
    private boolean _durable = false;
    private boolean _ifEmpty = true;
    private boolean _ifUnused = true;
    private long _fileCount = 8L;
    private long _fileSize = 24L;
    private long _maxQueueSize = 0L;
    private long _maxQueueCount = 0L;
    private String _limitPolicy = "none";
    private String _order = "fifo";
    private boolean _msgSequence = false;
    private boolean _ive = false;
    private long _eventGeneration = 0L;
    private String _file = null;
    private String _saslMechanism = null;
    private long _flowStopCount = 0L;
    private long _flowResumeCount = 0L;
    private long _flowStopSize = 0L;
    private long _flowResumeSize = 0L;
    private List<String> extraArguments = new ArrayList<String>();
    private static final String FILECOUNT = "qpid.file_count";
    private static final String FILESIZE = "qpid.file_size";
    private static final String MAX_QUEUE_SIZE = "qpid.max_size";
    private static final String MAX_QUEUE_COUNT = "qpid.max_count";
    private static final String POLICY_TYPE = "qpid.policy_type";
    private static final String LVQ = "qpid.last_value_queue";
    private static final String LVQNB = "qpid.last_value_queue_no_browse";
    private static final String MSG_SEQUENCE = "qpid.msg_sequence";
    private static final String IVE = "qpid.ive";
    private static final String QUEUE_EVENT_GENERATION = "qpid.queue_event_generation";
    private static final String FLOW_STOP_COUNT = "qpid.flow_stop_count";
    private static final String FLOW_RESUME_COUNT = "qpid.flow_resume_count";
    private static final String FLOW_STOP_SIZE = "qpid.flow_stop_size";
    private static final String FLOW_RESUME_SIZE = "qpid.flow_resume_size";
    private static HashSet<String> SPECIAL_ARGS = new HashSet();

    private void usage() {
        System.out.println(_usage);
        System.exit(1);
    }

    private void options() {
        System.out.println(_usage);
        System.out.println(_description);
        System.out.println(_options);
        System.exit(1);
    }

    private QmfConsoleData findById(List<QmfConsoleData> items, ObjectId id) {
        for (QmfConsoleData item : items) {
            if (!item.getObjectId().equals((Object)id)) continue;
            return item;
        }
        return null;
    }

    private void overview() {
        List exchanges = this._console.getObjects("org.apache.qpid.broker", "exchange");
        List queues = this._console.getObjects("org.apache.qpid.broker", "queue");
        System.out.printf("Total Exchanges: %d\n", exchanges.size());
        HashMap<String, AtomicInteger> etype = new HashMap<String, AtomicInteger>();
        for (QmfConsoleData qmfConsoleData : exchanges) {
            String exchangeType = qmfConsoleData.getStringValue("type");
            AtomicInteger n = (AtomicInteger)etype.get(exchangeType);
            if (n == null) {
                etype.put(exchangeType, new AtomicInteger(1));
                continue;
            }
            n.getAndIncrement();
        }
        for (Map.Entry entry : etype.entrySet()) {
            System.out.printf("%15s: %s\n", entry.getKey(), entry.getValue());
        }
        System.out.println();
        System.out.printf("   Total Queues: %d\n", queues.size());
        int durable = 0;
        for (QmfConsoleData queue : queues) {
            boolean isDurable = queue.getBooleanValue("durable");
            if (!isDurable) continue;
            ++durable;
        }
        System.out.printf("        durable: %d\n", durable);
        System.out.printf("    non-durable: %d\n", queues.size() - durable);
    }

    private void exchangeList(String filter) {
        List exchanges = this._console.getObjects("org.apache.qpid.broker", "exchange");
        String caption1 = "Type      ";
        String caption2 = "Exchange Name";
        int maxNameLen = caption2.length();
        for (QmfConsoleData exchange : exchanges) {
            String name = exchange.getStringValue("name");
            if (!filter.equals("") && !filter.equals(name) || name.length() <= maxNameLen) continue;
            maxNameLen = name.length();
        }
        System.out.printf("%s%-" + maxNameLen + "s Attributes\n", caption1, caption2);
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < (maxNameLen + caption1.length()) / 5 + 5; ++i) {
            buf.append("=====");
        }
        String line = buf.toString();
        System.out.println(line);
        for (QmfConsoleData exchange : exchanges) {
            ObjectId altExchangeRef;
            QmfConsoleData altExchange;
            String name = exchange.getStringValue("name");
            if (!filter.equals("") && !filter.equals(name)) continue;
            System.out.printf("%-10s%-" + maxNameLen + "s ", exchange.getStringValue("type"), name);
            Map args = (Map)exchange.getValue("arguments");
            Map map = args = args == null ? Collections.EMPTY_MAP : args;
            if (exchange.getBooleanValue("durable")) {
                System.out.printf("--durable ", new Object[0]);
            }
            if (args.containsKey(MSG_SEQUENCE) && QmfData.getLong(args.get(MSG_SEQUENCE)) == 1L) {
                System.out.printf("--sequence ", new Object[0]);
            }
            if (args.containsKey(IVE) && QmfData.getLong(args.get(IVE)) == 1L) {
                System.out.printf("--ive ", new Object[0]);
            }
            if (exchange.hasValue("altExchange") && (altExchange = this.findById(exchanges, altExchangeRef = exchange.getRefValue("altExchange"))) != null) {
                System.out.printf("--alternate-exchange=%s", altExchange.getStringValue("name"));
            }
            System.out.println();
        }
    }

    private void exchangeListRecurse(String filter) {
        List exchanges = this._console.getObjects("org.apache.qpid.broker", "exchange");
        List bindings = this._console.getObjects("org.apache.qpid.broker", "binding");
        List queues = this._console.getObjects("org.apache.qpid.broker", "queue");
        for (QmfConsoleData exchange : exchanges) {
            ObjectId exchangeId = exchange.getObjectId();
            String name = exchange.getStringValue("name");
            if (!filter.equals("") && !filter.equals(name)) continue;
            System.out.printf("Exchange '%s' (%s)\n", name, exchange.getStringValue("type"));
            for (QmfConsoleData binding : bindings) {
                ObjectId exchangeRef = binding.getRefValue("exchangeRef");
                if (!exchangeRef.equals((Object)exchangeId)) continue;
                ObjectId queueRef = binding.getRefValue("queueRef");
                QmfConsoleData queue = this.findById(queues, queueRef);
                String queueName = "<unknown>";
                if (queue != null && (queueName = queue.getStringValue("name")).equals("")) {
                    queueName = "''";
                }
                String bindingKey = binding.getStringValue("bindingKey");
                Map arguments = (Map)binding.getValue("arguments");
                if (arguments == null || arguments.isEmpty()) {
                    System.out.printf("    bind [%s] => %s\n", bindingKey, queueName);
                    continue;
                }
                System.out.printf("    bind [%s] => %s %s\n", bindingKey, queueName, arguments);
            }
        }
    }

    private void queueList(String filter) {
        List queues = this._console.getObjects("org.apache.qpid.broker", "queue");
        String caption = "Queue Name";
        int maxNameLen = caption.length();
        for (QmfConsoleData queue : queues) {
            String name = queue.getStringValue("name");
            if (!filter.equals("") && !filter.equals(name) || name.length() <= maxNameLen) continue;
            maxNameLen = name.length();
        }
        System.out.printf("%-" + maxNameLen + "s Attributes\n", caption);
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < maxNameLen / 5 + 5; ++i) {
            buf.append("=====");
        }
        String line = buf.toString();
        System.out.println(line);
        for (QmfConsoleData queue : queues) {
            ObjectId altExchangeRef;
            List altExchanges;
            String name = queue.getStringValue("name");
            if (!filter.equals("") && !filter.equals(name)) continue;
            System.out.printf("%-" + maxNameLen + "s ", name);
            Map args = (Map)queue.getValue("arguments");
            Map map = args = args == null ? Collections.EMPTY_MAP : args;
            if (queue.getBooleanValue("durable")) {
                System.out.printf("--durable ", new Object[0]);
            }
            if (queue.getBooleanValue("autoDelete")) {
                System.out.printf("auto-del ", new Object[0]);
            }
            if (queue.getBooleanValue("exclusive")) {
                System.out.printf("excl ", new Object[0]);
            }
            if (args.containsKey(FILESIZE)) {
                System.out.printf("--file-size=%d ", QmfData.getLong(args.get(FILESIZE)));
            }
            if (args.containsKey(FILECOUNT)) {
                System.out.printf("--file-count=%d ", QmfData.getLong(args.get(FILECOUNT)));
            }
            if (args.containsKey(MAX_QUEUE_SIZE)) {
                System.out.printf("--max-queue-size=%d ", QmfData.getLong(args.get(MAX_QUEUE_SIZE)));
            }
            if (args.containsKey(MAX_QUEUE_COUNT)) {
                System.out.printf("--max-queue-count=%d ", QmfData.getLong(args.get(MAX_QUEUE_COUNT)));
            }
            if (args.containsKey(POLICY_TYPE)) {
                System.out.printf("--limit-policy=%s ", QmfData.getString(args.get(POLICY_TYPE)).replace("_", "-"));
            }
            if (args.containsKey(LVQ) && QmfData.getLong(args.get(LVQ)) == 1L) {
                System.out.printf("--order lvq ", new Object[0]);
            }
            if (args.containsKey(LVQNB) && QmfData.getLong(args.get(LVQNB)) == 1L) {
                System.out.printf("--order lvq-no-browse ", new Object[0]);
            }
            if (args.containsKey(QUEUE_EVENT_GENERATION)) {
                System.out.printf("--generate-queue-events=%d ", QmfData.getLong(args.get(QUEUE_EVENT_GENERATION)));
            }
            if (queue.hasValue("altExchange") && (altExchanges = this._console.getObjects((QmfData)(altExchangeRef = queue.getRefValue("altExchange")))).size() == 1) {
                QmfConsoleData altExchange = (QmfConsoleData)altExchanges.get(0);
                System.out.printf("--alternate-exchange=%s", altExchange.getStringValue("name"));
            }
            if (args.containsKey(FLOW_STOP_SIZE)) {
                System.out.printf("--flow-stop-size=%d ", QmfData.getLong(args.get(FLOW_STOP_SIZE)));
            }
            if (args.containsKey(FLOW_RESUME_SIZE)) {
                System.out.printf("--flow-resume-size=%d ", QmfData.getLong(args.get(FLOW_RESUME_SIZE)));
            }
            if (args.containsKey(FLOW_STOP_COUNT)) {
                System.out.printf("--flow-stop-count=%d ", QmfData.getLong(args.get(FLOW_STOP_COUNT)));
            }
            if (args.containsKey(FLOW_RESUME_COUNT)) {
                System.out.printf("--flow-resume-count=%d ", QmfData.getLong(args.get(FLOW_RESUME_COUNT)));
            }
            for (Map.Entry entry : args.entrySet()) {
                if (SPECIAL_ARGS.contains(entry.getKey())) continue;
                System.out.printf("--argument %s=%s ", entry.getKey(), entry.getValue());
            }
            System.out.println();
        }
    }

    private void queueListRecurse(String filter) {
        List queues = this._console.getObjects("org.apache.qpid.broker", "queue");
        List bindings = this._console.getObjects("org.apache.qpid.broker", "binding");
        List exchanges = this._console.getObjects("org.apache.qpid.broker", "exchange");
        for (QmfConsoleData queue : queues) {
            ObjectId queueId = queue.getObjectId();
            String name = queue.getStringValue("name");
            if (!filter.equals("") && !filter.equals(name)) continue;
            System.out.printf("Queue '%s'\n", name);
            for (QmfConsoleData binding : bindings) {
                ObjectId queueRef = binding.getRefValue("queueRef");
                if (!queueRef.equals((Object)queueId)) continue;
                ObjectId exchangeRef = binding.getRefValue("exchangeRef");
                QmfConsoleData exchange = this.findById(exchanges, exchangeRef);
                String exchangeName = "<unknown>";
                if (exchange != null && (exchangeName = exchange.getStringValue("name")).equals("")) {
                    exchangeName = "''";
                }
                String bindingKey = binding.getStringValue("bindingKey");
                Map arguments = (Map)binding.getValue("arguments");
                if (arguments == null || arguments.isEmpty()) {
                    System.out.printf("    bind [%s] => %s\n", bindingKey, exchangeName);
                    continue;
                }
                System.out.printf("    bind [%s] => %s %s\n", bindingKey, exchangeName, arguments);
            }
        }
    }

    private void addExchange(String[] args) {
        if (args.length < 2) {
            this.usage();
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (this._durable) {
            properties.put("durable", true);
        }
        properties.put("exchange-type", args[0]);
        if (this._msgSequence) {
            properties.put(MSG_SEQUENCE, 1L);
        }
        if (this._ive) {
            properties.put(IVE, 1L);
        }
        if (this._altExchange != null) {
            properties.put("alternate-exchange", this._altExchange);
        }
        QmfData arguments = new QmfData();
        arguments.setValue("type", (Object)"exchange");
        arguments.setValue("name", (Object)args[1]);
        arguments.setValue("properties", properties);
        try {
            this._broker.invokeMethod("create", arguments);
        }
        catch (QmfException e) {
            System.out.println(e.getMessage());
        }
    }

    private void addQueue(String[] args) {
        if (args.length < 1) {
            this.usage();
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (String a : this.extraArguments) {
            String[] r = a.split("=");
            String value = r.length == 2 ? r[1] : null;
            properties.put(r[0], value);
        }
        if (this._durable) {
            properties.put("durable", true);
            properties.put(FILECOUNT, this._fileCount);
            properties.put(FILESIZE, this._fileSize);
        }
        if (this._maxQueueSize > 0L) {
            properties.put(MAX_QUEUE_SIZE, this._maxQueueSize);
        }
        if (this._maxQueueCount > 0L) {
            properties.put(MAX_QUEUE_COUNT, this._maxQueueCount);
        }
        if (this._limitPolicy.equals("reject")) {
            properties.put(POLICY_TYPE, "reject");
        } else if (this._limitPolicy.equals("flow-to-disk")) {
            properties.put(POLICY_TYPE, "flow_to_disk");
        } else if (this._limitPolicy.equals("ring")) {
            properties.put(POLICY_TYPE, "ring");
        } else if (this._limitPolicy.equals("ring-strict")) {
            properties.put(POLICY_TYPE, "ring_strict");
        }
        if (this._order.equals("lvq")) {
            properties.put(LVQ, 1L);
        } else if (this._order.equals("lvq-no-browse")) {
            properties.put(LVQNB, 1L);
        }
        if (this._eventGeneration > 0L) {
            properties.put(QUEUE_EVENT_GENERATION, this._eventGeneration);
        }
        if (this._altExchange != null) {
            properties.put("alternate-exchange", this._altExchange);
        }
        if (this._flowStopSize > 0L) {
            properties.put(FLOW_STOP_SIZE, this._flowStopSize);
        }
        if (this._flowResumeSize > 0L) {
            properties.put(FLOW_RESUME_SIZE, this._flowResumeSize);
        }
        if (this._flowStopCount > 0L) {
            properties.put(FLOW_STOP_COUNT, this._flowStopCount);
        }
        if (this._flowResumeCount > 0L) {
            properties.put(FLOW_RESUME_COUNT, this._flowResumeCount);
        }
        QmfData arguments = new QmfData();
        arguments.setValue("type", (Object)"queue");
        arguments.setValue("name", (Object)args[0]);
        arguments.setValue("properties", properties);
        try {
            this._broker.invokeMethod("create", arguments);
        }
        catch (QmfException e) {
            System.out.println(e.getMessage());
        }
    }

    private void delExchange(String[] args) {
        if (args.length < 1) {
            this.usage();
        }
        QmfData arguments = new QmfData();
        arguments.setValue("type", (Object)"exchange");
        arguments.setValue("name", (Object)args[0]);
        try {
            this._broker.invokeMethod("delete", arguments);
        }
        catch (QmfException e) {
            System.out.println(e.getMessage());
        }
    }

    private void delQueue(String[] args) {
        if (args.length < 1) {
            this.usage();
        }
        if (this._ifEmpty || this._ifUnused) {
            List queues = this._console.getObjects("org.apache.qpid.broker", "queue");
            for (QmfConsoleData queue : queues) {
                ObjectId queueId = queue.getObjectId();
                String name = queue.getStringValue("name");
                if (!name.equals(args[0])) continue;
                long msgDepth = queue.getLongValue("msgDepth");
                if (this._ifEmpty && msgDepth > 0L) {
                    System.out.println("Cannot delete queue " + name + "; queue not empty");
                    return;
                }
                long consumerCount = queue.getLongValue("consumerCount");
                if (!this._ifUnused || consumerCount <= 0L) continue;
                System.out.println("Cannot delete queue " + name + "; queue in use");
                return;
            }
        }
        QmfData arguments = new QmfData();
        arguments.setValue("type", (Object)"queue");
        arguments.setValue("name", (Object)args[0]);
        try {
            this._broker.invokeMethod("delete", arguments);
        }
        catch (QmfException e) {
            System.out.println(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bind(String[] args) {
        if (args.length < 2) {
            this.usage();
        }
        String exchangeType = null;
        List exchanges = this._console.getObjects("org.apache.qpid.broker", "exchange");
        for (QmfConsoleData exchange : exchanges) {
            String name = exchange.getStringValue("name");
            if (!args[0].equals(name)) continue;
            exchangeType = exchange.getStringValue("type");
            break;
        }
        if (exchangeType == null) {
            System.out.println("Exchange " + args[0] + " is invalid");
            return;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        if (exchangeType.equals("xml")) {
            if (this._file == null) {
                System.out.println("Invalid args to bind xml:  need an input file or stdin");
                return;
            }
            String xquery = null;
            if (this._file.equals("-")) {
                BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
                try {
                    String line;
                    StringBuilder buf = new StringBuilder();
                    while ((line = in.readLine()) != null) {
                        buf.append(line + "\n");
                    }
                    xquery = buf.toString();
                }
                catch (IOException ioe) {
                    System.out.println("Exception " + ioe + " while reading stdin");
                    return;
                }
            }
            File file = new File(this._file);
            try (FileInputStream fin = new FileInputStream(file);){
                byte[] content = new byte[(int)file.length()];
                fin.read(content);
                xquery = new String(content);
            }
            catch (FileNotFoundException e) {
                System.out.println("File " + this._file + " not found");
                return;
            }
            catch (IOException ioe) {
                System.out.println("Exception " + ioe + " while reading " + this._file);
                return;
            }
            properties.put("xquery", xquery);
        } else if (exchangeType.equals("headers")) {
            if (args.length < 5) {
                System.out.println("Invalid args to bind headers: need 'any'/'all' plus conditions");
                return;
            }
            String op = args[3];
            if (op.equals("all") || op.equals("any")) {
                String[] bindings;
                properties.put("x-match", op);
                for (String binding : bindings = Arrays.copyOfRange(args, 4, args.length)) {
                    if (!binding.contains("=")) continue;
                    binding = binding.split(",")[0];
                    String[] kv = binding.split("=");
                    properties.put(kv[0], kv[1]);
                }
            } else {
                System.out.println("Invalid condition arg to bind headers, need 'any' or 'all', not '" + op + "'");
                return;
            }
        }
        String bindingIdentifier = args[0] + "/" + args[1];
        if (args.length > 2) {
            bindingIdentifier = bindingIdentifier + "/" + args[2];
        }
        QmfData arguments = new QmfData();
        arguments.setValue("type", (Object)"binding");
        arguments.setValue("name", (Object)bindingIdentifier);
        arguments.setValue("properties", properties);
        try {
            this._broker.invokeMethod("create", arguments);
        }
        catch (QmfException e) {
            System.out.println(e.getMessage());
        }
    }

    private void unbind(String[] args) {
        if (args.length < 2) {
            this.usage();
        }
        String bindingIdentifier = args[0] + "/" + args[1];
        if (args.length > 2) {
            bindingIdentifier = bindingIdentifier + "/" + args[2];
        }
        QmfData arguments = new QmfData();
        arguments.setValue("type", (Object)"binding");
        arguments.setValue("name", (Object)bindingIdentifier);
        try {
            this._broker.invokeMethod("delete", arguments);
        }
        catch (QmfException e) {
            System.out.println(e.getMessage());
        }
    }

    public QpidConfig(String[] args) {
        String[] longOpts = new String[]{"help", "durable", "bindings", "broker-addr=", "file-count=", "file-size=", "max-queue-size=", "max-queue-count=", "limit-policy=", "order=", "sequence", "ive", "generate-queue-events=", "force", "force-if-not-empty", "force-if-used", "alternate-exchange=", "passive", "timeout=", "file=", "flow-stop-size=", "flow-resume-size=", "flow-stop-count=", "flow-resume-count=", "argument="};
        try {
            GetOpt getopt = new GetOpt(args, "ha:bf:", longOpts);
            List optList = getopt.getOptList();
            String[] cargs = new String[]{};
            cargs = getopt.getEncArgs().toArray(cargs);
            for (String[] opt : optList) {
                String[] validOrders;
                String[] validPolicies;
                if (opt[0].equals("-h") || opt[0].equals("--help")) {
                    this.options();
                }
                if (opt[0].equals("-b") || opt[0].equals("--bindings")) {
                    this._recursive = true;
                }
                if (opt[0].equals("-a") || opt[0].equals("--broker-addr")) {
                    this._host = opt[1];
                }
                if (opt[0].equals("-f") || opt[0].equals("--file")) {
                    this._file = opt[1];
                }
                if (opt[0].equals("--timeout")) {
                    this._connTimeout = Integer.parseInt(opt[1]);
                }
                if (opt[0].equals("--alternate-exchange")) {
                    this._altExchange = opt[1];
                }
                if (opt[0].equals("--passive")) {
                    this._passive = true;
                }
                if (opt[0].equals("--durable")) {
                    this._durable = true;
                }
                if (opt[0].equals("--file-count")) {
                    this._fileCount = Long.parseLong(opt[1]);
                }
                if (opt[0].equals("--file-size")) {
                    this._fileSize = Long.parseLong(opt[1]);
                }
                if (opt[0].equals("--max-queue-size")) {
                    this._maxQueueSize = Long.parseLong(opt[1]);
                }
                if (opt[0].equals("--max-queue-count")) {
                    this._maxQueueCount = Long.parseLong(opt[1]);
                }
                if (opt[0].equals("--limit-policy")) {
                    this._limitPolicy = opt[1];
                }
                if (opt[0].equals("--flow-stop-size")) {
                    this._flowStopSize = Long.parseLong(opt[1]);
                }
                if (opt[0].equals("--flow-resume-size")) {
                    this._flowResumeSize = Long.parseLong(opt[1]);
                }
                if (opt[0].equals("--flow-stop-count")) {
                    this._flowStopCount = Long.parseLong(opt[1]);
                }
                if (opt[0].equals("--flow-resume-count")) {
                    this._flowResumeCount = Long.parseLong(opt[1]);
                }
                boolean validPolicy = false;
                for (String i : validPolicies = new String[]{"none", "reject", "flow-to-disk", "ring", "ring-strict"}) {
                    if (!this._limitPolicy.equals(i)) continue;
                    validPolicy = true;
                    break;
                }
                if (!validPolicy) {
                    System.err.println("Error: Invalid --limit-policy argument");
                    System.exit(1);
                }
                if (opt[0].equals("--order")) {
                    this._order = opt[1];
                }
                boolean validOrder = false;
                for (String i : validOrders = new String[]{"fifo", "lvq", "lvq-no-browse"}) {
                    if (!this._order.equals(i)) continue;
                    validOrder = true;
                    break;
                }
                if (!validOrder) {
                    System.err.println("Error: Invalid --order argument");
                    System.exit(1);
                }
                if (opt[0].equals("--sequence")) {
                    this._msgSequence = true;
                }
                if (opt[0].equals("--ive")) {
                    this._ive = true;
                }
                if (opt[0].equals("--generate-queue-events")) {
                    this._eventGeneration = Long.parseLong(opt[1]);
                }
                if (opt[0].equals("--force")) {
                    this._ifEmpty = false;
                    this._ifUnused = false;
                }
                if (opt[0].equals("--force-if-not-empty")) {
                    this._ifEmpty = false;
                }
                if (opt[0].equals("--force-if-used")) {
                    this._ifUnused = false;
                }
                if (!opt[0].equals("--argument")) continue;
                this.extraArguments.add(opt[1]);
            }
            Connection connection = ConnectionHelper.createConnection((String)this._host, (String)"{reconnect: true}");
            this._console = new Console();
            this._console.disableEvents();
            this._console.addConnection(connection);
            List brokers = this._console.getObjects("org.apache.qpid.broker", "broker");
            if (brokers.isEmpty()) {
                System.out.println("No broker QmfConsoleData returned");
                System.exit(1);
            }
            this._broker = (QmfConsoleData)brokers.get(0);
            int nargs = cargs.length;
            if (nargs == 0) {
                this.overview();
            } else {
                String cmd = cargs[0];
                String modifier = "";
                if (nargs > 1) {
                    modifier = cargs[1];
                }
                if (cmd.equals("exchanges")) {
                    if (this._recursive) {
                        this.exchangeListRecurse(modifier);
                    } else {
                        this.exchangeList(modifier);
                    }
                } else if (cmd.equals("queues")) {
                    if (this._recursive) {
                        this.queueListRecurse(modifier);
                    } else {
                        this.queueList(modifier);
                    }
                } else if (cmd.equals("add")) {
                    if (modifier.equals("exchange")) {
                        this.addExchange(Arrays.copyOfRange(cargs, 2, cargs.length));
                    } else if (modifier.equals("queue")) {
                        this.addQueue(Arrays.copyOfRange(cargs, 2, cargs.length));
                    } else {
                        this.usage();
                    }
                } else if (cmd.equals("del")) {
                    if (modifier.equals("exchange")) {
                        this.delExchange(Arrays.copyOfRange(cargs, 2, cargs.length));
                    } else if (modifier.equals("queue")) {
                        this.delQueue(Arrays.copyOfRange(cargs, 2, cargs.length));
                    } else {
                        this.usage();
                    }
                } else if (cmd.equals("bind")) {
                    this.bind(Arrays.copyOfRange(cargs, 1, cargs.length));
                } else if (cmd.equals("unbind")) {
                    this.unbind(Arrays.copyOfRange(cargs, 1, cargs.length));
                } else {
                    this.usage();
                }
            }
        }
        catch (QmfException e) {
            System.err.println(e.toString());
            this.usage();
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.toString());
            this.usage();
        }
    }

    public static void main(String[] args) {
        String logLevel = System.getProperty("amqj.logging.level");
        logLevel = logLevel == null ? "FATAL" : logLevel;
        System.setProperty("amqj.logging.level", logLevel);
        System.setProperty("qpid.jms.daemon.dispatcher", "true");
        QpidConfig qpidConfig = new QpidConfig(args);
    }

    static {
        SPECIAL_ARGS.add(FILECOUNT);
        SPECIAL_ARGS.add(FILESIZE);
        SPECIAL_ARGS.add(MAX_QUEUE_SIZE);
        SPECIAL_ARGS.add(MAX_QUEUE_COUNT);
        SPECIAL_ARGS.add(POLICY_TYPE);
        SPECIAL_ARGS.add(LVQ);
        SPECIAL_ARGS.add(LVQNB);
        SPECIAL_ARGS.add(MSG_SEQUENCE);
        SPECIAL_ARGS.add(IVE);
        SPECIAL_ARGS.add(QUEUE_EVENT_GENERATION);
        SPECIAL_ARGS.add(FLOW_STOP_COUNT);
        SPECIAL_ARGS.add(FLOW_RESUME_COUNT);
        SPECIAL_ARGS.add(FLOW_STOP_SIZE);
        SPECIAL_ARGS.add(FLOW_RESUME_SIZE);
    }
}

