/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.qmf2.tools;

import java.io.File;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.Connection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.qpid.qmf2.common.ObjectId;
import org.apache.qpid.qmf2.common.QmfCallback;
import org.apache.qpid.qmf2.common.QmfData;
import org.apache.qpid.qmf2.common.QmfEvent;
import org.apache.qpid.qmf2.common.QmfEventListener;
import org.apache.qpid.qmf2.common.QmfException;
import org.apache.qpid.qmf2.common.WorkItem;
import org.apache.qpid.qmf2.console.AgentRestartedWorkItem;
import org.apache.qpid.qmf2.console.Console;
import org.apache.qpid.qmf2.console.EventReceivedWorkItem;
import org.apache.qpid.qmf2.console.QmfConsoleData;
import org.apache.qpid.qmf2.util.ConnectionHelper;
import org.apache.qpid.qmf2.util.GetOpt;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ConnectionAudit
implements QmfEventListener {
    private static final String _usage = "Usage: ConnectionAudit [options] [broker-addr]...\n";
    private static final String _description = "Audits connections to one or more Qpid message brokers.\nExchange and Queue names are checked against a whitelist and if no match is found an alert is generated.\n\nIf no broker-addr is supplied, ConnectionAudit connects to 'localhost:5672'.\n\n[broker-addr] syntax:\n\n[username/password@] hostname\nip-address [:<port>]\n\nExamples:\n\n$ ConnectionAudit localhost:5672\n$ ConnectionAudit 10.1.1.7:10000\n$ ConnectionAudit guest/guest@broker-host:10000\n";
    private static final String _options = "Options:\n  -h, --help            show this help message and exit\n  --sasl-mechanism=<mech>\n                        SASL mechanism for authentication (e.g. EXTERNAL,\n                        ANONYMOUS, PLAIN, CRAM-MD5, DIGEST-MD5, GSSAPI). SASL\n                        automatically picks the most secure available\n                        mechanism - use this option to override.\n  --whitelist=<whitelist XML document>\n                        The fully qualified name of the whitelist XML file,\n                        default is ./whitelist.xml\n";
    private final String _url;
    private final String _whitelist;
    private long _whitelistLastModified = 0L;
    private Console _console;
    private Set<String> _exchangeWhitelist = new HashSet<String>();
    private Set<String> _queueWhitelist = new HashSet<String>();

    public ConnectionAudit(String url, String connectionOptions, String whitelist) {
        System.out.println("Connecting to " + url);
        this._url = url;
        this._whitelist = whitelist;
        try {
            Connection connection = ConnectionHelper.createConnection((String)url, (String)connectionOptions);
            this._console = new Console((QmfCallback)this);
            this._console.addConnection(connection);
            this.checkExistingSubscriptions();
        }
        catch (QmfException qmfe) {
            System.err.println("QmfException " + qmfe.getMessage() + " caught in ConnectionAudit constructor");
        }
    }

    private void checkExistingSubscriptions() {
        this.readWhitelist();
        List subscriptions = this._console.getObjects("org.apache.qpid.broker", "subscription");
        for (QmfConsoleData subscription : subscriptions) {
            QmfConsoleData queue = this.dereference(subscription.getRefValue("queueRef"));
            QmfConsoleData session = this.dereference(subscription.getRefValue("sessionRef"));
            QmfConsoleData connection = this.dereference(session.getRefValue("connectionRef"));
            String queueName = queue.getStringValue("name");
            String address = connection.getStringValue("address");
            String timestamp = new Date(subscription.getCreateTime() / 1000000L).toString();
            this.validateQueue(queueName, address, timestamp);
        }
    }

    private QmfConsoleData dereference(ObjectId ref) {
        List data = this._console.getObjects((QmfData)ref);
        if (data.size() == 1) {
            return (QmfConsoleData)data.get(0);
        }
        return null;
    }

    private void validateQueue(String queueName, String exchangeName, QmfConsoleData binding, String address, String timestamp) {
        if (this._exchangeWhitelist.contains(exchangeName)) {
            return;
        }
        if (this._queueWhitelist.contains(queueName)) {
            return;
        }
        if (exchangeName.equals("")) {
            exchangeName = "''";
        }
        String bindingKey = binding.getStringValue("bindingKey");
        Map arguments = (Map)binding.getValue("arguments");
        if (arguments.isEmpty()) {
            System.out.printf("%s ALERT ConnectionAudit.validateQueue() validation failed for queue: %s with binding[%s] => %s from address: %s with connection timestamp %s\n\n", new Date().toString(), queueName, bindingKey, exchangeName, address, timestamp);
        } else {
            System.out.printf("%s ALERT ConnectionAudit.validateQueue() validation failed for queue: %s with binding[%s] => %s %s from address: %s with connection timestamp %s\n\n", new Date().toString(), queueName, bindingKey, exchangeName, arguments, address, timestamp);
        }
    }

    private void validateQueue(String queueName, String address, String timestamp) {
        ObjectId queueId = null;
        List queues = this._console.getObjects("org.apache.qpid.broker", "queue");
        for (QmfConsoleData queue : queues) {
            if (!queue.getStringValue("name").equals(queueName)) continue;
            queueId = queue.getObjectId();
            break;
        }
        if (queueId == null) {
            System.out.printf("%s ERROR ConnectionAudit.validateQueue() %s reference couldn't be found\n", new Date().toString(), queueName);
        } else {
            List bindings = this._console.getObjects("org.apache.qpid.broker", "binding");
            for (QmfConsoleData binding : bindings) {
                ObjectId queueRef = binding.getRefValue("queueRef");
                if (!queueRef.equals((Object)queueId)) continue;
                QmfConsoleData exchange = this.dereference(binding.getRefValue("exchangeRef"));
                String exchangeName = exchange.getStringValue("name");
                this.validateQueue(queueName, exchangeName, binding, address, timestamp);
            }
        }
    }

    public void onEvent(WorkItem wi) {
        if (wi instanceof EventReceivedWorkItem) {
            EventReceivedWorkItem item = (EventReceivedWorkItem)wi;
            QmfEvent event = item.getEvent();
            String className = event.getSchemaClassId().getClassName();
            if (className.equals("subscribe")) {
                this.readWhitelist();
                String queueName = event.getStringValue("qName");
                String address = event.getStringValue("rhost");
                String timestamp = new Date(event.getTimestamp() / 1000000L).toString();
                this.validateQueue(queueName, address, timestamp);
            }
        } else if (wi instanceof AgentRestartedWorkItem) {
            this.checkExistingSubscriptions();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readWhitelist() {
        File file = new File(this._whitelist);
        if (file.exists()) {
            long mtime = file.lastModified();
            if (mtime == this._whitelistLastModified) return;
            this._whitelistLastModified = mtime;
            this._exchangeWhitelist.clear();
            this._queueWhitelist.clear();
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = factory.newDocumentBuilder();
                Document doc = docBuilder.parse(file);
                Element whitelist = doc.getDocumentElement();
                if (!whitelist.getNodeName().equals("whitelist")) return;
                NodeList children = whitelist.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    Node node;
                    int j;
                    Node child = children.item(i);
                    if (child.getNodeName().equals("exchangeWhitelist")) {
                        NodeList exchanges = child.getChildNodes();
                        for (j = 0; j < exchanges.getLength(); ++j) {
                            node = exchanges.item(j);
                            if (!node.getNodeName().equals("exchange")) continue;
                            if (node.hasChildNodes()) {
                                String exchange = node.getFirstChild().getNodeValue();
                                this._exchangeWhitelist.add(exchange);
                                continue;
                            }
                            this._exchangeWhitelist.add("");
                        }
                        continue;
                    }
                    if (!child.getNodeName().equals("queueWhitelist")) continue;
                    NodeList queues = child.getChildNodes();
                    for (j = 0; j < queues.getLength(); ++j) {
                        node = queues.item(j);
                        if (!node.getNodeName().equals("queue") || !node.hasChildNodes()) continue;
                        String queue = node.getFirstChild().getNodeValue();
                        this._queueWhitelist.add(queue);
                    }
                }
                return;
            }
            catch (Exception e) {
                System.out.println("Exception " + e + " while reading " + this._whitelist);
                System.out.println(new Date().toString() + " WARN ConnectionAudit.readWhitelist() " + this._whitelist + " failed: " + e.getMessage());
                return;
            }
        }
        System.out.println(new Date().toString() + " WARN ConnectionAudit.readWhitelist() " + this._whitelist + " doesn't exist");
        this._exchangeWhitelist.clear();
        this._queueWhitelist.clear();
    }

    public static void main(String[] args) {
        String logLevel = System.getProperty("amqj.logging.level");
        logLevel = logLevel == null ? "FATAL" : logLevel;
        System.setProperty("amqj.logging.level", logLevel);
        String[] longOpts = new String[]{"help", "whitelist=", "sasl-mechanism="};
        try {
            String connectionOptions = "{reconnect: true}";
            String whitelist = "./whitelist.xml";
            GetOpt getopt = new GetOpt(args, "h", longOpts);
            List optList = getopt.getOptList();
            String[] cargs = new String[]{};
            cargs = getopt.getEncArgs().toArray(cargs);
            for (String[] opt : optList) {
                if (opt[0].equals("-h") || opt[0].equals("--help")) {
                    System.out.println(_usage);
                    System.out.println(_description);
                    System.out.println(_options);
                    System.exit(1);
                    continue;
                }
                if (opt[0].equals("--whitelist")) {
                    whitelist = opt[1];
                    continue;
                }
                if (!opt[0].equals("--sasl-mechanism")) continue;
                connectionOptions = "{reconnect: true, sasl_mechs: " + opt[1] + "}";
            }
            int nargs = cargs.length;
            if (nargs == 0) {
                cargs = new String[]{"localhost"};
            }
            for (String url : cargs) {
                ConnectionAudit eventPrinter = new ConnectionAudit(url, connectionOptions, whitelist);
            }
        }
        catch (IllegalArgumentException e) {
            System.out.println(_usage);
            System.exit(1);
        }
        try {
            Thread.currentThread().join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

