/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp;

import java.io.IOException;
import java.util.Map;
import javax.jms.InvalidClientIDException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.ResourceAllocationException;
import javax.jms.TransactionRolledBackException;
import org.apache.qpid.jms.provider.ProviderRedirectedException;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Modified;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.transaction.TransactionErrors;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.ConnectionError;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;

public class AmqpSupport {
    public static final Symbol SOLE_CONNECTION_CAPABILITY = Symbol.valueOf((String)"sole-connection-for-container");
    public static final Symbol ANONYMOUS_RELAY = Symbol.valueOf((String)"ANONYMOUS-RELAY");
    public static final Symbol CONNECTION_OPEN_FAILED = Symbol.valueOf((String)"amqp:connection-establishment-failed");
    public static final Symbol INVALID_FIELD = Symbol.valueOf((String)"invalid-field");
    public static final Symbol CONTAINER_ID = Symbol.valueOf((String)"container-id");
    public static final Symbol PORT = Symbol.valueOf((String)"port");
    public static final Symbol NETWORK_HOST = Symbol.valueOf((String)"network-host");
    public static final Symbol OPEN_HOSTNAME = Symbol.valueOf((String)"hostname");
    public static final Symbol QUEUE_PREFIX = Symbol.valueOf((String)"queue-prefix");
    public static final Symbol TOPIC_PREFIX = Symbol.valueOf((String)"topic-prefix");
    public static final Symbol PRODUCT = Symbol.valueOf((String)"product");
    public static final Symbol VERSION = Symbol.valueOf((String)"version");
    public static final Symbol PLATFORM = Symbol.valueOf((String)"platform");
    public static final Symbol COPY = Symbol.getSymbol((String)"copy");
    public static final Symbol JMS_NO_LOCAL_SYMBOL = Symbol.valueOf((String)"no-local");
    public static final Symbol JMS_SELECTOR_SYMBOL = Symbol.valueOf((String)"jms-selector");
    public static final Rejected REJECTED = new Rejected();
    public static final Modified MODIFIED_FAILED = new Modified();
    public static final Modified MODIFIED_FAILED_UNDELIVERABLE = new Modified();
    public static final Symbol DYNAMIC_NODE_LIFETIME_POLICY = Symbol.valueOf((String)"lifetime-policy");
    public static final String TEMP_QUEUE_CREATOR = "temp-queue-creator:";
    public static final String TEMP_TOPIC_CREATOR = "temp-topic-creator:";

    public static Exception convertToException(ErrorCondition errorCondition) {
        Object remoteError = null;
        if (errorCondition != null && errorCondition.getCondition() != null) {
            Map info;
            Symbol error = errorCondition.getCondition();
            String message = AmqpSupport.extractErrorMessage(errorCondition);
            remoteError = error.equals(AmqpError.UNAUTHORIZED_ACCESS) ? new JMSSecurityException(message) : (error.equals(AmqpError.RESOURCE_LIMIT_EXCEEDED) ? new ResourceAllocationException(message) : (error.equals(AmqpError.NOT_FOUND) ? new InvalidDestinationException(message) : (error.equals(TransactionErrors.TRANSACTION_ROLLBACK) ? new TransactionRolledBackException(message) : (error.equals(ConnectionError.REDIRECT) ? AmqpSupport.createRedirectException(error, message, errorCondition) : (error.equals(AmqpError.INVALID_FIELD) ? ((info = errorCondition.getInfo()) != null && CONTAINER_ID.equals(info.get(INVALID_FIELD)) ? new InvalidClientIDException(message) : new JMSException(message)) : new JMSException(message))))));
        } else {
            remoteError = new JMSException("Unknown error from remote peer");
        }
        return remoteError;
    }

    public static String extractErrorMessage(ErrorCondition errorCondition) {
        String message = "Received error from remote peer without description";
        if (errorCondition != null) {
            Symbol condition;
            if (errorCondition.getDescription() != null && !errorCondition.getDescription().isEmpty()) {
                message = errorCondition.getDescription();
            }
            if ((condition = errorCondition.getCondition()) != null) {
                message = message + " [condition = " + condition + "]";
            }
        }
        return message;
    }

    public static Exception createRedirectException(Symbol error, String message, ErrorCondition condition) {
        IOException result = null;
        Map info = condition.getInfo();
        if (info == null) {
            result = new IOException(message + " : Redirection information not set.");
        } else {
            String hostname = (String)info.get(OPEN_HOSTNAME);
            String networkHost = (String)info.get(NETWORK_HOST);
            if (networkHost == null || networkHost.isEmpty()) {
                result = new IOException(message + " : Redirection information not set.");
            }
            int port = 0;
            try {
                port = Integer.valueOf(info.get(PORT).toString());
            }
            catch (Exception ex) {
                result = new IOException(message + " : Redirection information not set.");
            }
            result = new ProviderRedirectedException(message, hostname, networkHost, port);
        }
        return result;
    }

    static {
        MODIFIED_FAILED.setDeliveryFailed(Boolean.valueOf(true));
        MODIFIED_FAILED_UNDELIVERABLE.setDeliveryFailed(Boolean.valueOf(true));
        MODIFIED_FAILED_UNDELIVERABLE.setUndeliverableHere(Boolean.valueOf(true));
    }
}

