/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import org.apache.qpid.jms.JmsConnection;
import org.apache.qpid.jms.jndi.JNDIStorable;

public abstract class JmsDestination
extends JNDIStorable
implements Externalizable,
Destination,
Comparable<JmsDestination> {
    private static final String NAME_PROP = "name";
    protected transient String name;
    protected transient boolean topic;
    protected transient boolean temporary;
    protected transient int hashValue;
    protected transient JmsConnection connection;

    protected JmsDestination(String name, boolean topic, boolean temporary) {
        this.name = name;
        this.topic = topic;
        this.temporary = temporary;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isTopic() {
        return this.topic;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public boolean isQueue() {
        return !this.topic;
    }

    @Override
    protected Map<String, String> buildFromProperties(Map<String, String> props) {
        this.setName(this.getProperty(props, NAME_PROP, ""));
        HashMap<String, String> unused = new HashMap<String, String>(props);
        unused.remove(NAME_PROP);
        return Collections.unmodifiableMap(unused);
    }

    @Override
    protected void populateProperties(Map<String, String> props) {
        props.put(NAME_PROP, this.getName());
    }

    @Override
    public int compareTo(JmsDestination other) {
        if (other != null) {
            if (this == other) {
                return 0;
            }
            if (this.isTemporary() == other.isTemporary()) {
                return this.getName().compareTo(other.getName());
            }
            return -1;
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JmsDestination other = (JmsDestination)o;
        if (this.name == null && other.name != null) {
            return false;
        }
        if (this.name != null && !this.name.equals(other.name)) {
            return false;
        }
        if (this.temporary != other.temporary) {
            return false;
        }
        return this.topic == other.topic;
    }

    public int hashCode() {
        if (this.hashValue == 0) {
            int prime = 31;
            this.hashValue = 1;
            this.hashValue = 31 * this.hashValue + (this.name == null ? 0 : this.name.hashCode());
            this.hashValue = 31 * this.hashValue + (this.temporary ? 1231 : 1237);
            this.hashValue = 31 * this.hashValue + (this.topic ? 1231 : 1237);
        }
        return this.hashValue;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.getName());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.setName(in.readUTF());
    }
}

