/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.apache.qpid.jms.JmsConnectionExtensions;
import org.apache.qpid.jms.JmsTemporaryDestination;
import org.apache.qpid.jms.message.JmsInboundMessageDispatch;
import org.apache.qpid.jms.message.JmsMessageFactory;
import org.apache.qpid.jms.message.JmsOutboundMessageDispatch;
import org.apache.qpid.jms.meta.JmsConnectionInfo;
import org.apache.qpid.jms.meta.JmsConsumerId;
import org.apache.qpid.jms.meta.JmsConsumerInfo;
import org.apache.qpid.jms.meta.JmsDefaultResourceVisitor;
import org.apache.qpid.jms.meta.JmsProducerId;
import org.apache.qpid.jms.meta.JmsProducerInfo;
import org.apache.qpid.jms.meta.JmsResource;
import org.apache.qpid.jms.meta.JmsResourceVistor;
import org.apache.qpid.jms.meta.JmsSessionId;
import org.apache.qpid.jms.meta.JmsSessionInfo;
import org.apache.qpid.jms.meta.JmsTransactionInfo;
import org.apache.qpid.jms.provider.AsyncResult;
import org.apache.qpid.jms.provider.NoOpAsyncResult;
import org.apache.qpid.jms.provider.Provider;
import org.apache.qpid.jms.provider.ProviderConstants;
import org.apache.qpid.jms.provider.ProviderException;
import org.apache.qpid.jms.provider.ProviderFuture;
import org.apache.qpid.jms.provider.ProviderFutureFactory;
import org.apache.qpid.jms.provider.ProviderListener;
import org.apache.qpid.jms.provider.ProviderSynchronization;
import org.apache.qpid.jms.provider.amqp.AmqpConnection;
import org.apache.qpid.jms.provider.amqp.AmqpConsumer;
import org.apache.qpid.jms.provider.amqp.AmqpEventSink;
import org.apache.qpid.jms.provider.amqp.AmqpExceptionBuilder;
import org.apache.qpid.jms.provider.amqp.AmqpProducer;
import org.apache.qpid.jms.provider.amqp.AmqpProtocolTracer;
import org.apache.qpid.jms.provider.amqp.AmqpRedirect;
import org.apache.qpid.jms.provider.amqp.AmqpResource;
import org.apache.qpid.jms.provider.amqp.AmqpResourceParent;
import org.apache.qpid.jms.provider.amqp.AmqpSaslAuthenticator;
import org.apache.qpid.jms.provider.amqp.AmqpSession;
import org.apache.qpid.jms.provider.amqp.AmqpTemporaryDestination;
import org.apache.qpid.jms.provider.amqp.builders.AmqpClosedConnectionBuilder;
import org.apache.qpid.jms.provider.amqp.builders.AmqpConnectionBuilder;
import org.apache.qpid.jms.provider.exceptions.ProviderClosedException;
import org.apache.qpid.jms.provider.exceptions.ProviderExceptionSupport;
import org.apache.qpid.jms.provider.exceptions.ProviderFailedException;
import org.apache.qpid.jms.provider.exceptions.ProviderIOException;
import org.apache.qpid.jms.provider.exceptions.ProviderIdleTimeoutException;
import org.apache.qpid.jms.provider.exceptions.ProviderIllegalStateException;
import org.apache.qpid.jms.provider.exceptions.ProviderOperationTimedOutException;
import org.apache.qpid.jms.provider.exceptions.ProviderTransactionInDoubtException;
import org.apache.qpid.jms.sasl.Mechanism;
import org.apache.qpid.jms.sasl.SaslMechanismFinder;
import org.apache.qpid.jms.sasl.SaslSecurityRuntimeException;
import org.apache.qpid.jms.transports.TransportListener;
import org.apache.qpid.jms.util.PropertyUtil;
import org.apache.qpid.jms.util.QpidJMSThreadFactory;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Collector;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Sasl;
import org.apache.qpid.proton.engine.SaslListener;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.engine.impl.CollectorImpl;
import org.apache.qpid.proton.engine.impl.ProtocolTracer;
import org.apache.qpid.proton.engine.impl.TransportImpl;
import org.apache.qpid.proton.engine.impl.TransportInternal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpProvider
implements Provider,
TransportListener,
AmqpResourceParent {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpProvider.class);
    private static final Logger TRACE_BYTES = LoggerFactory.getLogger((String)(AmqpConnection.class.getPackage().getName() + ".BYTES"));
    private static final Logger TRACE_FRAMES = LoggerFactory.getLogger((String)(AmqpConnection.class.getPackage().getName() + ".FRAMES"));
    private static final int DEFAULT_MAX_FRAME_SIZE = 0x100000;
    private static final int DEFAULT_CHANNEL_MAX = Short.MAX_VALUE;
    private static final AtomicInteger PROVIDER_SEQUENCE = new AtomicInteger();
    private static final NoOpAsyncResult NOOP_REQUEST = new NoOpAsyncResult();
    private static final int DEFAULT_MAX_WRITE_BYTES_BEFORE_FLUSH = 131072;
    private static final int DEFAULT_ANONYMOUS_FALLBACK_CACHE_TIMEOUT = 30000;
    private static final int DEFAULT_ANONYMOUS_FALLBACK_CACHE_SIZE = 1;
    private volatile ProviderListener listener;
    private volatile AmqpConnection connection;
    private AmqpSaslAuthenticator authenticator;
    private final org.apache.qpid.jms.transports.Transport transport;
    private String vhost;
    private boolean traceFrames;
    private int traceFramesPayloadLimit = 1024;
    private boolean traceBytes;
    private boolean saslLayer = true;
    private Set<String> saslMechanisms;
    private JmsConnectionInfo connectionInfo;
    private int channelMax = Short.MAX_VALUE;
    private int idleTimeout = 60000;
    private int drainTimeout = 60000;
    private long sessionOutoingWindow = -1L;
    private int maxFrameSize = 0x100000;
    private int maxWriteBytesBeforeFlush = 131072;
    private int anonymousFallbackCacheTimeout = 30000;
    private int anonymousFallbackCacheSize = 1;
    private boolean allowNonSecureRedirects;
    private final URI remoteURI;
    private final AtomicBoolean closed = new AtomicBoolean();
    private volatile Throwable failureCause;
    private ScheduledExecutorService serializer;
    private final Transport protonTransport = Transport.Factory.create();
    private final Collector protonCollector = new CollectorImpl();
    private final Connection protonConnection = Connection.Factory.create();
    private boolean protonTransportErrorHandled;
    private final ProviderFutureFactory futureFactory;
    private AsyncResult connectionRequest;
    private ScheduledFuture<?> nextIdleTimeoutCheck;
    private List<AsyncResult> failOnConnectionDropList = new ArrayList<AsyncResult>();

    public AmqpProvider(URI remoteURI, org.apache.qpid.jms.transports.Transport transport, ProviderFutureFactory futureFactory) {
        this.remoteURI = remoteURI;
        this.transport = transport;
        this.futureFactory = futureFactory;
    }

    @Override
    public void connect(JmsConnectionInfo connectionInfo) throws ProviderException {
        Map headers;
        Supplier proxyHandlerSupplier;
        this.checkClosedOrFailed();
        if (this.serializer != null) {
            throw new IllegalStateException("Connect cannot be called more than once");
        }
        ProviderFuture connectRequest = this.futureFactory.createFuture();
        QpidJMSThreadFactory transportThreadFactory = new QpidJMSThreadFactory("AmqpProvider :(" + PROVIDER_SEQUENCE.incrementAndGet() + "):[" + this.remoteURI.getScheme() + "://" + this.remoteURI.getHost() + ":" + this.remoteURI.getPort() + "]", true);
        this.transport.setThreadFactory(transportThreadFactory);
        this.transport.setTransportListener(this);
        this.transport.setMaxFrameSize(this.maxFrameSize);
        SSLContext sslContextOverride = connectionInfo.getExtensionMap().containsKey((Object)JmsConnectionExtensions.SSL_CONTEXT) ? (SSLContext)connectionInfo.getExtensionMap().get((Object)JmsConnectionExtensions.SSL_CONTEXT).apply(connectionInfo.getConnection(), this.transport.getRemoteLocation()) : null;
        if (connectionInfo.getExtensionMap().containsKey((Object)JmsConnectionExtensions.PROXY_HANDLER_SUPPLIER) && (proxyHandlerSupplier = (Supplier)connectionInfo.getExtensionMap().get((Object)JmsConnectionExtensions.PROXY_HANDLER_SUPPLIER).apply(connectionInfo.getConnection(), this.transport.getRemoteLocation())) != null) {
            this.transport.getTransportOptions().setProxyHandlerSupplier(proxyHandlerSupplier);
        }
        if (connectionInfo.getExtensionMap().containsKey((Object)JmsConnectionExtensions.HTTP_HEADERS_OVERRIDE) && (headers = (Map)connectionInfo.getExtensionMap().get((Object)JmsConnectionExtensions.HTTP_HEADERS_OVERRIDE).apply(connectionInfo.getConnection(), this.transport.getRemoteLocation())) != null) {
            this.transport.getTransportOptions().getHttpHeaders().putAll(headers);
        }
        try {
            this.serializer = this.transport.connect(() -> {
                this.connectionInfo = connectionInfo;
                this.connectionRequest = connectRequest;
                this.protonTransport.setEmitFlowEventOnSend(false);
                try {
                    ((TransportInternal)this.protonTransport).setUseReadOnlyOutputBuffer(false);
                }
                catch (NoSuchMethodError nsme) {
                    LOG.trace("Proton output buffer optimisation unavailable");
                }
                if (this.getMaxFrameSize() > 0) {
                    this.protonTransport.setMaxFrameSize(this.getMaxFrameSize());
                    this.protonTransport.setOutboundFrameSizeLimit(this.getMaxFrameSize());
                }
                this.protonTransport.setChannelMax(this.getChannelMax());
                this.protonTransport.setIdleTimeout(this.idleTimeout);
                this.protonTransport.bind(this.protonConnection);
                this.protonConnection.collect(this.protonCollector);
                if (this.saslLayer) {
                    Sasl sasl = this.protonTransport.sasl();
                    sasl.client();
                    String hostname = this.getVhost();
                    if (hostname == null) {
                        hostname = this.remoteURI.getHost();
                    } else if (hostname.isEmpty()) {
                        hostname = null;
                    }
                    sasl.setRemoteHostname(hostname);
                    sasl.setListener(new SaslListener(){

                        public void onSaslMechanisms(Sasl sasl, Transport transport) {
                            AmqpProvider.this.authenticator.handleSaslMechanisms(sasl, transport);
                            AmqpProvider.this.checkSaslAuthenticationState();
                        }

                        public void onSaslChallenge(Sasl sasl, Transport transport) {
                            AmqpProvider.this.authenticator.handleSaslChallenge(sasl, transport);
                            AmqpProvider.this.checkSaslAuthenticationState();
                        }

                        public void onSaslOutcome(Sasl sasl, Transport transport) {
                            AmqpProvider.this.authenticator.handleSaslOutcome(sasl, transport);
                            AmqpProvider.this.checkSaslAuthenticationState();
                        }

                        public void onSaslInit(Sasl sasl, Transport transport) {
                        }

                        public void onSaslResponse(Sasl sasl, Transport transport) {
                        }
                    });
                    this.authenticator = new AmqpSaslAuthenticator(remoteMechanisms -> this.findSaslMechanism((String[])remoteMechanisms));
                }
            }, sslContextOverride);
            this.serializer.execute(() -> this.pumpToProtonTransport());
            if (!this.saslLayer) {
                connectRequest.onSuccess();
            }
        }
        catch (Throwable t) {
            connectRequest.onFailure(ProviderExceptionSupport.createOrPassthroughFatal(t));
        }
        if (connectionInfo.getConnectTimeout() != -1L) {
            if (!connectRequest.sync(connectionInfo.getConnectTimeout(), TimeUnit.MILLISECONDS)) {
                throw new ProviderOperationTimedOutException("Timed out while waiting to connect");
            }
        } else {
            connectRequest.sync();
        }
    }

    @Override
    public void start() throws ProviderException, IllegalStateException {
        this.checkClosedOrFailed();
        if (this.listener == null) {
            throw new IllegalStateException("No ProviderListener registered.");
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            ProviderFuture request = this.futureFactory.createUnfailableFuture();
            if (this.serializer != null && !this.serializer.isShutdown()) {
                try {
                    this.serializer.execute(() -> {
                        try {
                            if (this.transport == null || !this.transport.isConnected()) {
                                request.onSuccess();
                                return;
                            }
                            if (this.connection != null) {
                                this.connection.close(request);
                            } else {
                                if (!(this.authenticator == null || this.authenticator.isComplete() && this.authenticator.wasSuccessful())) {
                                    request.onSuccess();
                                    return;
                                }
                                if (this.protonConnection.getLocalState() == EndpointState.UNINITIALIZED) {
                                    AmqpClosedConnectionBuilder builder = new AmqpClosedConnectionBuilder(this.getProvider(), this.connectionInfo);
                                    builder.buildResource(request);
                                    this.protonConnection.setContext((Object)builder);
                                } else {
                                    request.onSuccess();
                                }
                            }
                            this.pumpToProtonTransport(request);
                        }
                        catch (Exception e) {
                            LOG.debug("Caught exception while closing proton connection: {}", (Object)e.getMessage());
                        }
                        finally {
                            if (this.nextIdleTimeoutCheck != null) {
                                LOG.trace("Cancelling scheduled IdleTimeoutCheck");
                                this.nextIdleTimeoutCheck.cancel(false);
                                this.nextIdleTimeoutCheck = null;
                            }
                        }
                    });
                }
                catch (RejectedExecutionException rje) {
                    LOG.trace("Close of provider resources was rejected from Transport IO thread: ", (Throwable)rje);
                    request.onSuccess();
                }
            } else {
                request.onSuccess();
            }
            try {
                if (this.getCloseTimeout() < 0L) {
                    request.sync();
                } else {
                    request.sync(this.getCloseTimeout(), TimeUnit.MILLISECONDS);
                }
            }
            catch (ProviderException e) {
                LOG.warn("Error caught while closing Provider: {}", (Object)(e.getMessage() != null ? e.getMessage() : "<Unknown Error>"));
            }
            finally {
                if (this.transport != null) {
                    try {
                        this.transport.close();
                    }
                    catch (Exception e) {
                        LOG.debug("Caught exception while closing down Transport: {}", (Object)e.getMessage());
                    }
                }
            }
        }
    }

    @Override
    public void create(JmsResource resource, final AsyncResult request) throws ProviderException {
        this.checkClosedOrFailed();
        this.checkConnected();
        this.serializer.execute(() -> {
            try {
                this.checkClosedOrFailed();
                resource.visit(new JmsResourceVistor(){

                    @Override
                    public void processSessionInfo(JmsSessionInfo sessionInfo) throws Exception {
                        AmqpProvider.this.connection.createSession(sessionInfo, request);
                    }

                    @Override
                    public void processProducerInfo(JmsProducerInfo producerInfo) throws Exception {
                        AmqpSession session = AmqpProvider.this.connection.getSession(producerInfo.getParentId());
                        session.createProducer(producerInfo, request);
                    }

                    @Override
                    public void processConsumerInfo(JmsConsumerInfo consumerInfo) throws Exception {
                        AmqpSession session = consumerInfo.isConnectionConsumer() ? AmqpProvider.this.connection.getConnectionSession() : AmqpProvider.this.connection.getSession(consumerInfo.getParentId());
                        session.createConsumer(consumerInfo, request);
                    }

                    @Override
                    public void processConnectionInfo(JmsConnectionInfo connectionInfo) throws Exception {
                        AmqpProvider.this.connectionInfo = connectionInfo;
                        AmqpConnectionBuilder builder = new AmqpConnectionBuilder(AmqpProvider.this, connectionInfo);
                        AmqpProvider.this.connectionRequest = new AsyncResult(){
                            AtomicBoolean signalled = new AtomicBoolean();

                            @Override
                            public void onSuccess() {
                                if (this.signalled.compareAndSet(false, true)) {
                                    AmqpProvider.this.fireConnectionEstablished();
                                    request.onSuccess();
                                }
                            }

                            @Override
                            public void onFailure(ProviderException result) {
                                if (this.signalled.compareAndSet(false, true)) {
                                    request.onFailure(result);
                                }
                            }

                            @Override
                            public boolean isComplete() {
                                return request.isComplete();
                            }
                        };
                        builder.buildResource(AmqpProvider.this.connectionRequest);
                    }

                    @Override
                    public void processDestination(JmsTemporaryDestination destination) throws Exception {
                        if (destination.isTemporary()) {
                            AmqpProvider.this.connection.createTemporaryDestination(destination, request);
                        } else {
                            request.onSuccess();
                        }
                    }

                    @Override
                    public void processTransactionInfo(JmsTransactionInfo transactionInfo) throws Exception {
                        AmqpSession session = AmqpProvider.this.connection.getSession(transactionInfo.getSessionId());
                        session.begin(transactionInfo.getId(), request);
                    }
                });
                this.pumpToProtonTransport(request);
            }
            catch (Throwable t) {
                request.onFailure(ProviderExceptionSupport.createNonFatalOrPassthrough(t));
            }
        });
    }

    @Override
    public void start(JmsResource resource, final AsyncResult request) throws ProviderException {
        this.checkClosedOrFailed();
        this.checkConnected();
        this.serializer.execute(() -> {
            try {
                this.checkClosedOrFailed();
                resource.visit(new JmsDefaultResourceVisitor(){

                    @Override
                    public void processConsumerInfo(JmsConsumerInfo consumerInfo) throws Exception {
                        AmqpSession session = AmqpProvider.this.connection.getSession(consumerInfo.getParentId());
                        AmqpConsumer consumer = session.getConsumer(consumerInfo);
                        consumer.start(request);
                    }
                });
                this.pumpToProtonTransport(request);
            }
            catch (Throwable t) {
                request.onFailure(ProviderExceptionSupport.createNonFatalOrPassthrough(t));
            }
        });
    }

    @Override
    public void stop(JmsResource resource, final AsyncResult request) throws ProviderException {
        this.checkClosedOrFailed();
        this.checkConnected();
        this.serializer.execute(() -> {
            try {
                this.checkClosedOrFailed();
                resource.visit(new JmsDefaultResourceVisitor(){

                    @Override
                    public void processConsumerInfo(JmsConsumerInfo consumerInfo) throws Exception {
                        AmqpSession session = AmqpProvider.this.connection.getSession(consumerInfo.getParentId());
                        AmqpConsumer consumer = session.getConsumer(consumerInfo);
                        consumer.stop(request);
                    }
                });
                this.pumpToProtonTransport(request);
            }
            catch (Throwable t) {
                request.onFailure(ProviderExceptionSupport.createNonFatalOrPassthrough(t));
            }
        });
    }

    @Override
    public void destroy(JmsResource resource, final AsyncResult request) throws ProviderException {
        this.checkClosedOrFailed();
        this.checkConnected();
        this.serializer.execute(() -> {
            try {
                this.checkClosedOrFailed();
                resource.visit(new JmsDefaultResourceVisitor(){

                    @Override
                    public void processSessionInfo(JmsSessionInfo sessionInfo) throws Exception {
                        final AmqpSession session = AmqpProvider.this.connection.getSession(sessionInfo.getId());
                        session.close(new AsyncResult(){

                            @Override
                            public void onSuccess() {
                                this.onComplete();
                                request.onSuccess();
                            }

                            @Override
                            public void onFailure(ProviderException result) {
                                this.onComplete();
                                request.onFailure(result);
                            }

                            @Override
                            public boolean isComplete() {
                                return request.isComplete();
                            }

                            void onComplete() {
                                session.handleResourceClosure(AmqpProvider.this, null);
                            }
                        });
                    }

                    @Override
                    public void processProducerInfo(JmsProducerInfo producerInfo) throws Exception {
                        AmqpSession session = AmqpProvider.this.connection.getSession(producerInfo.getParentId());
                        AmqpProducer producer = session.getProducer(producerInfo);
                        producer.close(request);
                    }

                    @Override
                    public void processConsumerInfo(final JmsConsumerInfo consumerInfo) throws Exception {
                        AmqpSession session = AmqpProvider.this.connection.getSession(consumerInfo.getParentId());
                        AmqpConsumer consumer = session.getConsumer(consumerInfo);
                        consumer.close(new AsyncResult(){

                            @Override
                            public void onSuccess() {
                                this.onComplete();
                                request.onSuccess();
                            }

                            @Override
                            public void onFailure(ProviderException result) {
                                this.onComplete();
                                request.onFailure(result);
                            }

                            @Override
                            public boolean isComplete() {
                                return request.isComplete();
                            }

                            void onComplete() {
                                AmqpProvider.this.connection.getSubTracker().consumerRemoved(consumerInfo);
                            }
                        });
                    }

                    @Override
                    public void processConnectionInfo(JmsConnectionInfo connectionInfo) throws Exception {
                        AmqpProvider.this.connection.close(request);
                    }

                    @Override
                    public void processDestination(JmsTemporaryDestination destination) throws Exception {
                        AmqpTemporaryDestination temporary = AmqpProvider.this.connection.getTemporaryDestination(destination);
                        if (temporary != null) {
                            temporary.close(request);
                        } else {
                            LOG.debug("Could not find temporary destination {} to delete.", (Object)destination);
                            request.onSuccess();
                        }
                    }
                });
                this.pumpToProtonTransport(request);
            }
            catch (Throwable t) {
                request.onFailure(ProviderExceptionSupport.createNonFatalOrPassthrough(t));
            }
        });
    }

    @Override
    public void send(JmsOutboundMessageDispatch envelope, AsyncResult request) throws ProviderException {
        this.checkClosedOrFailed();
        this.checkConnected();
        this.serializer.execute(() -> {
            try {
                this.checkClosedOrFailed();
                JmsProducerId producerId = envelope.getProducerId();
                AmqpProducer producer = (AmqpProducer)producerId.getProviderHint();
                producer.send(envelope, request);
            }
            catch (Throwable t) {
                request.onFailure(ProviderExceptionSupport.createNonFatalOrPassthrough(t));
            }
        });
    }

    @Override
    public void acknowledge(JmsSessionId sessionId, ProviderConstants.ACK_TYPE ackType, AsyncResult request) throws ProviderException {
        this.checkClosedOrFailed();
        this.checkConnected();
        this.serializer.execute(() -> {
            try {
                this.checkClosedOrFailed();
                AmqpSession amqpSession = this.connection.getSession(sessionId);
                if (amqpSession == null) {
                    throw new ProviderIllegalStateException("Cannot acknowledge message from session that does not exist.");
                }
                amqpSession.acknowledge(ackType);
                this.pumpToProtonTransport(request);
                request.onSuccess();
            }
            catch (Throwable t) {
                request.onFailure(ProviderExceptionSupport.createNonFatalOrPassthrough(t));
            }
        });
    }

    @Override
    public void acknowledge(JmsInboundMessageDispatch envelope, ProviderConstants.ACK_TYPE ackType, AsyncResult request) throws ProviderException {
        this.checkClosedOrFailed();
        this.checkConnected();
        this.serializer.execute(() -> {
            try {
                this.checkClosedOrFailed();
                JmsConsumerId consumerId = envelope.getConsumerId();
                AmqpConsumer consumer = (AmqpConsumer)consumerId.getProviderHint();
                consumer.acknowledge(envelope, ackType);
                if (consumer.getSession().isAsyncAck()) {
                    request.onSuccess();
                    this.pumpToProtonTransport(request);
                } else {
                    this.pumpToProtonTransport(request, false);
                    request.onSuccess();
                    this.transport.flush();
                }
            }
            catch (Throwable t) {
                request.onFailure(ProviderExceptionSupport.createNonFatalOrPassthrough(t));
            }
        });
    }

    @Override
    public void commit(JmsTransactionInfo transactionInfo, JmsTransactionInfo nextTransactionId, AsyncResult request) throws ProviderException {
        this.checkClosedOrFailed();
        this.checkConnected();
        this.serializer.execute(() -> {
            try {
                this.checkClosedOrFailed();
                AmqpSession session = this.connection.getSession(transactionInfo.getSessionId());
                if (session == null) {
                    if (transactionInfo.isInDoubt()) {
                        throw new ProviderTransactionInDoubtException("Commit of in-doubt transaction failed because no session exists");
                    }
                    throw new ProviderIllegalStateException("Commit of transaction failed because no session exists");
                }
                session.commit(transactionInfo, nextTransactionId, request);
                this.pumpToProtonTransport(request);
            }
            catch (Throwable t) {
                request.onFailure(ProviderExceptionSupport.createNonFatalOrPassthrough(t));
            }
        });
    }

    @Override
    public void rollback(JmsTransactionInfo transactionInfo, JmsTransactionInfo nextTransactionId, AsyncResult request) throws ProviderException {
        this.checkClosedOrFailed();
        this.checkConnected();
        this.serializer.execute(() -> {
            try {
                this.checkClosedOrFailed();
                AmqpSession session = this.connection.getSession(transactionInfo.getSessionId());
                if (session == null) {
                    if (transactionInfo.isInDoubt()) {
                        throw new ProviderTransactionInDoubtException("Rollback of in-doubt transaction failed because no session exists");
                    }
                    throw new ProviderIllegalStateException("Rollback of transaction failed because no session exists");
                }
                session.rollback(transactionInfo, nextTransactionId, request);
                this.pumpToProtonTransport(request);
            }
            catch (Throwable t) {
                request.onFailure(ProviderExceptionSupport.createNonFatalOrPassthrough(t));
            }
        });
    }

    @Override
    public void recover(JmsSessionId sessionId, AsyncResult request) throws ProviderException {
        this.checkClosedOrFailed();
        this.checkConnected();
        this.serializer.execute(() -> {
            try {
                this.checkClosedOrFailed();
                AmqpSession session = this.connection.getSession(sessionId);
                if (session == null) {
                    throw new ProviderIllegalStateException("Cannot recover messages from session that does not exist");
                }
                session.recover();
                this.pumpToProtonTransport(request);
                request.onSuccess();
            }
            catch (Throwable t) {
                request.onFailure(ProviderExceptionSupport.createNonFatalOrPassthrough(t));
            }
        });
    }

    @Override
    public void unsubscribe(String subscription, AsyncResult request) throws ProviderException {
        this.checkClosedOrFailed();
        this.checkConnected();
        this.serializer.execute(() -> {
            try {
                this.checkClosedOrFailed();
                this.connection.unsubscribe(subscription, request);
                this.pumpToProtonTransport(request);
            }
            catch (Throwable t) {
                request.onFailure(ProviderExceptionSupport.createNonFatalOrPassthrough(t));
            }
        });
    }

    @Override
    public void pull(JmsConsumerId consumerId, long timeout, AsyncResult request) throws ProviderException {
        this.checkClosedOrFailed();
        this.checkConnected();
        this.serializer.execute(() -> {
            try {
                this.checkClosedOrFailed();
                AmqpConsumer consumer = (AmqpConsumer)consumerId.getProviderHint();
                consumer.pull(timeout, request);
                this.pumpToProtonTransport(request);
            }
            catch (Throwable t) {
                request.onFailure(ProviderExceptionSupport.createNonFatalOrPassthrough(t));
            }
        });
    }

    private void updateTracer() {
        if (this.isTraceFrames()) {
            ((TransportImpl)this.protonTransport).setProtocolTracer((ProtocolTracer)new AmqpProtocolTracer(TRACE_FRAMES, System.identityHashCode(this.protonTransport), this.traceFramesPayloadLimit));
        }
    }

    public void scheduleExecuteAndPump(Runnable task) {
        this.serializer.execute(() -> {
            try {
                try {
                    task.run();
                }
                finally {
                    this.pumpToProtonTransport();
                }
            }
            catch (Throwable t) {
                LOG.warn("Caught problem during task processing: {}", (Object)t.getMessage(), (Object)t);
                this.fireProviderException(ProviderExceptionSupport.createNonFatalOrPassthrough(t));
            }
        });
    }

    @Override
    public void onData(ByteBuf input) {
        try {
            if (this.isTraceBytes()) {
                TRACE_BYTES.info("Received: {}", (Object)ByteBufUtil.hexDump((ByteBuf)input));
            }
            if (this.protonTransportErrorHandled) {
                LOG.trace("Skipping data processing, proton transport previously errored.");
                return;
            }
            do {
                ByteBuffer buffer = this.protonTransport.tail();
                int chunkSize = Math.min(buffer.remaining(), input.readableBytes());
                buffer.limit(buffer.position() + chunkSize);
                input.readBytes(buffer);
                this.protonTransport.process();
            } while (input.isReadable());
            this.processUpdates();
            this.pumpToProtonTransport();
        }
        catch (Throwable t) {
            LOG.warn("Caught problem during data processing: {}", (Object)t.getMessage(), (Object)t);
            this.fireProviderException(ProviderExceptionSupport.createOrPassthroughFatal(t));
        }
    }

    @Override
    public void onTransportError(Throwable error) {
        if (!this.serializer.isShutdown()) {
            this.serializer.execute(() -> {
                LOG.info("Transport failed: {}", (Object)error.getMessage());
                if (!this.closed.get()) {
                    this.protonTransport.close_head();
                    this.fireProviderException(ProviderExceptionSupport.createOrPassthroughFatal(error));
                }
            });
        }
    }

    @Override
    public void onTransportClosed() {
        if (!this.serializer.isShutdown()) {
            this.serializer.execute(() -> {
                LOG.debug("Transport connection remotely closed");
                if (!this.closed.get()) {
                    this.protonTransport.close_head();
                    this.fireProviderException(new ProviderFailedException("Transport connection remotely closed."));
                }
            });
        }
    }

    private void checkSaslAuthenticationState() {
        try {
            if (this.authenticator.isComplete()) {
                if (!this.authenticator.wasSuccessful()) {
                    Transport t = this.protonConnection.getTransport();
                    t.close_head();
                    this.connectionRequest.onFailure(this.authenticator.getFailureCause());
                } else {
                    this.connectionRequest.onSuccess();
                    this.authenticator = null;
                }
            }
        }
        catch (Throwable ex) {
            try {
                Transport t = this.protonConnection.getTransport();
                t.close_head();
            }
            finally {
                this.fireProviderException(ProviderExceptionSupport.createOrPassthroughFatal(ex));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUpdates() {
        try {
            Event protonEvent = null;
            while ((protonEvent = this.protonCollector.peek()) != null) {
                if (!protonEvent.getType().equals((Object)Event.Type.TRANSPORT)) {
                    LOG.trace("New Proton Event: {}", (Object)protonEvent.getType());
                }
                AmqpEventSink amqpEventSink = null;
                switch (protonEvent.getType()) {
                    case CONNECTION_REMOTE_CLOSE: {
                        amqpEventSink = (AmqpEventSink)protonEvent.getConnection().getContext();
                        if (amqpEventSink == null) break;
                        amqpEventSink.processRemoteClose(this);
                        break;
                    }
                    case CONNECTION_REMOTE_OPEN: {
                        amqpEventSink = (AmqpEventSink)protonEvent.getConnection().getContext();
                        if (amqpEventSink == null) break;
                        amqpEventSink.processRemoteOpen(this);
                        break;
                    }
                    case SESSION_REMOTE_CLOSE: {
                        amqpEventSink = (AmqpEventSink)protonEvent.getSession().getContext();
                        if (amqpEventSink == null) break;
                        amqpEventSink.processRemoteClose(this);
                        break;
                    }
                    case SESSION_REMOTE_OPEN: {
                        amqpEventSink = (AmqpEventSink)protonEvent.getSession().getContext();
                        if (amqpEventSink == null) break;
                        amqpEventSink.processRemoteOpen(this);
                        break;
                    }
                    case LINK_REMOTE_CLOSE: {
                        amqpEventSink = (AmqpEventSink)protonEvent.getLink().getContext();
                        if (amqpEventSink == null) break;
                        amqpEventSink.processRemoteClose(this);
                        break;
                    }
                    case LINK_REMOTE_DETACH: {
                        amqpEventSink = (AmqpEventSink)protonEvent.getLink().getContext();
                        if (amqpEventSink == null) break;
                        amqpEventSink.processRemoteDetach(this);
                        break;
                    }
                    case LINK_REMOTE_OPEN: {
                        amqpEventSink = (AmqpEventSink)protonEvent.getLink().getContext();
                        if (amqpEventSink == null) break;
                        amqpEventSink.processRemoteOpen(this);
                        break;
                    }
                    case LINK_FLOW: {
                        amqpEventSink = (AmqpEventSink)protonEvent.getLink().getContext();
                        if (amqpEventSink == null) break;
                        amqpEventSink.processFlowUpdates(this);
                        break;
                    }
                    case DELIVERY: {
                        amqpEventSink = (AmqpEventSink)protonEvent.getLink().getContext();
                        if (amqpEventSink == null) break;
                        amqpEventSink.processDeliveryUpdates(this, (Delivery)protonEvent.getContext());
                        break;
                    }
                    case TRANSPORT_ERROR: {
                        if (this.authenticator != null && (!this.authenticator.isComplete() || !this.authenticator.wasSuccessful())) break;
                        this.protonTransportErrorHandled = true;
                        ErrorCondition transportCondition = this.protonTransport.getCondition();
                        String message = AmqpProvider.extractTransportErrorMessage(transportCondition);
                        this.protonConnection.setCondition(transportCondition);
                        this.protonConnection.close();
                        throw new ProviderFailedException(message);
                    }
                }
                this.protonCollector.pop();
            }
        }
        catch (Throwable t) {
            try {
                LOG.warn("Caught problem during update processing: {}", (Object)t.getMessage(), (Object)t);
            }
            finally {
                this.fireProviderException(ProviderExceptionSupport.createOrPassthroughFatal(t));
            }
        }
    }

    private static String extractTransportErrorMessage(ErrorCondition errorCondition) {
        String message = "Error without description from proton Transport";
        if (errorCondition != null) {
            Symbol condition;
            if (errorCondition.getDescription() != null && !errorCondition.getDescription().isEmpty()) {
                message = "Error in proton Transport: " + errorCondition.getDescription();
            }
            if ((condition = errorCondition.getCondition()) != null) {
                message = message + " [condition = " + condition + "]";
            }
        }
        return message;
    }

    protected boolean pumpToProtonTransport() {
        return this.pumpToProtonTransport(NOOP_REQUEST, true);
    }

    protected boolean pumpToProtonTransport(AsyncResult request) {
        return this.pumpToProtonTransport(request, true);
    }

    protected boolean pumpToProtonTransport(AsyncResult request, boolean flush) {
        try {
            boolean done = false;
            int bytesWritten = 0;
            while (!done) {
                ByteBuffer toWrite = this.protonTransport.getOutputBuffer();
                if (toWrite != null && toWrite.hasRemaining()) {
                    ByteBuf outbound = this.transport.allocateSendBuffer(toWrite.remaining());
                    outbound.writeBytes(toWrite);
                    if (this.isTraceBytes()) {
                        TRACE_BYTES.info("Sending: {}", (Object)ByteBufUtil.hexDump((ByteBuf)outbound));
                    }
                    if (flush && (bytesWritten += outbound.readableBytes()) >= this.getMaxWriteBytesBeforeFlush()) {
                        this.transport.flush();
                        bytesWritten = 0;
                    }
                    this.transport.write(outbound);
                    this.protonTransport.outputConsumed();
                    continue;
                }
                done = true;
            }
            if (flush && bytesWritten > 0) {
                this.transport.flush();
            }
        }
        catch (Throwable thrown) {
            ProviderIOException pex = ProviderExceptionSupport.createOrPassthroughFatal(thrown);
            this.fireProviderException(pex);
            request.onFailure(pex);
            return false;
        }
        return true;
    }

    void fireConnectionEstablished() {
        ProviderListener listener;
        this.connectionRequest = null;
        long now = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
        long deadline = this.protonTransport.tick(now);
        if (deadline != 0L) {
            long delay = deadline - now;
            LOG.trace("IdleTimeoutCheck being initiated, initial delay: {}", (Object)delay);
            this.nextIdleTimeoutCheck = this.serializer.schedule(new IdleTimeoutCheck(), delay, TimeUnit.MILLISECONDS);
        }
        if ((listener = this.listener) != null) {
            listener.onConnectionEstablished(this.remoteURI);
        }
    }

    void fireNonFatalProviderException(ProviderException ex) {
        ProviderListener listener = this.listener;
        if (listener != null) {
            listener.onProviderException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireProviderException(ProviderException ex) {
        if (this.connectionRequest != null) {
            this.connectionRequest.onFailure(ex);
            this.connectionRequest = null;
        }
        if (this.nextIdleTimeoutCheck != null) {
            this.nextIdleTimeoutCheck.cancel(true);
            this.nextIdleTimeoutCheck = null;
        }
        this.failureCause = ex;
        ProviderListener listener = this.listener;
        try {
            if (listener != null) {
                listener.onConnectionFailure(ProviderExceptionSupport.createNonFatalOrPassthrough(ex));
            }
        }
        finally {
            for (AsyncResult request : this.failOnConnectionDropList) {
                request.onFailure(ex);
            }
        }
    }

    void fireResourceClosed(JmsResource resource, ProviderException cause) {
        ProviderListener listener = this.listener;
        if (listener != null) {
            listener.onResourceClosed(resource, cause);
        }
    }

    @Override
    public void addChildResource(AmqpResource resource) {
        if (resource instanceof AmqpConnection) {
            this.connection = (AmqpConnection)resource;
        }
    }

    @Override
    public void removeChildResource(AmqpResource resource) {
    }

    @Override
    public JmsMessageFactory getMessageFactory() {
        if (this.connection == null) {
            throw new RuntimeException("Message Factory is not accessible when not connected.");
        }
        return this.connection.getAmqpMessageFactory();
    }

    @Override
    public ProviderFuture newProviderFuture() {
        return this.futureFactory.createFuture();
    }

    @Override
    public ProviderFuture newProviderFuture(ProviderSynchronization synchronization) {
        return this.futureFactory.createFuture(synchronization);
    }

    public void setTraceFrames(boolean trace) {
        this.traceFrames = trace;
        this.updateTracer();
    }

    public boolean isTraceFrames() {
        return this.traceFrames;
    }

    public int getTraceFramesPayloadLimit() {
        return this.traceFramesPayloadLimit;
    }

    public void setTraceFramesPayloadLimit(int traceFramesPayloadLimit) {
        this.traceFramesPayloadLimit = traceFramesPayloadLimit;
    }

    public void setTraceBytes(boolean trace) {
        this.traceBytes = trace;
    }

    public boolean isTraceBytes() {
        return this.traceBytes;
    }

    public boolean isSaslLayer() {
        return this.saslLayer;
    }

    public void setSaslLayer(boolean saslLayer) {
        this.saslLayer = saslLayer;
    }

    public Set<String> getSaslMechanisms() {
        return this.saslMechanisms;
    }

    public void setSaslMechanisms(String[] saslMechanisms) {
        HashSet<String> saslMechanismSet = null;
        if (saslMechanisms != null && saslMechanisms.length > 0) {
            HashSet<String> mechs = new HashSet<String>();
            for (int i = 0; i < saslMechanisms.length; ++i) {
                String mech = saslMechanisms[i];
                if (mech.trim().isEmpty()) continue;
                mechs.add(mech);
            }
            if (!mechs.isEmpty()) {
                saslMechanismSet = mechs;
            }
        }
        this.saslMechanisms = saslMechanismSet;
    }

    public String getVhost() {
        return this.vhost;
    }

    public void setVhost(String vhost) {
        this.vhost = vhost;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public int getDrainTimeout() {
        return this.drainTimeout;
    }

    public void setDrainTimeout(int drainTimeout) {
        this.drainTimeout = drainTimeout;
    }

    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public int getMaxWriteBytesBeforeFlush() {
        return this.maxWriteBytesBeforeFlush;
    }

    public void setMaxWriteBytesBeforeFlush(int maxWriteBytesBeforeFlush) {
        this.maxWriteBytesBeforeFlush = maxWriteBytesBeforeFlush;
    }

    public int getAnonymousFallbackCacheSize() {
        return this.anonymousFallbackCacheSize;
    }

    public void setAnonymousFallbackCacheSize(int size) {
        this.anonymousFallbackCacheSize = size;
    }

    public int getAnonymousFallbackCacheTimeout() {
        return this.anonymousFallbackCacheTimeout;
    }

    public void setAnonymousFallbackCacheTimeout(int timeout) {
        this.anonymousFallbackCacheTimeout = timeout;
    }

    public void setMaxFrameSize(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }

    public long getSessionOutgoingWindow() {
        return this.sessionOutoingWindow;
    }

    public void setSessionOutgoingWindow(long sessionOutoingWindow) {
        this.sessionOutoingWindow = sessionOutoingWindow;
    }

    public boolean isAllowNonSecureRedirects() {
        return this.allowNonSecureRedirects;
    }

    public void setAllowNonSecureRedirects(boolean allowNonSecureRedirects) {
        this.allowNonSecureRedirects = allowNonSecureRedirects;
    }

    public long getCloseTimeout() {
        return this.connectionInfo != null ? this.connectionInfo.getCloseTimeout() : 60000L;
    }

    public long getConnectTimeout() {
        return this.connectionInfo != null ? this.connectionInfo.getConnectTimeout() : 15000L;
    }

    public long getRequestTimeout() {
        return this.connectionInfo != null ? this.connectionInfo.getRequestTimeout() : -1L;
    }

    public long getSendTimeout() {
        return this.connectionInfo != null ? this.connectionInfo.getSendTimeout() : -1L;
    }

    public String toString() {
        return "AmqpProvider: " + this.getRemoteURI().getHost() + ":" + this.getRemoteURI().getPort();
    }

    public int getChannelMax() {
        return this.channelMax;
    }

    public void setChannelMax(int channelMax) {
        this.channelMax = channelMax;
    }

    public org.apache.qpid.jms.transports.Transport getTransport() {
        return this.transport;
    }

    @Override
    public void setProviderListener(ProviderListener listener) {
        this.listener = listener;
    }

    @Override
    public ProviderListener getProviderListener() {
        return this.listener;
    }

    @Override
    public URI getRemoteURI() {
        return this.remoteURI;
    }

    public Throwable getFailureCause() {
        return this.failureCause;
    }

    public boolean isFailed() {
        return this.failureCause != null;
    }

    @Override
    public List<URI> getAlternateURIs() {
        List<AmqpRedirect> failoverList;
        ArrayList<URI> alternates = null;
        if (this.connection != null && !(failoverList = this.connection.getProperties().getFailoverServerList()).isEmpty()) {
            alternates = new ArrayList<URI>();
            for (AmqpRedirect redirect : failoverList) {
                try {
                    alternates.add(redirect.toURI());
                }
                catch (Exception ex) {
                    LOG.trace("Error while creating URI from failover server: {}", (Object)redirect);
                }
            }
        }
        if (alternates != null) {
            return alternates;
        }
        return Collections.emptyList();
    }

    public Transport getProtonTransport() {
        return this.protonTransport;
    }

    public Connection getProtonConnection() {
        return this.protonConnection;
    }

    ScheduledExecutorService getScheduler() {
        return this.serializer;
    }

    @Override
    public AmqpProvider getProvider() {
        return this;
    }

    public ScheduledFuture<?> scheduleRequestTimeout(AsyncResult request, long timeout, ProviderException error) {
        if (timeout != -1L) {
            return this.serializer.schedule(() -> {
                request.onFailure(error);
                this.pumpToProtonTransport();
            }, timeout, TimeUnit.MILLISECONDS);
        }
        return null;
    }

    public ScheduledFuture<?> scheduleRequestTimeout(AsyncResult request, long timeout, AmqpExceptionBuilder builder) {
        if (timeout != -1L) {
            return this.serializer.schedule(() -> {
                request.onFailure(builder.createException());
                this.pumpToProtonTransport();
            }, timeout, TimeUnit.MILLISECONDS);
        }
        return null;
    }

    public void addToFailOnConnectionDropTracking(AsyncResult result) {
        this.failOnConnectionDropList.add(result);
    }

    public void removeFromFailOnConnectionDropTracking(AsyncResult result) {
        this.failOnConnectionDropList.remove(result);
    }

    private void checkClosedOrFailed() throws ProviderException {
        if (this.closed.get()) {
            throw new ProviderClosedException("This Provider is already closed");
        }
        if (this.failureCause != null) {
            throw new ProviderFailedException("The Provider has failed", this.failureCause);
        }
    }

    private void checkConnected() throws ProviderException {
        if (this.serializer == null) {
            throw new ProviderClosedException("Transport has not been properly connected.");
        }
    }

    private Mechanism findSaslMechanism(String[] remoteMechanisms) throws SaslSecurityRuntimeException {
        String username = this.connectionInfo.getExtensionMap().containsKey((Object)JmsConnectionExtensions.USERNAME_OVERRIDE) ? (String)this.connectionInfo.getExtensionMap().get((Object)JmsConnectionExtensions.USERNAME_OVERRIDE).apply(this.connectionInfo.getConnection(), this.transport.getRemoteLocation()) : this.connectionInfo.getUsername();
        String password = this.connectionInfo.getExtensionMap().containsKey((Object)JmsConnectionExtensions.PASSWORD_OVERRIDE) ? (String)this.connectionInfo.getExtensionMap().get((Object)JmsConnectionExtensions.PASSWORD_OVERRIDE).apply(this.connectionInfo.getConnection(), this.transport.getRemoteLocation()) : this.connectionInfo.getPassword();
        Mechanism mechanism = SaslMechanismFinder.findMatchingMechanism(username, password, this.transport.getLocalPrincipal(), this.saslMechanisms, remoteMechanisms);
        mechanism.setUsername(username);
        mechanism.setPassword(password);
        try {
            Map<String, String> saslOptions = PropertyUtil.filterProperties(PropertyUtil.parseQuery(this.getRemoteURI()), "sasl.options.");
            if (!saslOptions.containsKey("serverName")) {
                saslOptions.put("serverName", this.remoteURI.getHost());
            }
            mechanism.init(Collections.unmodifiableMap(saslOptions));
        }
        catch (Exception ex) {
            throw new SaslSecurityRuntimeException("Failed to apply sasl options to mechanism: " + mechanism.getName() + ", reason: " + ex.toString(), ex);
        }
        return mechanism;
    }

    private final class IdleTimeoutCheck
    implements Runnable {
        private IdleTimeoutCheck() {
        }

        @Override
        public void run() {
            boolean checkScheduled = false;
            if (AmqpProvider.this.connection.getLocalState() == EndpointState.ACTIVE) {
                long now = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
                long deadline = AmqpProvider.this.protonTransport.tick(now);
                boolean pumpSucceeded = AmqpProvider.this.pumpToProtonTransport();
                if (AmqpProvider.this.protonTransport.isClosed()) {
                    LOG.info("IdleTimeoutCheck closed the transport due to the peer exceeding our requested idle-timeout.");
                    if (pumpSucceeded) {
                        AmqpProvider.this.fireProviderException(new ProviderIdleTimeoutException("Transport closed due to the peer exceeding our requested idle-timeout"));
                    }
                } else if (deadline != 0L) {
                    long delay = deadline - now;
                    checkScheduled = true;
                    LOG.trace("IdleTimeoutCheck rescheduling with delay: {}", (Object)delay);
                    AmqpProvider.this.nextIdleTimeoutCheck = AmqpProvider.this.serializer.schedule(this, delay, TimeUnit.MILLISECONDS);
                }
            } else {
                LOG.trace("IdleTimeoutCheck skipping check, connection is not active.");
            }
            if (!checkScheduled) {
                AmqpProvider.this.nextIdleTimeoutCheck = null;
                LOG.trace("IdleTimeoutCheck exiting");
            }
        }
    }
}

