/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.message;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import org.apache.qpid.jms.JmsDestination;
import org.apache.qpid.jms.exceptions.JmsExceptionSupport;
import org.apache.qpid.jms.message.facade.JmsMessageFacade;
import org.apache.qpid.jms.util.TypeConversionSupport;

public class JmsMessagePropertyIntercepter {
    private static final Map<String, PropertyIntercepter> PROPERTY_INTERCEPTERS = new HashMap<String, PropertyIntercepter>();
    private static final Set<String> STANDARD_HEADERS = new HashSet<String>();

    public static Object getProperty(JmsMessageFacade message, String name) throws JMSException {
        Object value = null;
        PropertyIntercepter jmsPropertyExpression = PROPERTY_INTERCEPTERS.get(name);
        value = jmsPropertyExpression != null ? jmsPropertyExpression.getProperty(message) : message.getProperty(name);
        return value;
    }

    public static void setProperty(JmsMessageFacade message, String name, Object value) throws JMSException {
        PropertyIntercepter jmsPropertyExpression = PROPERTY_INTERCEPTERS.get(name);
        if (jmsPropertyExpression != null) {
            jmsPropertyExpression.setProperty(message, value);
        } else {
            message.setProperty(name, value);
        }
    }

    public static boolean propertyExists(JmsMessageFacade message, String name) throws JMSException {
        PropertyIntercepter jmsPropertyExpression = PROPERTY_INTERCEPTERS.get(name);
        if (jmsPropertyExpression != null) {
            return jmsPropertyExpression.propertyExists(message);
        }
        return message.propertyExists(name);
    }

    public static void clearProperties(JmsMessageFacade message, boolean excludeStandardJMSHeaders) throws JMSException {
        for (Map.Entry<String, PropertyIntercepter> entry : PROPERTY_INTERCEPTERS.entrySet()) {
            if (excludeStandardJMSHeaders && STANDARD_HEADERS.contains(entry.getKey())) continue;
            entry.getValue().clearProperty(message);
        }
        message.clearProperties();
    }

    public static Set<String> getAllPropertyNames(JmsMessageFacade message) throws JMSException {
        HashSet<String> names = new HashSet<String>(PROPERTY_INTERCEPTERS.keySet());
        names.addAll(message.getPropertyNames());
        return names;
    }

    public static Set<String> getPropertyNames(JmsMessageFacade message, boolean excludeStandardJMSHeaders) throws JMSException {
        HashSet<String> names = new HashSet<String>();
        for (Map.Entry<String, PropertyIntercepter> entry : PROPERTY_INTERCEPTERS.entrySet()) {
            if (excludeStandardJMSHeaders && STANDARD_HEADERS.contains(entry.getKey()) || !entry.getValue().propertyExists(message)) continue;
            names.add(entry.getKey());
        }
        names.addAll(message.getPropertyNames());
        return names;
    }

    static {
        STANDARD_HEADERS.add("JMSMessageID");
        STANDARD_HEADERS.add("JMSTimestamp");
        STANDARD_HEADERS.add("JMSCorrelationID");
        STANDARD_HEADERS.add("JMSReplyTo");
        STANDARD_HEADERS.add("JMSDestination");
        STANDARD_HEADERS.add("JMSDeliveryMode");
        STANDARD_HEADERS.add("JMSRedelivered");
        STANDARD_HEADERS.add("JMSType");
        STANDARD_HEADERS.add("JMSExpiration");
        STANDARD_HEADERS.add("JMSPriority");
        PROPERTY_INTERCEPTERS.put("JMSDestination", new PropertyIntercepter(){

            @Override
            public void setProperty(JmsMessageFacade message, Object value) throws JMSException {
                throw new JMSException("Cannot set JMS Destination as a property, use setJMSDestination() instead");
            }

            @Override
            public Object getProperty(JmsMessageFacade message) throws JMSException {
                JmsDestination dest = message.getDestination();
                if (dest == null) {
                    return null;
                }
                return ((Object)dest).toString();
            }

            @Override
            public boolean propertyExists(JmsMessageFacade message) {
                return message.getDestination() != null;
            }

            @Override
            public void clearProperty(JmsMessageFacade message) {
                message.setDestination(null);
            }
        });
        PROPERTY_INTERCEPTERS.put("JMSReplyTo", new PropertyIntercepter(){

            @Override
            public void setProperty(JmsMessageFacade message, Object value) throws JMSException {
                throw new JMSException("Cannot set JMS ReplyTo as a property, use setJMSReplTo() instead");
            }

            @Override
            public Object getProperty(JmsMessageFacade message) throws JMSException {
                if (message.getReplyTo() == null) {
                    return null;
                }
                return message.getReplyTo().toString();
            }

            @Override
            public boolean propertyExists(JmsMessageFacade message) {
                return message.getReplyTo() != null;
            }

            @Override
            public void clearProperty(JmsMessageFacade message) {
                message.setReplyTo(null);
            }
        });
        PROPERTY_INTERCEPTERS.put("JMSType", new PropertyIntercepter(){

            @Override
            public Object getProperty(JmsMessageFacade message) throws JMSException {
                return message.getType();
            }

            @Override
            public void setProperty(JmsMessageFacade message, Object value) throws JMSException {
                String rc = (String)TypeConversionSupport.convert(value, String.class);
                if (rc == null) {
                    throw new JMSException("Property JMSType cannot be set from a " + value.getClass().getName() + ".");
                }
                message.setType(rc);
            }

            @Override
            public boolean propertyExists(JmsMessageFacade message) {
                return message.getType() != null;
            }

            @Override
            public void clearProperty(JmsMessageFacade message) {
                message.setType(null);
            }
        });
        PROPERTY_INTERCEPTERS.put("JMSDeliveryMode", new PropertyIntercepter(){

            @Override
            public Object getProperty(JmsMessageFacade message) throws JMSException {
                return message.isPersistent() ? "PERSISTENT" : "NON_PERSISTENT";
            }

            @Override
            public void setProperty(JmsMessageFacade message, Object value) throws JMSException {
                Integer rc;
                block9: {
                    rc = null;
                    try {
                        rc = (Integer)TypeConversionSupport.convert(value, Integer.class);
                    }
                    catch (NumberFormatException nfe) {
                        if (value instanceof String) {
                            if (((String)value).equalsIgnoreCase("PERSISTENT")) {
                                rc = 2;
                            } else if (((String)value).equalsIgnoreCase("NON_PERSISTENT")) {
                                rc = 1;
                            }
                        }
                        if (rc != null) break block9;
                        throw nfe;
                    }
                }
                if (rc == null) {
                    Boolean bool = (Boolean)TypeConversionSupport.convert(value, Boolean.class);
                    if (bool == null) {
                        throw new JMSException("Property JMSDeliveryMode cannot be set from a " + value.getClass().getName() + ".");
                    }
                    message.setPersistent(bool);
                } else {
                    message.setPersistent(rc == 2);
                }
            }

            @Override
            public boolean propertyExists(JmsMessageFacade message) {
                return true;
            }

            @Override
            public void clearProperty(JmsMessageFacade message) {
                message.setPersistent(true);
            }
        });
        PROPERTY_INTERCEPTERS.put("JMSPriority", new PropertyIntercepter(){

            @Override
            public Object getProperty(JmsMessageFacade message) throws JMSException {
                return message.getPriority();
            }

            @Override
            public void setProperty(JmsMessageFacade message, Object value) throws JMSException {
                Integer rc = (Integer)TypeConversionSupport.convert(value, Integer.class);
                if (rc == null) {
                    throw new JMSException("Property JMSPriority cannot be set from a " + value.getClass().getName() + ".");
                }
                message.setPriority(rc.byteValue());
            }

            @Override
            public boolean propertyExists(JmsMessageFacade message) {
                return true;
            }

            @Override
            public void clearProperty(JmsMessageFacade message) {
                message.setPriority(4);
            }
        });
        PROPERTY_INTERCEPTERS.put("JMSMessageID", new PropertyIntercepter(){

            @Override
            public Object getProperty(JmsMessageFacade message) throws JMSException {
                if (message.getMessageId() == null) {
                    return null;
                }
                return message.getMessageId();
            }

            @Override
            public void setProperty(JmsMessageFacade message, Object value) throws JMSException {
                String rc = (String)TypeConversionSupport.convert(value, String.class);
                if (rc == null) {
                    throw new JMSException("Property JMSMessageID cannot be set from a " + value.getClass().getName() + ".");
                }
                message.setMessageId(rc);
            }

            @Override
            public boolean propertyExists(JmsMessageFacade message) {
                return message.getMessageId() != null;
            }

            @Override
            public void clearProperty(JmsMessageFacade message) {
                message.setMessageId(null);
            }
        });
        PROPERTY_INTERCEPTERS.put("JMSTimestamp", new PropertyIntercepter(){

            @Override
            public Object getProperty(JmsMessageFacade message) throws JMSException {
                return message.getTimestamp();
            }

            @Override
            public void setProperty(JmsMessageFacade message, Object value) throws JMSException {
                Long rc = (Long)TypeConversionSupport.convert(value, Long.class);
                if (rc == null) {
                    throw new JMSException("Property JMSTimestamp cannot be set from a " + value.getClass().getName() + ".");
                }
                message.setTimestamp(rc);
            }

            @Override
            public boolean propertyExists(JmsMessageFacade message) {
                return message.getTimestamp() > 0L;
            }

            @Override
            public void clearProperty(JmsMessageFacade message) {
                message.setTimestamp(0L);
            }
        });
        PROPERTY_INTERCEPTERS.put("JMSCorrelationID", new PropertyIntercepter(){

            @Override
            public Object getProperty(JmsMessageFacade message) throws JMSException {
                return message.getCorrelationId();
            }

            @Override
            public void setProperty(JmsMessageFacade message, Object value) throws JMSException {
                String rc = (String)TypeConversionSupport.convert(value, String.class);
                if (rc == null) {
                    throw new JMSException("Property JMSCorrelationID cannot be set from a " + value.getClass().getName() + ".");
                }
                message.setCorrelationId(rc);
            }

            @Override
            public boolean propertyExists(JmsMessageFacade message) {
                return message.getCorrelationId() != null;
            }

            @Override
            public void clearProperty(JmsMessageFacade message) throws JMSException {
                message.setCorrelationId(null);
            }
        });
        PROPERTY_INTERCEPTERS.put("JMSExpiration", new PropertyIntercepter(){

            @Override
            public Object getProperty(JmsMessageFacade message) throws JMSException {
                return message.getExpiration();
            }

            @Override
            public void setProperty(JmsMessageFacade message, Object value) throws JMSException {
                Long rc = (Long)TypeConversionSupport.convert(value, Long.class);
                if (rc == null) {
                    throw new JMSException("Property JMSExpiration cannot be set from a " + value.getClass().getName() + ".");
                }
                message.setExpiration(rc);
            }

            @Override
            public boolean propertyExists(JmsMessageFacade message) {
                return message.getExpiration() > 0L;
            }

            @Override
            public void clearProperty(JmsMessageFacade message) {
                message.setExpiration(0L);
            }
        });
        PROPERTY_INTERCEPTERS.put("JMSRedelivered", new PropertyIntercepter(){

            @Override
            public Object getProperty(JmsMessageFacade message) throws JMSException {
                return message.isRedelivered();
            }

            @Override
            public void setProperty(JmsMessageFacade message, Object value) throws JMSException {
                Boolean rc = (Boolean)TypeConversionSupport.convert(value, Boolean.class);
                if (rc == null) {
                    throw new JMSException("Property JMSRedelivered cannot be set from a " + value.getClass().getName() + ".");
                }
                message.setRedelivered(rc);
            }

            @Override
            public boolean propertyExists(JmsMessageFacade message) {
                return message.isRedelivered();
            }

            @Override
            public void clearProperty(JmsMessageFacade message) {
                message.setRedelivered(false);
            }
        });
        PROPERTY_INTERCEPTERS.put("JMSXDeliveryCount", new PropertyIntercepter(){

            @Override
            public void setProperty(JmsMessageFacade message, Object value) throws JMSException {
                Integer rc = (Integer)TypeConversionSupport.convert(value, Integer.class);
                if (rc == null) {
                    throw new JMSException("Property JMSXDeliveryCount cannot be set from a " + value.getClass().getName() + ".");
                }
                message.setDeliveryCount(rc);
            }

            @Override
            public Object getProperty(JmsMessageFacade message) throws JMSException {
                return message.getDeliveryCount();
            }

            @Override
            public boolean propertyExists(JmsMessageFacade message) {
                return true;
            }

            @Override
            public void clearProperty(JmsMessageFacade message) {
                message.setDeliveryCount(1);
            }
        });
        PROPERTY_INTERCEPTERS.put("JMSXGroupID", new PropertyIntercepter(){

            @Override
            public Object getProperty(JmsMessageFacade message) throws JMSException {
                return message.getGroupId();
            }

            @Override
            public void setProperty(JmsMessageFacade message, Object value) throws JMSException {
                String rc = (String)TypeConversionSupport.convert(value, String.class);
                if (rc == null) {
                    throw new JMSException("Property JMSXGroupID cannot be set from a " + value.getClass().getName() + ".");
                }
                message.setGroupId(rc);
            }

            @Override
            public boolean propertyExists(JmsMessageFacade message) {
                return message.getGroupId() != null;
            }

            @Override
            public void clearProperty(JmsMessageFacade message) {
                message.setGroupId(null);
            }
        });
        PROPERTY_INTERCEPTERS.put("JMSXGroupSeq", new PropertyIntercepter(){

            @Override
            public Object getProperty(JmsMessageFacade message) throws JMSException {
                return message.getGroupSequence();
            }

            @Override
            public void setProperty(JmsMessageFacade message, Object value) throws JMSException {
                Integer rc = (Integer)TypeConversionSupport.convert(value, Integer.class);
                if (rc == null) {
                    throw new JMSException("Property JMSXGroupSeq cannot be set from a " + value.getClass().getName() + ".");
                }
                message.setGroupSequence(rc);
            }

            @Override
            public boolean propertyExists(JmsMessageFacade message) {
                return message.getGroupSequence() != 0;
            }

            @Override
            public void clearProperty(JmsMessageFacade message) {
                message.setGroupSequence(0);
            }
        });
        PROPERTY_INTERCEPTERS.put("JMSXUserID", new PropertyIntercepter(){

            @Override
            public Object getProperty(JmsMessageFacade message) throws JMSException {
                Object userId = message.getUserId();
                if (userId == null) {
                    try {
                        userId = message.getProperty("JMSXUserID");
                    }
                    catch (Exception e) {
                        throw JmsExceptionSupport.create(e);
                    }
                }
                return userId;
            }

            @Override
            public void setProperty(JmsMessageFacade message, Object value) throws JMSException {
                if (!(value instanceof String)) {
                    throw new JMSException("Property JMSXUserID cannot be set from a " + value.getClass().getName() + ".");
                }
                message.setUserId((String)value);
            }

            @Override
            public boolean propertyExists(JmsMessageFacade message) {
                return message.getUserId() != null;
            }

            @Override
            public void clearProperty(JmsMessageFacade message) {
                message.setUserId(null);
            }
        });
    }

    static interface PropertyIntercepter {
        public Object getProperty(JmsMessageFacade var1) throws JMSException;

        public void setProperty(JmsMessageFacade var1, Object var2) throws JMSException;

        public boolean propertyExists(JmsMessageFacade var1);

        public void clearProperty(JmsMessageFacade var1) throws JMSException;
    }
}

